/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webharvest.definition.BaseElementDef;
import org.webharvest.definition.RegexpDef;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.BodyProcessor;
import org.webharvest.runtime.scripting.ScriptEngine;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.ListVariable;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class RegexpProcessor
extends BaseProcessor {
    private RegexpDef regexpDef;

    public RegexpProcessor(RegexpDef regexpDef) {
        super(regexpDef);
        this.regexpDef = regexpDef;
    }

    @Override
    public Variable execute(Scraper scraper, ScraperContext context) {
        ScriptEngine scriptEngine = scraper.getScriptEngine();
        BaseElementDef patternDef = this.regexpDef.getRegexpPatternDef();
        Variable patternVar = this.getBodyTextContent(patternDef, scraper, context, true);
        this.debug(patternDef, scraper, patternVar);
        BaseElementDef sourceDef = this.regexpDef.getRegexpSourceDef();
        Variable source = new BodyProcessor(sourceDef).run(scraper, context);
        this.debug(sourceDef, scraper, source);
        String replace = BaseTemplater.execute(this.regexpDef.getReplace(), scriptEngine);
        boolean isReplace = CommonUtil.isBooleanTrue(replace);
        boolean flagCaseInsensitive = CommonUtil.getBooleanValue(BaseTemplater.execute(this.regexpDef.getFlagCaseInsensitive(), scriptEngine), false);
        boolean flagMultiline = CommonUtil.getBooleanValue(BaseTemplater.execute(this.regexpDef.getFlagMultiline(), scriptEngine), false);
        boolean flagDotall = CommonUtil.getBooleanValue(BaseTemplater.execute(this.regexpDef.getFlagDotall(), scriptEngine), true);
        boolean flagUnicodecase = CommonUtil.getBooleanValue(BaseTemplater.execute(this.regexpDef.getFlagUnicodecase(), scriptEngine), true);
        boolean flagCanoneq = CommonUtil.getBooleanValue(BaseTemplater.execute(this.regexpDef.getFlagCanoneq(), scriptEngine), false);
        this.setProperty("Is replacing", String.valueOf(isReplace));
        this.setProperty("Flag CaseInsensitive", String.valueOf(flagCaseInsensitive));
        this.setProperty("Flag MultiLine", String.valueOf(flagMultiline));
        this.setProperty("Flag DotAll", String.valueOf(flagDotall));
        this.setProperty("Flag UnicodeCase", String.valueOf(flagUnicodecase));
        this.setProperty("Flag CanonEq", String.valueOf(flagCanoneq));
        String maxLoopsString = BaseTemplater.execute(this.regexpDef.getMax(), scriptEngine);
        double maxLoops = 1.0E9;
        if (maxLoopsString != null && !"".equals(maxLoopsString.trim())) {
            maxLoops = Double.parseDouble(maxLoopsString);
        }
        this.setProperty("Max loops", String.valueOf(maxLoops));
        int flags = 0;
        if (flagCaseInsensitive) {
            flags |= 2;
        }
        if (flagMultiline) {
            flags |= 8;
        }
        if (flagDotall) {
            flags |= 0x20;
        }
        if (flagUnicodecase) {
            flags |= 0x40;
        }
        if (flagCanoneq) {
            flags |= 0x80;
        }
        Pattern pattern = Pattern.compile(patternVar.toString(), flags);
        ArrayList<NodeVariable> resultList = new ArrayList<NodeVariable>();
        List bodyList = source.toList();
        for (Variable currVar : bodyList) {
            String text = currVar.toString();
            Matcher matcher = pattern.matcher(text);
            int groupCount = matcher.groupCount();
            StringBuffer buffer = new StringBuffer();
            int index = 0;
            while (matcher.find() && !(maxLoops < (double)(++index))) {
                String currResult;
                for (int i = 0; i <= groupCount; ++i) {
                    context.put("_" + i, new NodeVariable(matcher.group(i)));
                }
                BaseElementDef resultDef = this.regexpDef.getRegexpResultDef();
                Variable result = this.getBodyTextContent(resultDef, scraper, context, true);
                this.debug(resultDef, scraper, result);
                String string = currResult = result == null ? matcher.group(0) : result.toString();
                if (isReplace) {
                    matcher.appendReplacement(buffer, currResult);
                } else {
                    resultList.add(new NodeVariable(currResult));
                }
                for (int i = 0; i <= groupCount; ++i) {
                    context.remove("_" + i);
                }
            }
            if (!isReplace) continue;
            matcher.appendTail(buffer);
            resultList.add(new NodeVariable(buffer.toString()));
        }
        return new ListVariable(resultList);
    }
}

