/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.beans.editor.BooleanAsCheckBoxPropertyEditor;
import com.l2fprod.common.beans.editor.ColorPropertyEditor;
import com.l2fprod.common.beans.editor.DimensionPropertyEditor;
import com.l2fprod.common.beans.editor.DoublePropertyEditor;
import com.l2fprod.common.beans.editor.FilePropertyEditor;
import com.l2fprod.common.beans.editor.FloatPropertyEditor;
import com.l2fprod.common.beans.editor.FontPropertyEditor;
import com.l2fprod.common.beans.editor.InsetsPropertyEditor;
import com.l2fprod.common.beans.editor.IntegerPropertyEditor;
import com.l2fprod.common.beans.editor.LongPropertyEditor;
import com.l2fprod.common.beans.editor.RectanglePropertyEditor;
import com.l2fprod.common.beans.editor.ShortPropertyEditor;
import com.l2fprod.common.beans.editor.StringPropertyEditor;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class PropertyEditorRegistry {
    private Map typeToEditor = new HashMap();
    private Map propertyToEditor = new HashMap();

    public PropertyEditorRegistry() {
        this.registerDefaults();
    }

    public synchronized PropertyEditor getEditor(Property property) {
        PropertyEditor editor = null;
        Object value = this.propertyToEditor.get(property);
        if (value instanceof PropertyEditor) {
            editor = (PropertyEditor)value;
        } else if (value instanceof Class) {
            try {
                editor = (PropertyEditor)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            editor = this.getEditor(property.getType());
        }
        return editor;
    }

    public synchronized PropertyEditor getEditor(Class type) {
        PropertyEditor editor = null;
        Object value = this.typeToEditor.get(type);
        if (value instanceof PropertyEditor) {
            editor = (PropertyEditor)value;
        } else if (value instanceof Class) {
            try {
                editor = (PropertyEditor)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return editor;
    }

    public synchronized void registerEditor(Class type, Class editorClass) {
        this.typeToEditor.put(type, editorClass);
    }

    public synchronized void registerEditor(Class type, PropertyEditor editor) {
        this.typeToEditor.put(type, editor);
    }

    public synchronized void unregisterEditor(Class type) {
        this.typeToEditor.remove(type);
    }

    public synchronized void registerEditor(Property property, Class editorClass) {
        this.propertyToEditor.put(property, editorClass);
    }

    public synchronized void registerEditor(Property property, PropertyEditor editor) {
        this.propertyToEditor.put(property, editor);
    }

    public synchronized void unregisterEditor(Property property) {
        this.propertyToEditor.remove(property);
    }

    public void registerDefaults() {
        this.typeToEditor.clear();
        this.propertyToEditor.clear();
        this.registerEditor(String.class, StringPropertyEditor.class);
        this.registerEditor(Double.TYPE, DoublePropertyEditor.class);
        this.registerEditor(Double.class, DoublePropertyEditor.class);
        this.registerEditor(Float.TYPE, FloatPropertyEditor.class);
        this.registerEditor(Float.class, FloatPropertyEditor.class);
        this.registerEditor(Integer.TYPE, IntegerPropertyEditor.class);
        this.registerEditor(Integer.class, IntegerPropertyEditor.class);
        this.registerEditor(Long.TYPE, LongPropertyEditor.class);
        this.registerEditor(Long.class, LongPropertyEditor.class);
        this.registerEditor(Short.TYPE, ShortPropertyEditor.class);
        this.registerEditor(Short.class, ShortPropertyEditor.class);
        this.registerEditor(Boolean.TYPE, BooleanAsCheckBoxPropertyEditor.class);
        this.registerEditor(Boolean.class, BooleanAsCheckBoxPropertyEditor.class);
        this.registerEditor(File.class, FilePropertyEditor.class);
        this.registerEditor(Color.class, ColorPropertyEditor.class);
        this.registerEditor(Dimension.class, DimensionPropertyEditor.class);
        this.registerEditor(Insets.class, InsetsPropertyEditor.class);
        this.registerEditor(Font.class, FontPropertyEditor.class);
        this.registerEditor(Rectangle.class, RectanglePropertyEditor.class);
    }
}

