/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class TupleExpression
extends Expression {
    private List expressions;

    public TupleExpression() {
        this(new ArrayList());
    }

    public TupleExpression(List expressions) {
        this.expressions = expressions;
    }

    public TupleExpression(Expression[] expressionArray) {
        this();
        this.expressions.addAll(Arrays.asList(expressionArray));
    }

    public void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitTupleExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        TupleExpression ret = new TupleExpression(this.transformExpressions(this.getExpressions(), transformer));
        ret.setSourcePosition(this);
        return ret;
    }

    public Expression getExpression(int i) {
        return (Expression)this.expressions.get(i);
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer("(");
        boolean first = true;
        Iterator iter = this.expressions.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(((Expression)iter.next()).getText());
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String toString() {
        return super.toString() + this.expressions;
    }
}

