/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email.renderers;

import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.ui.email.helpers.EmailBeanConstant;
import com.jurismarches.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.AbstractNavTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;

public class EmailCellRenderer
extends AbstractNavTreeCellRenderer<DefaultTreeModel, VradiTreeNode> {
    private static final long serialVersionUID = 7917305304778635796L;
    protected static final Log log = LogFactory.getLog(EmailCellRenderer.class);

    public EmailCellRenderer(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
    }

    protected String computeNodeText(VradiTreeNode node) {
        Class editType = node.getInternalClass();
        String id = node.getId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Compute node text for bean with type " + editType + " and id " + id));
        }
        EmailBeanConstant constant = EmailBeanConstant.getConstantByBeanClass(editType);
        BusinessEntity bean = constant.getBean((VradiDataProvider)this.getDataProvider(), id);
        Session session = EmailNavigationTreeHelper.getParentSession(node);
        String decorated = constant.decorate(session, bean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Compute text for node " + (Object)((Object)node) + " return " + decorated));
        }
        return decorated;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        VradiTreeNode node = (VradiTreeNode)((Object)value);
        String text = this.getNodeText((NavNode)node);
        return super.getTreeCellRendererComponent(tree, (Object)text, sel, expanded, leaf, row, hasFocus);
    }
}

