/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.email.EmailContentUI;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.email.QueryMakerViewUI;
import com.jurismarches.vradi.ui.email.SendingViewUI;
import com.jurismarches.vradi.ui.email.SessionViewUI;
import com.jurismarches.vradi.ui.email.helpers.EmailBeanConstant;
import com.jurismarches.vradi.ui.email.helpers.EmailDataHelper;
import com.jurismarches.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListHandler;
import com.jurismarches.vradi.ui.offer.OfferTable;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.task.AbstractProgressBarUI;
import com.jurismarches.vradi.ui.task.VradiTask;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.sun.star.lang.IllegalArgumentException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.nav.NavHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyProxy;

public class EmailHandler {
    private static final Log log = LogFactory.getLog(EmailHandler.class);

    public EmailPopupUI init(JAXXContext rootContext) {
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(rootContext);
        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
            ui = new EmailPopupUI((JAXXContext)context);
            VradiContext.EMAIL_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        }
        return ui;
    }

    public EmailPopupUI getUI(JAXXContext context) {
        if (context instanceof EmailPopupUI) {
            return (EmailPopupUI)context;
        }
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    public SessionViewUI getSessionsListUI(JAXXContext context) {
        if (context instanceof SessionViewUI) {
            return (SessionViewUI)context;
        }
        return (SessionViewUI)context.getContextValue(SessionViewUI.class);
    }

    public SendingViewUI getSessionViewUI(JAXXContext context) {
        if (context instanceof SendingViewUI) {
            return (SendingViewUI)context;
        }
        return (SendingViewUI)context.getContextValue(SendingViewUI.class);
    }

    public VradiStorageService getStorageService() {
        return VradiService.getVradiStorageService();
    }

    public WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    protected void close(JAXXContext context) {
        EmailPopupUI ui = this.getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    public List<Session> getSessions(Date date) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSessions for date : " + date));
        }
        List sessions = null;
        try {
            sessions = this.getStorageService().getSessions(date);
        }
        catch (VradiException eee) {
            log.error((Object)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        return sessions;
    }

    public void createNewSession(EmailPopupUI ui) {
        try {
            Session session = this.getStorageService().createNewSession();
            UIHelper.selectNodeLater((NavHelper)ui.getHelper(), session.getWikittyId());
        }
        catch (VradiException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create new session", (Throwable)ex);
            }
            JOptionPane.showMessageDialog(ui, I18n._((String)"Can't create new session for reason : %s", (Object[])new Object[]{ex.getMessage()}), I18n._((String)"Can't create new session"), 0);
        }
    }

    public void bindEmailsWithForms(final EmailPopupUI ui) {
        VradiTask<Void> task = new VradiTask<Void>((JAXXContext)ui){

            @Override
            public Void doAction() throws Exception {
                try {
                    Session selectedSession = ui.getHelper().getSelectedActiveSession();
                    if (selectedSession == null) {
                        throw new IllegalArgumentException("No active session selected");
                    }
                    EmailHandler.this.getStorageService().bindForms(selectedSession);
                }
                catch (WikittyException eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"An exception occured while binding form", (Throwable)eee);
                    }
                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.binding.forms.concurrence.message"));
                }
                return null;
            }
        };
        task.execute();
    }

    protected List<Form> getSendingForms(Sending sending) {
        Set<String> formIds = sending.getForm();
        if (formIds == null) {
            return null;
        }
        List forms = this.getProxy().restore(Form.class, new ArrayList<String>(formIds));
        if (log.isDebugEnabled()) {
            log.debug((Object)("display " + forms.size() + " forms"));
        }
        return forms;
    }

    protected void openUI(JAXXContext context, CardLayout2 contentLayout, JPanel content, VradiTreeNode node) {
        Class editType = node.getInternalClass();
        Class<? extends EmailContentUI> uiClass = EmailBeanConstant.getUIClass(editType);
        EmailContentUI ui = UIHelper.getContentIfExist(contentLayout, content, uiClass);
        String contentName = editType.getName();
        if (ui == null) {
            try {
                Constructor<? extends EmailContentUI> constructor = uiClass.getConstructor(JAXXContext.class);
                ui = constructor.newInstance(context);
                ui.openUI(node);
            }
            catch (Exception eee) {
                log.error((Object)eee);
                ErrorDialogUI.showError((Exception)eee);
            }
            content.add((Component)ui, contentName);
        }
        contentLayout.show((Container)content, contentName);
    }

    public void displaySession(JAXXContext context, EmailNavigationTreeHelper helper, VradiTreeNode node) {
        SendingViewUI ui = this.getSessionViewUI(context);
        Sending sending = helper.getSendingToDisplay(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending displayed : " + sending));
        }
        List<Form> forms = null;
        if (sending != null) {
            forms = this.getSendingForms(sending);
        }
        ui.setBean(sending);
        Session session = helper.getSelectedActiveSession();
        ui.setSession(session);
        OfferListTableModel.OfferListTableCellRenderer renderer = new OfferListTableModel.OfferListTableCellRenderer();
        OfferTable listTable = ui.getListTable();
        OfferListTableModel listTableModel = (OfferListTableModel)listTable.getModel();
        FormPagedResult formPageDTO = new FormPagedResult();
        if (forms != null) {
            formPageDTO.setFormsToShow(forms);
        }
        listTableModel.setFormPagedResult(formPageDTO);
        listTable.setModel(listTableModel);
        listTable.setDefaultRenderer(Boolean.class, renderer);
        listTable.setDefaultRenderer(Date.class, renderer);
        listTable.setDefaultRenderer(Double.class, renderer);
        listTable.setDefaultRenderer(String.class, renderer);
        listTable.setDefaultRenderer(XmlStream.class, renderer);
        listTable.setDefaultRenderer(Status.class, renderer);
        Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
        listTable.addHighlighter(highlighter);
        MouseListener offerListTableMouseListener = this.getOfferListTableMouseListener(ui);
        listTable.addMouseListener(offerListTableMouseListener);
        ui.init();
    }

    public MouseListener getOfferListTableMouseListener(final SendingViewUI ui) {
        return new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                JXTable listTable = (JXTable)e.getSource();
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    try {
                        ui.setCursor(Cursor.getPredefinedCursor(3));
                        EmailHandler.this.selectOffer((JAXXContext)ui, (JTable)listTable);
                    }
                    catch (Exception ex) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Can't open offer", (Throwable)ex);
                        }
                        ErrorDialogUI.showError((Exception)ex);
                    }
                    finally {
                        ui.setCursor(null);
                    }
                } else if (e.getButton() == 3) {
                    int[] selectedRows = listTable.getSelectedRows();
                    int rowClicked = listTable.rowAtPoint(e.getPoint());
                    boolean rowClickedSelected = false;
                    if (selectedRows == null || selectedRows.length == 0) {
                        listTable.getSelectionModel().setSelectionInterval(rowClicked, rowClicked);
                        rowClickedSelected = true;
                    } else {
                        int i = 0;
                        while (i < selectedRows.length && !rowClickedSelected) {
                            rowClickedSelected = rowClicked == selectedRows[i++];
                        }
                    }
                    if (rowClickedSelected) {
                        EmailHandler.this.showOfferListContextMenu(ui, listTable, ui.getOfferListTableModel(), e);
                    }
                }
            }
        };
    }

    protected void showOfferListContextMenu(SendingViewUI ui, JXTable table, OfferListTableModel model, MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem removeFormFromSession = new JMenuItem(I18n._((String)"vradi.email.removeFormFromSession"));
        removeFormFromSession.addActionListener(new RemoveAllFormFromSession(ui, table, model));
        menu.add(removeFormFromSession);
        JMenuItem removeFormFromSessionForUser = new JMenuItem(I18n._((String)"vradi.email.removeFormFromSessionForUser"));
        removeFormFromSessionForUser.addActionListener(new RemoveFormFromSessionForUser(ui, table, model));
        menu.add(removeFormFromSessionForUser);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected boolean askToRemoveUserForm(JPanel ui, String userName, String formAsString) {
        int yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmRemoveUserForms", (Object[])new Object[]{formAsString, userName}), I18n._((String)"vradi.email.confirmRemoveUserFormsTitle"), 0);
        return yes == 0;
    }

    protected boolean askToRemoveAllForm(JPanel ui, String formAsString) {
        int yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmRemoveForms", (Object[])new Object[]{formAsString}), I18n._((String)"vradi.email.confirmRemoveFormsTitle"), 0);
        return yes == 0;
    }

    protected void selectOffer(JAXXContext context, JTable listTable) {
        OfferListTableModel tableModel = (OfferListTableModel)listTable.getModel();
        int selectedRow = listTable.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < tableModel.getRowCount()) {
            selectedRow = listTable.convertRowIndexToModel(selectedRow);
            FormPagedResult formPageDTO = tableModel.getFormPagedResult();
            List formsToShow = formPageDTO.getFormsToShow();
            Form data = (Form)formsToShow.get(selectedRow);
            if (data != null) {
                log.info((Object)("Show Form: " + data.getObjet()));
                UIHelper.getHandler(context, OfferListHandler.class).addEditPane(context, data.getWikittyId());
            }
        }
    }

    public void displayForm(JAXXContext context, VradiTreeNode node) {
        Session session = EmailNavigationTreeHelper.getParentSession(node);
        if (session != null) {
            context.setContextValue((Object)session);
        }
        String id = node.getId();
        Form form = (Form)this.getProxy().restore(Form.class, id);
        context.setContextValue((Object)form);
    }

    public void addAllUserSending(QueryMakerViewUI ui, Session session, Form bean, List values) {
        if (this.askToAddUsers(ui, bean.getObjet(), EmailDataHelper.convertObjectBeanToString(values, User.class))) {
            for (Object selected : values) {
                this.addUserSending((JPanel)ui, session, bean, selected, false);
            }
        }
    }

    public void addAllUserSending(QueryMakerViewUI ui, Session session, List<Form> beanList, List values) {
        if (this.askToAddUsers(ui, EmailDataHelper.convertFormsToString(beanList), EmailDataHelper.convertObjectBeanToString(values, User.class))) {
            for (Object selected : values) {
                this.addUserSending((JPanel)ui, session, beanList, selected, false);
            }
        }
    }

    public void addUserSending(JPanel ui, Session session, List<Form> forms, Object selected) {
        this.addUserSending(ui, session, forms, selected, true);
    }

    protected void addUserSending(JPanel ui, Session session, List<Form> forms, Object selected, boolean ask) {
        User user = (User)selected;
        if (!ask || this.askToAddUsers(ui, EmailDataHelper.convertFormsToString(forms), VradiHelper.getEntityName(user))) {
            for (Form form : forms) {
                this.addUserSending(ui, session, form, selected, false);
            }
        }
    }

    public void addUserSending(JPanel ui, Session session, Form form, Object selected) {
        this.addUserSending(ui, session, form, selected, true);
    }

    protected void addUserSending(JPanel ui, Session session, Form form, Object selected, boolean ask) {
        block3: {
            User user = (User)selected;
            if (!ask || this.askToAddUsers(ui, form.getObjet(), VradiHelper.getEntityName(user))) {
                ArrayList<Form> formsToBind = new ArrayList<Form>();
                formsToBind.add(form);
                try {
                    this.getStorageService().createSending(session, (User)selected, formsToBind);
                }
                catch (VradiException eee) {
                    ErrorDialogUI.showError((Exception)((Object)eee));
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)("Cant add sending : " + (Object)((Object)eee)));
                }
            }
        }
    }

    protected boolean askToAddUsers(JPanel ui, String formAsString, String userAsString) {
        int yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmAddUser", (Object[])new Object[]{formAsString, userAsString}), I18n._((String)"vradi.email.confirmAddTitle"), 0);
        return yes == 0;
    }

    public void removeUserSending(JPanel ui, Session session, List<Form> forms, Object[] selecteds) {
        this.removeUserSending(ui, session, forms, selecteds, true);
    }

    protected void removeUserSending(JPanel ui, Session session, List<Form> forms, Object[] selecteds, boolean ask) {
        for (Form form : forms) {
            this.removeUserSending(ui, session, form, selecteds, ask);
        }
    }

    public void removeUserSending(JPanel ui, Session session, Form form, Object[] selecteds) {
        this.removeUserSending(ui, session, form, selecteds, true);
    }

    protected void removeUserSending(JPanel ui, Session session, Form form, Object[] selecteds, boolean ask) {
        int yes = 0;
        if (ask) {
            yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmDelete", (Object[])new Object[]{form.getObjet()}), I18n._((String)"vradi.email.confirmDeleteTitle"), 0);
        }
        if (yes == 0) {
            try {
                for (Object selected : selecteds) {
                    this.getStorageService().removeSending(session, form, (User)selected);
                }
            }
            catch (VradiException eee) {
                ErrorDialogUI.showError((Exception)((Object)eee));
                log.error((Object)("Cant add sending : " + (Object)((Object)eee)));
            }
        }
    }

    public void addAllGroupSending(JPanel ui, Session session, Form bean, List values) {
        if (this.askToAddGroups(ui, bean.getObjet(), EmailDataHelper.convertObjectBeanToString(values, Group.class))) {
            for (Object selected : values) {
                this.addGroupSending(ui, session, bean, selected, false);
            }
        }
    }

    public void addAllGroupSending(JPanel ui, Session session, List<Form> beanList, List values) {
        if (this.askToAddGroups(ui, EmailDataHelper.convertFormsToString(beanList), EmailDataHelper.convertObjectBeanToString(values, Group.class))) {
            for (Object selected : values) {
                this.addGroupSending(ui, session, beanList, selected, false);
            }
        }
    }

    protected void addGroupSending(JPanel ui, Session session, List<Form> forms, Object selected) {
        this.addGroupSending(ui, session, forms, selected, true);
    }

    protected void addGroupSending(JPanel ui, Session session, List<Form> forms, Object selected, boolean ask) {
        Group group = (Group)selected;
        if (!ask || this.askToAddGroups(ui, EmailDataHelper.convertFormsToString(forms), VradiHelper.getEntityName(group))) {
            for (Form form : forms) {
                this.addGroupSending(ui, session, form, selected, false);
            }
        }
    }

    public void addGroupSending(JPanel ui, Session session, Form form, Object selected) {
        this.addGroupSending(ui, session, form, selected, true);
    }

    public void addGroupSending(JPanel ui, Session session, Form form, Object selected, boolean ask) {
        block3: {
            Group group = (Group)selected;
            if (!ask || this.askToAddGroups(ui, form.getObjet(), VradiHelper.getEntityName(group))) {
                ArrayList<Form> formsToBind = new ArrayList<Form>();
                formsToBind.add(form);
                try {
                    this.getStorageService().createAllSending(session, group, formsToBind);
                }
                catch (VradiException eee) {
                    ErrorDialogUI.showError((Exception)((Object)eee));
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)("Cant add sending : " + (Object)((Object)eee)));
                }
            }
        }
    }

    protected boolean askToAddGroups(JPanel ui, String formAsString, String groupAsString) {
        int yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmAddGroup", (Object[])new Object[]{formAsString, groupAsString}), I18n._((String)"vradi.email.confirmAddTitle"), 0);
        return yes == 0;
    }

    public void removeGroupSending(JPanel ui, Session session, List<Form> forms, Object[] selecteds) {
        for (Form form : forms) {
            this.removeGroupSending(ui, session, form, selecteds);
        }
    }

    public void removeGroupSending(JPanel ui, Session session, Form form, Object[] selecteds) {
        int yes = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmDelete", (Object[])new Object[]{form.getObjet()}), I18n._((String)"vradi.email.confirmDeleteTitle"), 0);
        if (yes == 0) {
            try {
                for (Object selected : selecteds) {
                    this.getStorageService().removeAllSending(session, form, (Group)selected);
                }
            }
            catch (VradiException eee) {
                ErrorDialogUI.showError((Exception)((Object)eee));
                log.error((Object)("Cant add sending : " + (Object)((Object)eee)));
            }
        }
    }

    protected void reloadTree(EmailPopupUI ui) {
        EmailNavigationTreeHelper helper = ui.getHelper();
        TreePath[] selectionPaths = helper.getSelectionModel().getSelectionPaths();
        ui.updateTree();
        if (selectionPaths != null) {
            helper.getSelectionModel().setSelectionPaths(selectionPaths);
        }
    }

    public void sendSending(SendingViewUI ui, final Sending sending) {
        Object[] options = new Object[]{I18n._((String)"vradi.email.confirmSendSending.optionYes"), I18n._((String)"vradi.email.confirmSendSending.optionNo"), I18n._((String)"vradi.email.confirmSendSending.optionOtherMail")};
        int i = JOptionPane.showOptionDialog(ui, I18n._((String)"vradi.email.confirmSendSending", (Object[])new Object[]{this.getUserName(sending)}), I18n._((String)"vradi.email.confirmSendSendingTitle"), 1, 3, null, options, options[2]);
        String email = null;
        if (i == 2) {
            email = JOptionPane.showInputDialog(ui, I18n._((String)"vradi.email.confirmSendSending.askMail"), I18n._((String)"vradi.email.confirmSendSending.askMailTitle"), -1);
            i = 0;
        }
        if (i == 0) {
            Session session = this.getSessionBySending(sending.getWikittyId());
            final String sessionParagraph = session.getParagraph();
            final String finalEmail = email;
            final EmailPopupUI finalUI = ui.getParentContainer(EmailPopupUI.class);
            VradiTask<Void> sendSendingTask = new VradiTask<Void>((JAXXContext)ui, "vradi.email.sendSending"){

                @Override
                public Void doAction() throws VradiException {
                    Sending sendingResult = null;
                    try {
                        sendingResult = EmailHandler.this.getStorageService().sendMessage(sending.getWikittyId(), sessionParagraph, finalEmail);
                    }
                    catch (VradiException eee) {
                        JOptionPane.showMessageDialog(finalUI, I18n._((String)"vradi.email.sendSending.sendError", (Object[])new Object[]{eee.getMessage()}), I18n._((String)"vradi.email.sendSession.error"), 0);
                        EmailHandler.this.updateSendingStatus(sendingResult, VradiConstants.SendingStatus.ERROR);
                    }
                    return null;
                }

                @Override
                public void doWhenError(Exception eee) {
                    EmailHandler.this.updateSendingStatus(sending, VradiConstants.SendingStatus.ERROR);
                }
            };
            sendSendingTask.execute();
        }
    }

    public boolean send(final EmailPopupUI ui) {
        final Session session = ui.getHelper().getSelectedActiveSession();
        int confirm = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confirmSendSession"), I18n._((String)"vradi.email.confirmSendSessionTitle"), 0, 3);
        if (confirm != 0) {
            return false;
        }
        if (!this.checkAllSending(ui, session)) {
            return false;
        }
        AbstractProgressBarUI pb = new AbstractProgressBarUI((JAXXContext)ui){
            private static final long serialVersionUID = 5926558779822425487L;

            @Override
            public void cancel() {
                try {
                    VradiService.getVradiStorageService().stopSentMail(session);
                    this.dispose();
                }
                catch (VradiException eee) {
                    log.info((Object)"Cant stop sending emails : ", (Throwable)eee);
                    ErrorDialogUI.showError((Exception)((Object)eee));
                }
                ui.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        if (log.isInfoEnabled()) {
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
            log.info((Object)("Sending session : " + session.getNum() + " - " + format.format(session.getSessionDate()) + " status : " + VradiConstants.SessionStatus.getStatus((int)session.getStatus()).getDescription()));
        }
        VradiTask<Boolean> pdfGenerationAndSendingTask = new VradiTask<Boolean>((JAXXContext)ui, pb, I18n.n_((String)"vradi.email.generation")){

            @Override
            public Boolean doAction() throws Exception {
                try {
                    VradiService.getVradiStorageService().generatePDFForSession(session.getWikittyId());
                }
                catch (Exception eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)this.getErrorMsg(), (Throwable)eee);
                    }
                    this.doWhenError(eee);
                    ErrorDialogUI.showError((Exception)eee);
                    return false;
                }
                return true;
            }

            @Override
            public void doWhenDone() throws Exception {
                Boolean result = (Boolean)this.get();
                if (result != null && result.booleanValue()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Start sending mails");
                    }
                    VradiTask<Void> sentTask = new VradiTask<Void>((JAXXContext)ui, this.pb, I18n.n_((String)"vradi.email.sendSession")){

                        @Override
                        public Void doAction() throws Exception {
                            try {
                                VradiService.getVradiStorageService().sendMessages(session.getWikittyId());
                            }
                            catch (VradiException eee) {
                                JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.email.sendSending.sendError", (Object[])new Object[]{eee.getMessage()}), I18n._((String)"vradi.email.sendSession.error"), 0);
                                EmailHandler.this.updateSessionStatus(session, VradiConstants.SessionStatus.ERROR);
                            }
                            return null;
                        }

                        @Override
                        public void doWhenError(Exception eee) {
                            EmailHandler.this.updateSessionStatus(session, VradiConstants.SessionStatus.ERROR);
                        }
                    };
                    sentTask.execute();
                }
            }

            @Override
            public void doWhenError(Exception eee) {
                EmailHandler.this.updateSessionStatus(session, VradiConstants.SessionStatus.ERROR);
            }
        };
        pdfGenerationAndSendingTask.execute();
        return true;
    }

    protected boolean checkAllSending(EmailPopupUI ui, Session session) {
        for (Sending sending : this.getSendingList(session)) {
            Set<String> formIds;
            boolean emailExist = VradiService.getVradiDataService().checkUserEmail(sending);
            if (emailExist) {
                User user = (User)VradiService.getWikittyProxy().restore(User.class, sending.getUser());
                Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, user.getClient());
                boolean abord = this.askAbordSending(ui, I18n._((String)"vradi.email.askUserEmailEmpty", (Object[])new Object[]{user.getName(), client.getName()}));
                if (abord) {
                    this.updateSendingStatus(sending, VradiConstants.SendingStatus.ERROR);
                    return false;
                }
            }
            if ((formIds = sending.getForm()) == null) {
                return true;
            }
            List forms = this.getProxy().restore(Form.class, new ArrayList<String>(formIds));
            ArrayList<String> alreadyAskFormType = new ArrayList<String>();
            for (Form form : forms) {
                String extensionName = null;
                for (String ext : form.getExtensionNames()) {
                    if (ext.equals("Infogene") || ext.equals("Form")) continue;
                    extensionName = ext;
                    break;
                }
                boolean isTemplateExist = false;
                try {
                    isTemplateExist = VradiService.getVradiStorageService().checkTemplateExist(extensionName);
                }
                catch (VradiException eee) {
                    log.error((Object)"Cant check if template exist : ", (Throwable)eee);
                    ErrorDialogUI.showError((Exception)((Object)eee));
                }
                if (isTemplateExist || alreadyAskFormType.contains(extensionName)) continue;
                boolean abord = this.askAbordSending(ui, I18n._((String)"vradi.email.askModelEmpty", (Object[])new Object[]{extensionName}));
                if (abord) {
                    return false;
                }
                alreadyAskFormType.add(extensionName);
            }
        }
        return true;
    }

    protected boolean askAbordSending(EmailPopupUI ui, String msg) {
        int i = JOptionPane.showConfirmDialog(ui, msg, I18n._((String)"vradi.email.askAbordSendingTitle"), 0);
        return i != 0;
    }

    public Sending updateSendingStatus(Sending sending, VradiConstants.SendingStatus status) {
        if (sending == null) {
            return null;
        }
        Sending sendingRestored = (Sending)this.getProxy().restore(Sending.class, sending.getWikittyId());
        sendingRestored.setStatus(status.getValue());
        log.info((Object)("Saving sending " + sendingRestored.getWikittyId() + " with status " + status.getDescription()));
        return (Sending)this.getProxy().store((BusinessEntity)sendingRestored);
    }

    public Session updateSessionStatus(Session session, VradiConstants.SessionStatus status) {
        if (session == null) {
            return null;
        }
        Session sessionRestored = (Session)this.getProxy().restore(Session.class, session.getWikittyId());
        sessionRestored.setStatus(status.getValue());
        sessionRestored.setSessionDate(new Date());
        log.info((Object)("Saving session " + sessionRestored.getWikittyId() + " with status " + status.getDescription()));
        return (Session)this.getProxy().store((BusinessEntity)sessionRestored);
    }

    protected String getUserName(Sending sending) {
        try {
            String userId = sending.getUser();
            return ((User)this.getProxy().restore(User.class, userId)).getName();
        }
        catch (Exception eee) {
            log.error((Object)"Cant get sending user name : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
            return null;
        }
    }

    public void deleteSession(EmailPopupUI ui) {
        int i;
        Session session = ui.getHelper().getSessionSelected();
        if (session != null && (i = JOptionPane.showConfirmDialog(ui, I18n._((String)"vradi.email.confimCloseSession"), I18n._((String)"vradi.email.confimCloseSession.titles"), 0)) == 0) {
            try {
                VradiService.getVradiStorageService().deleteSession(session.getWikittyId());
            }
            catch (VradiException eee) {
                log.error((Object)"Cant delete session : ", (Throwable)eee);
                ErrorDialogUI.showError((Exception)((Object)eee));
            }
        }
    }

    public void updateReceptionProof(Sending sending, boolean isSelected) {
        sending.setReceptionProof(isSelected);
        this.getProxy().store((BusinessEntity)sending);
    }

    public void updateParagraph(Sending sending, String text) {
        sending.setParagraph(text);
        this.getProxy().store((BusinessEntity)sending);
    }

    protected List<Sending> getSendingList(Session session) {
        if (session == null || session.getSending() == null) {
            return new ArrayList<Sending>();
        }
        ArrayList<String> sendingIds = new ArrayList<String>(session.getSending());
        return this.getProxy().restore(Sending.class, sendingIds);
    }

    protected Sending getSendingForUser(Session session, String userId) {
        List<Sending> sendings = this.getSendingList(session);
        for (Sending sending : sendings) {
            if (!sending.getUser().equals(userId)) continue;
            return sending;
        }
        return null;
    }

    protected Session getSessionBySending(String sendingId) {
        return VradiService.getVradiDataService().getSessionBySending(sendingId);
    }

    protected List<String> getStringAsList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(s);
        return result;
    }

    protected class RemoveFormFromSessionForUser
    extends RemoveFormFromSession {
        public RemoveFormFromSessionForUser(SendingViewUI ui, JXTable listTable, OfferListTableModel tableModel) {
            super(ui, listTable, tableModel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EmailHandler.this.askToRemoveUserForm(this.ui, EmailDataHelper.convertFormsToString(this.formsToUpdate), this.user.getName())) {
                EmailHandler.this.removeUserSending((JPanel)this.ui, this.session, this.formsToUpdate, new Object[]{this.user}, false);
            }
        }
    }

    protected class RemoveAllFormFromSession
    extends RemoveFormFromSession {
        public RemoveAllFormFromSession(SendingViewUI ui, JXTable listTable, OfferListTableModel tableModel) {
            super(ui, listTable, tableModel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EmailHandler.this.askToRemoveAllForm(this.ui, EmailDataHelper.convertFormsToString(this.formsToUpdate))) {
                try {
                    VradiService.getVradiStorageService().removeFormsFromSession(this.formsToUpdate);
                }
                catch (VradiException eee) {
                    log.error((Object)"Cant remove forms to session : ", (Throwable)eee);
                    ErrorDialogUI.showError((Exception)((Object)eee));
                }
            }
        }
    }

    protected abstract class RemoveFormFromSession
    implements ActionListener {
        protected List<Form> formsToUpdate = new ArrayList<Form>();
        protected SendingViewUI ui;
        protected User user;
        protected Session session;

        protected RemoveFormFromSession(SendingViewUI ui, JXTable listTable, OfferListTableModel tableModel) {
            int[] selectedRows;
            this.ui = ui;
            Sending sending = ui.getBean();
            this.user = (User)VradiService.getWikittyProxy().restore(User.class, sending.getUser());
            this.session = VradiService.getVradiDataService().getSessionBySending(sending.getWikittyId());
            for (int row : selectedRows = listTable.getSelectedRows()) {
                row = listTable.convertRowIndexToModel(row);
                FormPagedResult formPage = tableModel.getFormPagedResult();
                List formsToShow = formPage.getFormsToShow();
                Form form = (Form)formsToShow.get(row);
                if (form == null) continue;
                this.formsToUpdate.add(form);
            }
        }
    }
}

