/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.helpers;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.loadors.RootThesaurusTreeTableNodeLoadors;
import com.jurismarches.vradi.ui.admin.loadors.ThesaurusTreeTableNodeLoadors;
import com.jurismarches.vradi.ui.admin.models.ThesaurusTreeTableModel;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.treetable.NavTreeTableBridge;
import jaxx.runtime.swing.nav.treetable.NavTreeTableHelper;
import jaxx.runtime.swing.nav.treetable.NavTreeTableModel;
import jaxx.runtime.swing.nav.treetable.NavTreeTableNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public class ThesaurusTreeTableHelper
extends NavTreeTableHelper<VradiTreeTableNode>
implements WikittyServiceListener {
    private static final Log log = LogFactory.getLog(ThesaurusTreeTableHelper.class);
    protected RootThesaurus rootThesaurus;
    protected List<String> idsLoaded = new ArrayList<String>();

    public ThesaurusTreeTableHelper() {
        this(new VradiDataProvider());
    }

    public ThesaurusTreeTableHelper(RootThesaurus rootThesaurus) {
        this(new VradiDataProvider());
        this.rootThesaurus = rootThesaurus;
    }

    public ThesaurusTreeTableHelper(VradiDataProvider dataProvider) {
        this.init(dataProvider);
    }

    protected void init(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
    }

    public void setUI(JXTreeTable tree, boolean addExpandTreeListener, boolean addOneClickSelectionListener, TreeSelectionListener listener, TreeWillExpandListener willExpandListener) {
        super.setUI(tree, addExpandTreeListener, addOneClickSelectionListener, listener, willExpandListener);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                VradiTreeTableNode node = (VradiTreeTableNode)((Object)event.getPath().getLastPathComponent());
                ThesaurusTreeTableHelper.this.registerLoadedIds(node);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                VradiTreeTableNode node = (VradiTreeTableNode)((Object)event.getPath().getLastPathComponent());
                Enumeration enumeration = node.children();
                while (enumeration.hasMoreElements()) {
                    VradiTreeTableNode child = (VradiTreeTableNode)((Object)enumeration.nextElement());
                    ThesaurusTreeTableHelper.this.idsLoaded.remove(child.getId());
                }
            }
        });
    }

    public void registerLoadedIds(VradiTreeTableNode node) {
        this.idsLoaded.add(node.getId());
        Enumeration enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            VradiTreeTableNode child = (VradiTreeTableNode)((Object)enumeration.nextElement());
            this.idsLoaded.add(child.getId());
        }
    }

    public void tryToSelect(List<Thesaurus> thesaurus) {
        this.tryToSelect((Collection<String>)this.extractIds(thesaurus));
    }

    public void tryToSelect(Collection<String> thesaurusIds) {
        if (thesaurusIds == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Try to select, ids are null");
            }
            return;
        }
        ArrayList<VradiTreeTableNode> nodes = new ArrayList<VradiTreeTableNode>();
        for (String id : thesaurusIds) {
            VradiTreeTableNode rootNode = (VradiTreeTableNode)this.getRootNode();
            VradiTreeTableNode nodeFound = (VradiTreeTableNode)this.findNode((NavNode)rootNode, new String[]{id});
            if (nodeFound == null) continue;
            nodes.add(nodeFound);
        }
        this.selectNodes(nodes);
    }

    public void tryToUnselect(List<Thesaurus> thesaurus) {
        this.tryToUnselect((Collection<String>)this.extractIds(thesaurus));
    }

    public void tryToUnselect(Collection<String> thesaurusIds) {
        if (thesaurusIds == null) {
            return;
        }
        ArrayList<VradiTreeTableNode> nodes = new ArrayList<VradiTreeTableNode>();
        for (String id : thesaurusIds) {
            VradiTreeTableNode nodeFound = (VradiTreeTableNode)this.findNode(this.getRootNode(), new String[]{id});
            if (nodeFound == null) continue;
            nodes.add(nodeFound);
        }
        this.unSelectNodes(nodes);
    }

    protected List<String> extractIds(List<Thesaurus> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        if (beans != null) {
            for (Thesaurus bean : beans) {
                ids.add(bean.getWikittyId());
            }
        }
        return ids;
    }

    public VradiDataProvider getDataProvider() {
        return (VradiDataProvider)this.dataProvider;
    }

    public NavTreeTableModel createTreeModel() {
        NavTreeTableModel model;
        if (this.rootThesaurus != null) {
            VradiTreeTableNode root = new VradiTreeTableNode(String.class, "Root node", null, null);
            VradiTreeTableNode rootThesaurusNode = new VradiTreeTableNode(RootThesaurus.class, this.rootThesaurus.getWikittyId(), null, new ThesaurusTreeTableNodeLoadors());
            root.add(rootThesaurusNode);
            model = this.createModel(root, new Object[]{new ThesaurusTreeTableModel()});
            rootThesaurusNode.populateChilds(this.getBridge(), this.getDataProvider());
            this.registerLoadedIds(root);
        } else {
            VradiTreeTableNode root = new VradiTreeTableNode(String.class, "Root node", null, new RootThesaurusTreeTableNodeLoadors());
            model = this.createModel(root, new Object[]{new ThesaurusTreeTableModel()});
            root.populateChilds(this.getBridge(), this.getDataProvider());
            this.registerLoadedIds(root);
        }
        return model;
    }

    public static RootThesaurus getRootThesaurus(VradiTreeTableNode node) {
        if (!node.getInternalClass().equals(RootThesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreRootThesaurus(node.getId());
    }

    public static Thesaurus getThesaurus(VradiTreeTableNode node) {
        if (!node.getInternalClass().equals(Thesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreThesaurus(node.getId());
    }

    protected void refresh(VradiTreeTableNode node) {
        if (node == null) {
            return;
        }
        ((NavTreeTableBridge)this.getBridge()).nodeChanged((TreeNode)((Object)node));
    }

    public void putWikitty(WikittyServiceEvent event) {
        Map idAndExtensions = event.getIdExtensions();
        for (final String wikittyId : event.getIds()) {
            Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
            if (wikittyExtensions.contains("Thesaurus")) {
                final Thesaurus thesaurusConcerned = ThesaurusDataHelper.restoreThesaurus(wikittyId);
                if (thesaurusConcerned == null) {
                    return;
                }
                if (this.idsLoaded.contains(thesaurusConcerned.getParent())) {
                    SwingUtilities.invokeLater(new Thread(){

                        @Override
                        public void run() {
                            VradiTreeTableNode existingNode = (VradiTreeTableNode)ThesaurusTreeTableHelper.this.findNode(ThesaurusTreeTableHelper.this.getRootNode(), new String[]{wikittyId});
                            if (existingNode != null) {
                                VradiTreeTableNode parent = (VradiTreeTableNode)existingNode.getParent();
                                String newParentId = thesaurusConcerned.getParent();
                                if (parent != null && !parent.getId().equals(newParentId)) {
                                    VradiTreeTableNode newParentNode = (VradiTreeTableNode)ThesaurusTreeTableHelper.this.findNode(ThesaurusTreeTableHelper.this.getRootNode(), new String[]{newParentId});
                                    ((NavTreeTableBridge)ThesaurusTreeTableHelper.this.getBridge()).removeNodeFromParent((NavTreeTableNode)existingNode);
                                    if (ThesaurusTreeTableHelper.this.findNode((NavNode)newParentNode, new String[]{wikittyId}) == null) {
                                        ThesaurusTreeTableHelper.this.insertNode((NavNode)newParentNode, (NavNode)existingNode);
                                    }
                                } else {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Modification case :  " + thesaurusConcerned.getName()));
                                    }
                                    ThesaurusTreeTableHelper.this.refresh(existingNode);
                                }
                                return;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Creation case :  " + thesaurusConcerned.getName()));
                            }
                            VradiTreeTableNode parentNode = (VradiTreeTableNode)ThesaurusTreeTableHelper.this.findNode(ThesaurusTreeTableHelper.this.getRootNode(), new String[]{thesaurusConcerned.getParent()});
                            VradiTreeTableNode newNode = ((ThesaurusTreeTableNodeLoadors)NavHelper.getChildLoador(ThesaurusTreeTableNodeLoadors.class)).createNode(wikittyId, (NavDataProvider)ThesaurusTreeTableHelper.this.getDataProvider());
                            if (ThesaurusTreeTableHelper.this.findNode((NavNode)parentNode, new String[]{wikittyId}) == null) {
                                ThesaurusTreeTableHelper.this.insertNode((NavNode)parentNode, (NavNode)newNode);
                            }
                        }
                    });
                }
            }
            if (!wikittyExtensions.contains("RootThesaurus")) continue;
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    VradiTreeTableNode existingNode = (VradiTreeTableNode)ThesaurusTreeTableHelper.this.findNode(ThesaurusTreeTableHelper.this.getRootNode(), new String[]{wikittyId});
                    if (existingNode != null) {
                        ThesaurusTreeTableHelper.this.refresh(existingNode);
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Refresh root thesaurus : " + wikittyId));
                    }
                    VradiTreeTableNode newNode = ((RootThesaurusTreeTableNodeLoadors)NavHelper.getChildLoador(RootThesaurusTreeTableNodeLoadors.class)).createNode(wikittyId, (NavDataProvider)ThesaurusTreeTableHelper.this.getDataProvider());
                    ThesaurusTreeTableHelper.this.insertNode(ThesaurusTreeTableHelper.this.getRootNode(), (NavNode)newNode);
                }
            });
        }
    }

    public void removeWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove event : " + event));
        }
        for (final String wikittyId : event.getIds()) {
            if (!this.idsLoaded.contains(wikittyId)) continue;
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removing node " + wikittyId + " from parent"));
                    }
                    VradiTreeTableNode node = (VradiTreeTableNode)ThesaurusTreeTableHelper.this.findNode(ThesaurusTreeTableHelper.this.getRootNode(), new String[]{wikittyId});
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removing node " + wikittyId + " from parent"));
                    }
                    ThesaurusTreeTableHelper.this.idsLoaded.remove(wikittyId);
                    if (node == null) {
                        return;
                    }
                    VradiTreeTableNode parent = (VradiTreeTableNode)node.getParent();
                    int index = parent.getIndex((TreeNode)((Object)node));
                    node.removeFromParent();
                    ((NavTreeTableBridge)ThesaurusTreeTableHelper.this.getBridge()).nodesWereRemoved((TreeNode)((Object)parent), new int[]{index}, (Object[])new VradiTreeTableNode[]{node});
                }
            });
        }
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put extension event : " + event));
        }
    }

    public void removeExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove extension event : " + event));
        }
    }

    public void clearExtension(WikittyServiceEvent event) {
    }
}

