/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

import jaxx.runtime.context.JAXXContextEntryDef;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.VradiContext;

/**
 * @author letellier
 */
public class EntityModel<E> extends AbstractListModel implements ComboBoxModel{

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(EntityModel.class);

    protected JAXXContextEntryDef<List<E>> entryDef;
    protected List<E> datas;
    protected E selected;
    protected boolean firstNull = true;

    public EntityModel(Collection<E> datas){
        this(datas, true);
    }
    
    public EntityModel(Collection<E> datas, boolean firstNull){
        this.firstNull = firstNull;
        this.datas = new ArrayList(datas);
    }

    public EntityModel(JAXXContextEntryDef<List<E>> entryDef){
        this(entryDef, true);
    }

    public EntityModel(JAXXContextEntryDef<List<E>> entryDef, boolean firstNull){
        this.firstNull = firstNull;
        this.entryDef = entryDef;
        updateDatas();
        VradiContext.get().addPropertyChangeListener(entryDef, entryDef.getName(), new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                updateDatas();
            }
        });
    }

    @Override
    public int getSize() {
        if (firstNull){
            return datas.size() + 1;
        }
        return datas.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (firstNull){
            if (index == 0){
                return null;
            }

            return datas.get(index - 1);
        }
        return datas.get(index);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        selected = (E) anItem;
        fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getSelectedItem() {
        return selected;
    }

    protected void updateDatas(){
        datas = entryDef.getContextValue(VradiContext.get());
        fireContentsChanged(this, 0, datas.size());
    }
}
