/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.helpers;

import static org.nuiton.i18n.I18n._;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.WikittyExtension;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.ui.admin.content.AdminFormTypeUI;

/**
 * @author letellier
 */
public class FormNavigationTreeHelper extends AdminNavigationTreeHelper {

    /**
     * Logger
     */
    static private final Log log = LogFactory
            .getLog(FormNavigationTreeHelper.class);

    protected NavigationModel<NavigationTreeNode> cachedModel;

    protected boolean datasChanged = false;

    public FormNavigationTreeHelper(JAXXContext context) {
        super(VradiContext.getFormsTypeEntryDef().getName(), context);

        JAXXContextEntryDef<List<WikittyExtension>> formsTypeEntryDef = VradiContext.getFormsTypeEntryDef();
        VradiContext.get().addPropertyChangeListener(formsTypeEntryDef, formsTypeEntryDef.getName(), new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                datasChanged = true;
            }
        });
    }

    @Override
    public NavigationModel createTreeModel() {
        
        if (cachedModel != null && !datasChanged){
            return cachedModel;
        }

        JAXXContext context = getContext();
        List<WikittyExtension> forms = VradiContext.getFormsTypeInEntryDef();

        // construction du noeud root
        // il ne contient pas de context et ne sera pas visible
        NavigationTreeNode rootNode = builder.buildEmptyRoot(null, "$root");

        JAXXContextEntryDef<List<WikittyExtension>> formEntryDef = VradiContext.getFormsTypeEntryDef();
        NavigationTreeNode formNode = builder.build(rootNode,
                _(formEntryDef.getName()),
                formEntryDef, "forms", AdminFormTypeUI.class,
                null);

        for (WikittyExtension f : forms) {
            builder.addForm(context, formNode, f);
        }

        // save tree model in context
        cachedModel = builder.getModel();
        setModel(context, cachedModel);

        setSelectedNode(context, formNode);

        datasChanged = false;

        return cachedModel;
    }

    @Override
    public NavigationTreeNode removeChildNode(NavigationTreeNode node) {
        List<WikittyExtension> extensions = VradiContext.getFormsTypeInEntryDef();
        WikittyExtension bean = (WikittyExtension) node.getBean();
        extensions.remove(bean);
        VradiContext.setFormsTypeEntryDef(extensions);
        
        return super.removeChildNode(node);
    }
}
