/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.helpers;

import static org.nuiton.i18n.I18n._;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.swing.JPanel;
import javax.swing.JTree;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.handler.NavigationHandler;
import jaxx.runtime.swing.navigation.handler.NavigationTreeHandlerWithCardLayout;
import jaxx.runtime.swing.navigation.tree.NavigationTreeHelper;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.services.dto.SendingContainer;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import com.jurismarches.vradi.services.dto.VradiGroupDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import com.jurismarches.vradi.services.dto.VradiSessionDTO;
import com.jurismarches.vradi.services.dto.VradiUserDTO;
import com.jurismarches.vradi.ui.email.EmailHandler;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.email.FormViewUI;
import com.jurismarches.vradi.ui.email.SessionsListUI;

/**
 * @author letellier
 */
public class EmailNavigationTreeHelper extends NavigationTreeHelper {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(EmailNavigationTreeHelper.class);

    /**
     * where the clients are hold in context
     */
    
    protected NavigationTreeModel cachedModel;

    protected boolean datasChanged = false;

    // All filter
    public enum EmailFilterEnum {
        FILTER_BY_CLIENT("vradi.email.clientFilter"),
        FILTER_BY_USER("vradi.email.userFilter"),
        FILTER_BY_GROUP("vradi.email.groupFilter"),
        FILTER_BY_FORM("vradi.email.formFilter");


        protected int value;
        protected String text;

        EmailFilterEnum(String text) {
            this.text = text;
        }

        @Override
        public String toString(){
            return _(text);
        }
    }

    public static String PATH_SEPARATOR = "/";

    protected NavigationTreeNode rootNode;

    protected EmailTreeModelBuilder builder;

    protected JAXXContext context;

    protected JTree tree;

    // Filter by client by defaut
    protected EmailFilterEnum filter = EmailFilterEnum.FILTER_BY_CLIENT;

    public EmailNavigationTreeHelper(JAXXContext context, JTree tree) {
        super("");
        this.context = context;
        this.tree = tree;

        JAXXContextEntryDef<List<VradiSessionDTO>> sessionsDTOEntryDef = VradiContext.getSessionDTOEntryDef();
        if (sessionsDTOEntryDef == null){
            VradiContext.setSessionDTOEntryDef(new ArrayList<VradiSessionDTO>());
            sessionsDTOEntryDef = VradiContext.getSessionDTOEntryDef();
        }
        VradiContext.get().addPropertyChangeListener(sessionsDTOEntryDef, sessionsDTOEntryDef.getName(), new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                datasChanged = true;
            }
        });
    }

    // Get email handler
    protected EmailHandler getHandler(JAXXContext context) {
        return UIHelper.getHandler(context, EmailHandler.class);
    }

    // Get the builder
    public EmailTreeModelBuilder getBuilder() {
        return builder;
    }

    // Get this root node
    public NavigationTreeNode getRootNode() {
        return rootNode;
    }

    public String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public boolean isByForm() {
        return filter.equals(EmailFilterEnum.FILTER_BY_FORM);
    }

    public boolean isByUser() {
        return filter.equals(EmailFilterEnum.FILTER_BY_USER);
    }

    public boolean isByClient() {
        return filter.equals(EmailFilterEnum.FILTER_BY_CLIENT);
    }

    public boolean isByGroup() {
        return filter.equals(EmailFilterEnum.FILTER_BY_GROUP);
    }

    public VradiSessionDTO getActiveSession(){

        // Create the model and store it in the given context.
        List<VradiSessionDTO> datas = VradiContext.getSessionsDTOInEntryDef();

        for (VradiSessionDTO data : datas){
            if (data.getStatus() != VradiConstants.SessionStatus.CLOSE.getValue() &&
                    data.getStatus() != VradiConstants.SessionStatus.SENT.getValue()) {
                return data;
            }
        }
        return null;
    }

    public void updateData(List<VradiSessionDTO> datas, EmailFilterEnum filter) {
        if (log.isDebugEnabled()) {
            log.debug("update data, nb sessions : " + datas.size());
        }
        this.filter = filter;

        // Create the model and store it in the given context.
        VradiContext.setSessionDTOEntryDef(datas);
    }

    @Override
    public NavigationTreeModel createTreeModel(JAXXContext context) {
        this.context = context;
        if (builder == null) {
            builder = new EmailTreeModelBuilder(context);
        }

        if (cachedModel != null && !datasChanged){
            return cachedModel;
        }

        getBuilder().buildModel(context);
        // save tree model in context
        cachedModel = builder.getModel();
        setModel(context, cachedModel);

        setSelectedNode(context, rootNode);

        datasChanged = false;

        return cachedModel;
    }

    public void refreshModel(){
        String selectedPath = getSelectedPath(context);
        getSafeTree(context).setModel((NavigationTreeModel)createTreeModel(context));
        setSelectedPath(context, selectedPath);
    }

    @Override
    public NavigationHandler<NavigationTreeNode> createTreeHandler(JAXXObject context) {

        if (log.isDebugEnabled()) {
            log.debug("create handler");
        }

        // save tree in context
        setTree(context, tree);

        NavigationHandler<NavigationTreeNode> handler
                = new NavigationTreeHandlerWithCardLayout<NavigationTreeNode>(

                getPrefix(),
                context,
                NavigationHandler.Strategy.PER_UI_TYPE) {

            private static final long serialVersionUID = 1L;

            @Override
            public NavigationModel<NavigationTreeNode> getNavigationTreeModel() {
                return getSafeModel(getContext());
            }

            @Override
            public void treateError(Exception e) {
                ErrorDialogUI.showError(e);
            }

            @Override
            public EmailPopupUI getContext() {
                return (EmailPopupUI)this.context;
            }

            @Override
            protected JPanel getContentContainer() {
                return getContext().getContent();
            }

            @Override
            protected CardLayout2 getContentLayout() {
                return getContext().getContentLayout();
            }

            /*
             * @see jaxx.runtime.swing.navigation.handler.AbstractNavigationHandler#valueChanged(javax.swing.event.TreeSelectionEvent)
             *
            @Override
            public void valueChanged(TreeSelectionEvent event) {
                super.valueChanged(event);
                
                // FIXME EC-20100510 this is too hard to code !!!
                ((EmailPopupUI)context).navTreeSelectionChange();
            }*/
        };

        // save handler in ui context
        setTreeHandler(context, handler);

        return handler;
    }

    /* EC-20100410 Unused
    public TreePath expendNode(JAXXContext context, NavigationTreeNode node) {

        TreeNode[] treeNodes = node.getPath();
        TreePath path = new TreePath(treeNodes);
        JTree tree = getTree(context);

        if (log.isDebugEnabled()){
            log.debug("Try to expend path : " + path);
        }

        tree.expandPath(path);

        return path;
    }*/

    public List<VradiSendingDTO> getSendingToDisplay(NavigationTreeNode node){
        Map<String, VradiSendingDTO> result = new HashMap<String, VradiSendingDTO>();
        Object value = node.getBean();
        if (value instanceof VradiFormDTO){
            VradiFormDTO formDTO = (VradiFormDTO) value;
            List<VradiSendingDTO> sendingDTOs = formDTO.getSendingDTOs();
            for (VradiSendingDTO sending : sendingDTOs){
                result.put(sending.getWikittyId(), sending);
            }
        } else if (value instanceof VradiSessionDTO){
            List<VradiSendingDTO> vradiSendingDTOs = ((VradiSessionDTO) value).getSendingList();
            for (VradiSendingDTO s : vradiSendingDTOs){
                result.put(s.getWikittyId(), s);
            }
        } else if (value instanceof QueryMaker){
            VradiSendingDTO sending = ((SendingContainer) value).getCurrentSending();
            result.put(sending.getWikittyId(), sending);
        }

        return new ArrayList<VradiSendingDTO>(result.values());
    }
     
    public class EmailTreeModelBuilder extends NavigationTreeModelBuilder {
        public EmailTreeModelBuilder(JAXXContext context) {
            super("/", context, null, null);
        }

        // Return true if empty
        public boolean removeNodeFromParent(JAXXContext context, NavigationTreeNode node) {
            NavigationTreeModel treeModel = getModel();
            treeModel.removeNodeFromParent(node);
            return treeModel.getRoot().getChildCount() == 0;
        }

        public void buildModel(JAXXContext context) {
            JAXXContextEntryDef<List<VradiSessionDTO>> SESSIONS_DTO_DEF = VradiContext.getSessionDTOEntryDef();

            // Build unvisible root
            rootNode = builder.buildEmptyRoot(SESSIONS_DTO_DEF, "$root");

            // Get datas
            if (SESSIONS_DTO_DEF != null){
                List<VradiSessionDTO> datas = SESSIONS_DTO_DEF.getContextValue(context);

                // Add session
                for (VradiSessionDTO data : datas){
                    addSession(rootNode, data);
                }
            }
        }

        public void addSession(NavigationTreeNode parentNode, VradiSessionDTO sessionDTO) {
            if (log.isDebugEnabled()){
                log.debug("createSession node " + sessionDTO.getSessionDate() + " num " + sessionDTO.getNum());
            }
            String sessionId = sessionDTO.getWikittyId();
            NavigationTreeNode sessionNode =  build(parentNode,
                                              getDecorator(VradiSessionDTO.class),
                                              "..[@wikittyId=\"" + sessionId + "\"]",
                                              sessionId,
                                              SessionsListUI.class,
                                              null);

            // Add all clients, users and groups nodes
            List<VradiSendingDTO> vradiSendingDTOs = sessionDTO.getSendingList();
            if (log.isDebugEnabled()){
                log.debug(vradiSendingDTOs.size() + " sending to display");
            }
            if (isByForm()){
                addAllForms(sessionNode, vradiSendingDTOs);
            } else {
                for (VradiSendingDTO sending : vradiSendingDTOs){
                    if (isByClient()){
                        addClient(sessionNode, sending);
                    } else if (isByUser()){
                        addUser(sessionNode, sending);
                    } else if (isByGroup()){
                        addGroup(sessionNode, sending);
                    }
                }
            }

            sort(sessionNode);
        }

        public void addAllForms(NavigationTreeNode parentNode, List<VradiSendingDTO> sendingDTOs) {
            Map<String, VradiFormDTO> forms = new HashMap<String, VradiFormDTO>();
            Map<VradiFormDTO, VradiSendingDTO> sendings = new HashMap<VradiFormDTO, VradiSendingDTO>();

            // Extract forms and sendings
            for (VradiSendingDTO sending : sendingDTOs){
                for (VradiFormDTO form : sending.getFormDTOs()){
                    forms.put(form.getWikittyId(), form);
                    sendings.put(form, sending);
                }
            }

            // Display
            for (VradiFormDTO formDTO : forms.values()){

                if (log.isDebugEnabled()){
                    log.debug("Adding form node " + formDTO.getObjet());
                }

                String formId = formDTO.getWikittyId();
                NavigationTreeNode formNode = build(parentNode, getDecorator(VradiFormDTO.class),
                        ".." + PATH_SEPARATOR + "sendingList[@wikittyId=\"" +
                                sendings.get(formDTO).getWikittyId() + "\"]" + PATH_SEPARATOR +
                                "formDTOs[@wikittyId=\"" + formId + "\"]",
                        formId, FormViewUI.class, null);

                sort(formNode);
            }
        }

        public void addClient(NavigationTreeNode parentNode, VradiSendingDTO sending) {
            VradiClientDTO clientDTO = sending.getClientDTO();
            if (clientDTO != null){
                String clientId = clientDTO.getWikittyId();
                if (log.isDebugEnabled()){
                    log.debug("create Client node " + clientId + " for sending " + sending.getWikittyId());
                }
                NavigationTreeNode clientNode = build(parentNode,
                              getDecorator(VradiClientDTO.class),
                              ".." + PATH_SEPARATOR + "sendingList[@wikittyId=\"" +
                              sending.getWikittyId() + "\"]" + PATH_SEPARATOR +
                              "clientDTO",
                              clientId,
                              SessionsListUI.class,
                              null);

                for (VradiUserDTO user : clientDTO.getUsersDTO()){
                    addUser(clientNode, user);
                }

                sort(clientNode);
            }
        }

        public void addClient(NavigationTreeNode parentNode, VradiClientDTO clientDTO) {
            if (clientDTO != null){
                String clientId = clientDTO.getWikittyId();
                if (log.isDebugEnabled()){
                    log.debug("create Client node " + clientId);
                }
                NavigationTreeNode clientNode = build(parentNode,
                                  getDecorator(VradiUserDTO.class),
                                  ".." + PATH_SEPARATOR + "clientsDTO[@wikittyId=\"" + clientId + "\"]",
                                  clientId,
                                  SessionsListUI.class,
                                  null);

                for (VradiUserDTO user : clientDTO.getUsersDTO()){
                    addUser(clientNode, user);
                }
                sort(clientNode);
            }
        }

        public void addUser(NavigationTreeNode parentNode, VradiSendingDTO sending) {
            VradiUserDTO userDTO = sending.getUserDTO();
            if (userDTO != null){
                String userId = userDTO.getWikittyId();
                if (log.isDebugEnabled()){
                    log.debug("createUser node " + userId + " for sending " + sending.getWikittyId());
                }
                Decorator<VradiUserDTO> userDecorator = getDecorator(VradiUserDTO.class);
                if (isByUser()){
                    userDecorator = getUserDTODecorator();
                }
                NavigationTreeNode userNode = build(parentNode,
                        userDecorator,
                        ".." + PATH_SEPARATOR + "sendingList[@wikittyId=\"" +
                                sending.getWikittyId() + "\"]" + PATH_SEPARATOR +
                                "userDTO",
                        userId,
                        SessionsListUI.class,
                        null);

                sort(userNode);
            }
        }

        public void addUser(NavigationTreeNode parentNode, VradiUserDTO userDTO) {
            if (userDTO != null){
                String userId = userDTO.getWikittyId();
                if (log.isDebugEnabled()){
                    log.debug("createUser node " + userId);
                }
                NavigationTreeNode userNode = build(parentNode,
                        getDecorator(VradiUserDTO.class),
                        ".." + PATH_SEPARATOR + "usersDTO[@wikittyId=\"" + userId + "\"]",
                        userId,
                        SessionsListUI.class,
                        null);

                sort(userNode);
            }
        }

        public void addGroup(NavigationTreeNode parentNode, VradiSendingDTO sending) {
            VradiGroupDTO groupDTO = sending.getGroupDTO();
            if (groupDTO != null){
                String groupId = groupDTO.getWikittyId();
                if (log.isDebugEnabled()){
                    log.debug("createGroup node " + groupId + " for sending " + sending.getWikittyId());
                }
                NavigationTreeNode groupNode = build(parentNode,
                        getDecorator(VradiGroupDTO.class),
                        ".." + PATH_SEPARATOR + "sendingList[@wikittyId=\"" +
                        sending.getWikittyId() + "\"]" + PATH_SEPARATOR + "groupDTO",
                        groupId, SessionsListUI.class, null);

                for (VradiUserDTO userDTO : groupDTO.getUsersDTO()){
                    addUser(groupNode, userDTO);
                }

                for (VradiClientDTO clientDTO : groupDTO.getClientsDTO()){
                    addClient(groupNode, clientDTO);
                }

                sort(groupNode);
            }
        }

        protected void sort(NavigationTreeNode node){
            NavigationTreeNode parent = node.getParent();
            if (parent == null){
                parent = getRootNode();
            }
            Enumeration<? extends NavigationTreeNode> childEnum = parent.children();

            List<NavigationTreeNode> children = Collections.list((Enumeration<NavigationTreeNode>) childEnum);

            Map<String, NavigationTreeNode> toSort = new HashMap<String, NavigationTreeNode>();

            List<String> valuesToSort = new ArrayList<String>();

            // Extract rendered
            int cnt = 0;
            for (NavigationTreeNode child : children){
                String rendered = child.getRenderer().toString();
                toSort.put(rendered, child);
                valuesToSort.add(rendered);

            }

            // Sort beans
            Collections.sort(valuesToSort);

            // Retrieve sorted nodes
            children.clear();
            cnt = 0;
            for (String sorted : valuesToSort){
                NavigationTreeNode retrieveNode = toSort.get(sorted);
                children.add(retrieveNode);
            }

            for (NavigationTreeNode child : children){
                int index = children.indexOf(child);
                parent.remove(child);
                parent.insert(child, index);
            }
            builder.getModel().nodeStructureChanged(parent);
        }

        protected DecoratorProvider decoratorProvider = null;

        protected DecoratorProvider getDecoratorProvider() {

            if (decoratorProvider != null){
                return decoratorProvider;
            }

            // register decorator one for all
            decoratorProvider = new DecoratorProvider() {
                @Override
                protected void loadDecorators() {

                    registerMultiJXPathDecorator(VradiClientDTO.class, "${name}$s# (${nbFormToSend}$s)", "#", " - ");
                    registerMultiJXPathDecorator(VradiUserDTO.class, "userClientName", "${clientName}$s#${name}$s# (${nbFormToSend}$s)", "#", " - ");
                    registerMultiJXPathDecorator(VradiUserDTO.class, "${name}$s# (${nbFormToSend}$s)", "#", " - ");
                    registerMultiJXPathDecorator(VradiGroupDTO.class, "${name}$s# (${nbFormToSend}$s)", "#", " - ");
                    registerMultiJXPathDecorator(VradiFormDTO.class, "${objet}$s", "", "");
                    registerDecorator(new Decorator<VradiSessionDTO>(VradiSessionDTO.class){

                        @Override
                        public String toString(Object bean) {

                            // 1 - dd/MM/yyyy (nbForms) - status
                            VradiSessionDTO session = (VradiSessionDTO)bean;
                            StringBuffer buffer = new StringBuffer();
                            buffer.append(session.getNum());
                            buffer.append(" - ");
                            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                            buffer.append(format.format(session.getSessionDate()));
                            buffer.append(" (");
                            buffer.append(session.getNbFormToSend());
                            buffer.append(")");

                            // session active is displayed as Active too
                            //if (session.getStatus() != VradiConstants.SessionStatus.ACTIVE.getValue()){
                                buffer.append(" - ");
                                buffer.append(VradiConstants.SessionStatus.getStatus(session.getStatus()).getDescription());
                            //}

                            return buffer.toString();
                        }
                    });
                }
            };
            return decoratorProvider;
        }

        public <O> Decorator<O> getDecorator(Class<O> type) {
            Decorator<O> classDecorator = getDecoratorProvider().getDecorator(type);
            return classDecorator;
        }

        protected Decorator<VradiUserDTO> getUserDTODecorator() {
            return getDecoratorProvider().getDecorator(VradiUserDTO.class, "userClientName");
        }

    }
}
