/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.helpers;

import static org.nuiton.i18n.I18n._;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.*;

import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.AdminClientUI;

/**
 * @author letellier
 */
public class ClientNavigationTreeHelper extends AdminNavigationTreeHelper {

    /**
     * Logger
     */
    static private final Log log = LogFactory
            .getLog(ClientNavigationTreeHelper.class);

    protected NavigationModel<NavigationTreeNode> cachedModel;

    protected boolean datasChanged = false;

    public ClientNavigationTreeHelper(JAXXContext context) {
        super(VradiContext.getClientsEntryDef().getName(), context);

        JAXXContextEntryDef<List<Client>> clientsEntryDef = VradiContext.getClientsEntryDef();
        VradiContext.get().addPropertyChangeListener(clientsEntryDef, clientsEntryDef.getName(), new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                datasChanged = true;
            }
        });
        JAXXContextEntryDef<List<Client>> usersEntryDef = VradiContext.getClientsEntryDef();
        VradiContext.get().addPropertyChangeListener(usersEntryDef, usersEntryDef.getName(), new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                datasChanged = true;
            }
        });
    }

    @Override
    public NavigationModel<NavigationTreeNode> createTreeModel() {
        if (log.isDebugEnabled()) {
            log.debug("createTreeModel()");
        }

        if (cachedModel != null && !datasChanged){
            return cachedModel;
        }
        
        JAXXContext context = getContext();
        AdminHandler adminHandler = UIHelper.getHandler(context, AdminHandler.class);
        Map<Client, Set<String>> clients = adminHandler.getAllClients();

        // construction du noeud root
        // il ne contient pas de context et ne sera pas visible
        NavigationTreeNode rootNode = builder.buildEmptyRoot(null, "$root");

        JAXXContextEntryDef<List<Client>> clientEntryDef = VradiContext.getClientsEntryDef();
        NavigationTreeNode clientsNode = builder.build(rootNode,
                _(clientEntryDef.getName()),
                clientEntryDef, "clients", AdminClientUI.class,
                null);

        // liste de tous les utilisateurs existants
        List<User> userList = adminHandler.getAllUsers();
        List<String> userIdList = new ArrayList<String>(userList.size());
        for (User user : userList) {
            userIdList.add(user.getWikittyId());
        }
        
        for (Client client : clients.keySet()) {
            NavigationTreeNode clientNode = builder.addClient(clientsNode, client.getWikittyId());

            Set<String> clientUserIds = clients.get(client);
            if (clientUserIds == null || clientUserIds.isEmpty()) {
                continue;
            }
            
            // ajout des noeuds utilisateurs
            // on verifie qu'ils existent bien dans la liste des utilisateurs du contexte global
            Iterator<String> iterator = clientUserIds.iterator();
            while (iterator.hasNext()) {
                String clientUserId = iterator.next();
                if (userIdList.contains(clientUserId)) {
                    builder.addUser(clientNode.getChildAt(0), clientUserId);
                }
            }
        }

        // save tree model in context
        cachedModel = builder.getModel();
        setModel(context, cachedModel);

        setSelectedNode(context, clientsNode);

        datasChanged = false;

        return cachedModel;
    }
    
    @Override
    public NavigationTreeNode removeChildNode(NavigationTreeNode node) {
        if (log.isDebugEnabled()) {
            log.debug("removeChildNode(node)");
        }
        
        JAXXContext context = getContext();
        Object bean = node.getBean();

        List<User> users = VradiContext.getUsersInEntryDef();
        //List<Client> clients = VradiContext.getClientsInEntryDef();
        AdminHandler adminHandler = UIHelper.getHandler(context, AdminHandler.class);
        Map<Client, Set<String>> clients = adminHandler.getAllClients();
        List<Group> groups = VradiContext.getGroupsInEntryDef();

        if (bean instanceof Client) {
            // check if client is not in a group
            Client client = (Client) bean;
            if (groups != null && !groups.isEmpty()) {
                for (Group group : groups) {
                    Set<String> groupClients = group.getClient();
                    if (groupClients != null && !groupClients.isEmpty()) {
                        if (groupClients.contains(client.getWikittyId())) {
                            throw new IllegalStateException(_("vradi.exception.client.belongs.groups"));
                        }
                    }
                    
                    if (group.getUser() != null && !group.getUser().isEmpty()) {
                        //Set<String> clientUsers = client.getUser();
                        Set<String> clientUsers = clients.get(client);
                        
                        if (clientUsers != null && !clientUsers.isEmpty()) {
                            Set<String> groupUsers = new HashSet<String>(group.getUser());
                            
                            groupUsers.retainAll(clientUsers);
                            if (!groupUsers.isEmpty()) {
                                throw new IllegalStateException(_("vradi.exception.client.users.belongs.groups"));
                            }
                        }
                    }
                }
            }
            
            // remove client
            clients.remove(bean);

            // remove client's users
            //Set<String> userIds = client.getUser();
            Set<String> userIds = clients.get(client);

            if (userIds != null && !userIds.isEmpty()) {
                HashMap<String, User> userMap = new HashMap<String, User>();
                for (User user : users) {
                    userMap.put(user.getWikittyId(), user);
                }

                for (String userId : userIds) {
                    if (userMap.containsKey(userId)) {
                        users.remove(userMap.get(userId));
                    }
                }
            }
            
        } else if (bean instanceof User) {
            // check if client is not in a group
            User user = (User) bean;
            
            if (groups != null && !groups.isEmpty()) {
                for (Group group : groups) {
                    Set<String> groupUsers = group.getUser();
                    
                    if (groupUsers != null && !groupUsers.isEmpty()) {
                        if (groupUsers.contains(user.getWikittyId())) {
                            throw new IllegalStateException(_("vradi.exception.user.belongs.groups"));
                        }
                    }
                }
            }
            
            // remove user
            users.remove(bean);
        }
        
        return super.removeChildNode(node);
    }
}
