package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.OfferListColumnFactory;
import com.jurismarches.vradi.ui.OfferTable;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.email.renderers.SendingRenderer;
import com.jurismarches.vradi.ui.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.OfferListTableModel;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class QueryMakerViewUI<E extends QueryMaker> extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEANS_MODEL = "beansModel";
    public static final String PROPERTY_FORM = "form";
    public static final String PROPERTY_QUERY_MAKERS_MODEL = "queryMakersModel";
    public static final String PROPERTY_SESSION = "session";
    public static final String PROPERTY_TITLE_UI = "titleUI";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_BUTTON_ENABLED = "addButton.enabled";
    public static final String BINDING_BEANS_LIST_MODEL = "beansList.model";
    public static final String BINDING_QUERY_MAKERS_COMBO_MODEL = "queryMakersCombo.model";
    public static final String BINDING_REMOVE_BUTTON_ENABLED = "removeButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVkopoKIEAhEjKom3KdFoTCDKrzRCCkSqhNiL050nHZzdWWZmy3Ix/gn+CXr3YuLNk/Hg2YMX479gjAevxpndttuWAk3oYdu+ed833/f2vff+F8ooia7vkTDEMvA0cwGvLe7sbFb2wNEroBzJfC0kij+pNEqX0RBtxpVGN8tFC8/X4fll4frCA68FPVdEg0ofclBVAK3R1XaEo1S+1DyeC/1ANliborqxvv3zO/2Gvn6XRij0jbohY2X6NFTipK+I0oxqdNncVCN5TrxdI0Myb9foPW9jy5wotUFc2EevULaI+n0iDZlGN3q3HHFE+NDXaGQ/AHm4Tl6C3GZw8HRVo1lHuHgvkEy5RDpVULgmCWU4YBhcwjh+3AHx/YivX6OsZpqDJRmxcrG1gGMLLUkKlGLC0+jOMTcpkDXmmL9UC7xtQ6UYsvJkM+HpeyGke7zcoyQFk9/G0GJerQsKXKNJqzvE6sBItm+rIpZEGJ0lsMEKEK8BGGsFFJnSHckDM2tFUgE+a95ra2octUm5Zu6wBFfUYCnQ2pZntC0/jrYDcoTSJD7dftjqLnLSIXatYa+DM3JnnWh0qV2xidVzJbrS1tdmYnAyMUlLp8ooIwMT1miifHTItsxRPF4THeNlCaPTf+Oj3z/9/FhozFTO3D3WNbVlJZhe96XwQWpmr74YD1SgGc+vE3+ubFiAm30S7YupLsJK9WMjztwXlQFbOH5EVNVQZLI/Pn8Zf/7tHEoX0CAXhBaIzV9FOV2VpgqC09B/uBApGj4YMM8Rq810rYbQVPbCPCWaTFeYR01tH4SmBFNdStDUUcl9/Tta+rDQKEPKyJo8Nj0pReYZ6mceZx5Ey6W+N7oukyFfQUBFsh+6bYyU/Z7y6/2No+ftrj6ZE3fl3TCwX/ci0fbX/YjjWg8cWfBIhQM9E40Nz5/AcKMnhsUzMWiUce1aOIFkpgeSAbPsKUiQZ+QZdoDzrdO5bvVUmo1TGP4DGGy/j9QHAAA=";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.QueryMakerViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton addButton;
    protected javax.swing.JList beansList;
    protected javax.swing.ListModel beansModel;
    protected com.jurismarches.vradi.services.dto.VradiFormDTO form;
    protected QueryMakerViewUI queryMakerViewUI = this;
    protected javax.swing.JComboBox queryMakersCombo;
    protected javax.swing.ComboBoxModel queryMakersModel;
    protected javax.swing.JButton removeButton;
    protected com.jurismarches.vradi.services.dto.VradiSessionDTO session;
    protected java.lang.String titleUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected EmailNavigationTreeHelper helper;
    protected Map<E, VradiSendingDTO> beans;
    protected java.util.List<E> queryMakers;
    
    
    public void setHelper(EmailNavigationTreeHelper helper){
        this.helper = helper;
    }
    
    public EmailNavigationTreeHelper getHelper(){
        if (helper != null){
            return helper;
        }
        jaxx.runtime.JAXXUtil.assignment(helper = getContextValue(EmailNavigationTreeHelper.class), "helper", com.jurismarches.vradi.ui.email.QueryMakerViewUI.this);
        if (helper != null){
            return helper;
        }
        return getParentContainer(EmailPopupUI.class).helper;
    }
    
    protected EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        VradiSessionDTO currentSession = getContextValue(VradiSessionDTO.class);
        setSession(currentSession);
        VradiFormDTO formSelected = getContextValue(VradiFormDTO.class);
        setForm(formSelected);
    }
    
    public void setQueryMakers(java.util.List<E> queryMakers){
        this.queryMakers = queryMakers;
        updateQueryMakersModel();
    }
    
    public java.util.List<E> getQueryMakers(){
        if (getBeans() != null){
            queryMakers.removeAll(getBeans().keySet());
        }
        return queryMakers;
    }
    
    public void setBeans(Map<E, VradiSendingDTO> beans){
        this.beans = beans;
        updateBeansModel();
        updateQueryMakersModel();
    }
    
    public Map<E, VradiSendingDTO> getBeans(){
        return beans;
    }
    
    protected void updateQueryMakersModel(){
        setQueryMakersModel(UIHelper.getQueryMakersModel(getQueryMakers()));
        queryMakersCombo.setModel(getQueryMakersModel());
    }
    
    protected void updateBeansModel(){
        setBeansModel(UIHelper.getSendingModel(getBeans()));
        beansList.setModel(getBeansModel());
    }
    
    protected void add(){
        getHandler().addQueryMaker(this, getBeans(), session, form, (E)queryMakersCombo.getSelectedItem());
    }
    
    protected void remove(){
        getHandler().removeQueryMaker(this, getBeans(), session, form, (VradiSendingDTO)beansList.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public QueryMakerViewUI() {
        $initialize();
    }

    public QueryMakerViewUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(java.awt.event.ActionEvent event) {
        add();
    }

    public void doActionPerformed__on__removeButton(java.awt.event.ActionEvent event) {
        remove();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getAddButton() {
        return addButton;
    }

    public javax.swing.JList getBeansList() {
        return beansList;
    }

    public javax.swing.ListModel getBeansModel() {
        return beansModel;
    }

    public com.jurismarches.vradi.services.dto.VradiFormDTO getForm() {
        return form;
    }

    public javax.swing.JComboBox getQueryMakersCombo() {
        return queryMakersCombo;
    }

    public javax.swing.ComboBoxModel getQueryMakersModel() {
        return queryMakersModel;
    }

    public javax.swing.JButton getRemoveButton() {
        return removeButton;
    }

    public com.jurismarches.vradi.services.dto.VradiSessionDTO getSession() {
        return session;
    }

    public java.lang.String getTitleUI() {
        return titleUI;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBeansModel(javax.swing.ListModel newValue) {
        javax.swing.ListModel oldValue = this.beansModel;
        this.beansModel = newValue;
        firePropertyChange(PROPERTY_BEANS_MODEL, oldValue, newValue);
    }

    public void setForm(com.jurismarches.vradi.services.dto.VradiFormDTO newValue) {
        com.jurismarches.vradi.services.dto.VradiFormDTO oldValue = this.form;
        this.form = newValue;
        firePropertyChange(PROPERTY_FORM, oldValue, newValue);
    }

    public void setQueryMakersModel(javax.swing.ComboBoxModel newValue) {
        javax.swing.ComboBoxModel oldValue = this.queryMakersModel;
        this.queryMakersModel = newValue;
        firePropertyChange(PROPERTY_QUERY_MAKERS_MODEL, oldValue, newValue);
    }

    public void setSession(com.jurismarches.vradi.services.dto.VradiSessionDTO newValue) {
        com.jurismarches.vradi.services.dto.VradiSessionDTO oldValue = this.session;
        this.session = newValue;
        firePropertyChange(PROPERTY_SESSION, oldValue, newValue);
    }

    public void setTitleUI(java.lang.String newValue) {
        java.lang.String oldValue = this.titleUI;
        this.titleUI = newValue;
        firePropertyChange(PROPERTY_TITLE_UI, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToQueryMakerViewUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(removeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(addButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(queryMakersCombo, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(beansList, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new javax.swing.JButton());
        addButton.setName("addButton");
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createBeansList() {
        $objectMap.put("beansList", beansList = new javax.swing.JList());
        beansList.setName("beansList");
    }

    protected void createBeansModel() {
        $objectMap.put("beansModel", beansModel = UIHelper.getSendingModel(getBeans()));
    }

    protected void createForm() {
        $objectMap.put("form", form = null);
    }

    protected void createQueryMakersCombo() {
        $objectMap.put("queryMakersCombo", queryMakersCombo = new javax.swing.JComboBox());
        queryMakersCombo.setName("queryMakersCombo");
    }

    protected void createQueryMakersModel() {
        $objectMap.put("queryMakersModel", queryMakersModel = UIHelper.getQueryMakersModel(getQueryMakers()));
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new javax.swing.JButton());
        removeButton.setName("removeButton");
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createSession() {
        $objectMap.put("session", session = null);
    }

    protected void createTitleUI() {
        $objectMap.put("titleUI", titleUI = "");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToQueryMakerViewUI();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        removeButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("remove"));
        addButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        queryMakersCombo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        beansList.setCellRenderer(new SendingRenderer());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 5 data bindings
        $registerDefaultBindings();
        $objectMap.put("queryMakerViewUI", this);
        createTitleUI();
        createSession();
        createForm();
        createQueryMakersModel();
        createBeansModel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        createRemoveButton();
        createAddButton();
        createQueryMakersCombo();
        createBeansList();
        // inline creation of queryMakerViewUI
        setName("queryMakerViewUI");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"titleUI") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(_(getTitleUI()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (beansList != null) {
                    $bindingSources.put("beansList.getSelectionModel()", beansList.getSelectionModel());
                    beansList.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    beansList.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(com.jurismarches.vradi.ui.email.QueryMakerViewUI.this, BINDING_REMOVE_BUTTON_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (beansList != null) {
                    removeButton.setEnabled(beansList.getSelectedIndex() != -1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (beansList != null) {
                    javax.swing.ListSelectionModel $target = ((javax.swing.ListSelectionModel) $bindingSources.remove("beansList.getSelectionModel()"));
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    beansList.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(com.jurismarches.vradi.ui.email.QueryMakerViewUI.this, BINDING_REMOVE_BUTTON_ENABLED));
                }
            }
        
            public void $pr$u0(javax.swing.event.ListSelectionEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (queryMakersCombo != null) {
                    $bindingSources.put("queryMakersCombo", queryMakersCombo);
                    queryMakersCombo.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u1"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (queryMakersCombo != null) {
                    addButton.setEnabled(queryMakersCombo.getSelectedIndex() != -1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (queryMakersCombo != null) {
                    javax.swing.JComboBox $target = ((javax.swing.JComboBox) $bindingSources.remove("queryMakersCombo"));
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u1"));
                    }
                }
            }
        
            public void $pr$u1(java.awt.event.ItemEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_MAKERS_COMBO_MODEL, true ,"queryMakersModel") {
        
            @Override
            public void processDataBinding() {
                queryMakersCombo.setModel(getQueryMakersModel());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BEANS_LIST_MODEL, true ,"beansModel") {
        
            @Override
            public void processDataBinding() {
                beansList.setModel(getBeansModel());
            }
        });
    }

}