package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreeModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class EmailPopupUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28bRRSeuHFSJzYJDklbNVQujQqHsi4gxCEF2joJrWVoWgeI8IXx7iSedLyzzMzGGw6IMyf+BLgjJCRunBAHzhy4IP4FhDhwrXgza+962/V6hX1Y2/Pe++Z7v7797i9UlAJdPcFBYAnfVbRPrOadw8MH3RNiqx0ibUE9xQUKP3MFVOigZSc6lwpd67R0eH0YXm/wvsdd4o5Fb7fQklRnjMgeIUqhF5MRtpT1dmTeDjxfjFAjUmmo3/zzd+Fr58tvCwgFHrCrQiq1aVFxJvMtVKCOQlW46RTXGXaPgYag7jHwreizBsNSfoD75DP0BVpsoQUPCwBT6KX8KRsMEx94CpVJH1O2zz3f+/C+Qjds3rdOfEFlHwu7R6R1KrBDLZ9axtHaHXP3PIOzoFDF5q6C61r4jPtA50oiaTmAFKwGFk5ofz0OLG812x6jah+75KZCGzrJYBgQW7RzKYo5v9XUhwz8qwl/c6qdVp7xfU3/f0E/qpFtcesAd5m+9mIKXWPTnuvjYC3cTbnYnGqnC5Hv85JISbm7gxXZp/ZjIhSqcXFsncCsPlbcC2MDq3kYuyQhRtcZ7ptJW+WIMkVEo8e51NDrCT7Q/i6/y4NkTGmreReaw13gv5bwD4+TyVagM7bgjA1bcyHZmsiUrOk5F59C8gnfA0GM1ytx5YfjEjVl5emmmJwvJfse8TfGl/XjZmScl8R1Us7LNoMKtcNmjNsFupzoOuy8Fe98vJRzHVQUPhzDmHSelYlHYAoF4uJTAqEBjfXJxtrvP/35495IFTbh7vVU1zFRg231BPegt1RfvRJKgq8oq7+Pve0OKknCQBGN4m2mEGsPzUAO7jMdsXS4dQ/LHkAUF//4+ZeNT387hwp7aIlx7Oxh7X8flVRPQBU4cwLv3duGUXlwHp6rmhvMmkOOsM9UQ1f2AVDECmqr0HO3HKxwrUtdB/r+TgA12UypSUSsW/r137X2D7dHdZkDnpcmuse1KX6CFqjLqEuMXg6lMFUflz1JfIfHkpcmgnP6e8kbitLb5nknLfGFHqHHPZC36q3w/hpWIM9dXxHIVoftmjT0r/fyozIjitq+8/9RioqqUK9aM4AM4PXTmxGk5sNUuOzsIyopbHL8KoKOuqMtnIBfyYFfBbQD7tu93cDDrjOS6QmIqzkQyzDu9HPyseluRh+mY+njhxkIazMjbOTIZ16RQGXU5HIeDNhlksHjSq5MBhksruYZyD53wjfrBBrX8qRC7XDoJmBcz4FROgKFe1VPSUZGN3IALQvO1XA1ZoRaBY0eyEeAdw/2AN5QM+FNG7x6LoSvMhDemHlk8iFkcXgzR10XiatFxZkJZloq+RCyUnkrF8L3MyNkZTEdAcp5OnXaNcx/f9WkXPoNAAA=";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.EmailPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton closeSession;
    protected javax.swing.JPanel content;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected EmailPopupUI emailPopupUI = this;
    protected javax.swing.JComboBox filterChooser;
    protected javax.swing.JTree nav;
    protected javax.swing.JButton send;
    protected org.jdesktop.swingx.JXDatePicker sessionDatePicker;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSplitPane $JSplitPane0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JPanel $JPanel1;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JButton $JButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected EmailNavigationTreeHelper helper;
    
    
    protected EmailNavigationTreeHelper getHelper() {
        return helper;
    }
    
    protected EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        SwingUtil.center(getOwner(), this);
        jaxx.runtime.JAXXUtil.assignment(helper = new EmailNavigationTreeHelper(this, nav), "helper", com.jurismarches.vradi.ui.email.EmailPopupUI.this);
        updateTree();
        SwingUtil.addExpandOnClickListener(nav);
    }
    
    public void updateTree() {
        if (log.isDebugEnabled()) {
            log.debug("updateTree");
        }
        java.util.List<VradiSessionDTO> sessions = getHandler().getSessions(sessionDatePicker.getDate());
        helper.updateData(sessions, (EmailNavigationTreeHelper.EmailFilterEnum)filterChooser.getSelectedItem());
        nav.setModel((TreeModel)helper.createTreeModel(this));
        nav.setSelectionModel(helper.createTreeHandler(this));
        send.setEnabled(isOpenSession());
        closeSession.setEnabled(isOpenSession());
    }
    
    protected void close() {
        getHandler().close(this);
    }
    
    protected void send() {
        // disable buttons to avoid duplicate send
        boolean started = getHandler().send(this);
        if (started) {
            send.setEnabled(false);
            closeSession.setEnabled(false);
        }
    }
    
    protected boolean isOpenSession() {
        if (helper == null) {
            return false;
        }
        return helper.getActiveSession() != null &&
            !helper.getActiveSession().getSendingList().isEmpty();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EmailPopupUI() {
        $initialize();
    }

    public EmailPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        updateTree();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().bindEmailsWithForms(this);
    }

    public void doActionPerformed__on__closeSession(java.awt.event.ActionEvent event) {
        getHandler().closeSession(this);
    }

    public void doActionPerformed__on__send(java.awt.event.ActionEvent event) {
        send();
    }

    public void doWindowClosing__on__emailPopupUI(java.awt.event.WindowEvent event) {
        close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCloseSession() {
        return closeSession;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public javax.swing.JComboBox getFilterChooser() {
        return filterChooser;
    }

    public javax.swing.JTree getNav() {
        return nav;
    }

    public javax.swing.JButton getSend() {
        return send;
    }

    public org.jdesktop.swingx.JXDatePicker getSessionDatePicker() {
        return sessionDatePicker;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEmailPopupUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JSplitPane0, BorderLayout.CENTER);
        add($Table1, BorderLayout.SOUTH);
    }

    protected void createCloseSession() {
        $objectMap.put("closeSession", closeSession = new javax.swing.JButton());
        closeSession.setName("closeSession");
        closeSession.setText(_("vradi.email.closeSession"));
        closeSession.setVisible(true);
        closeSession.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__closeSession"));
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createFilterChooser() {
        $objectMap.put("filterChooser", filterChooser = new javax.swing.JComboBox());
        filterChooser.setName("filterChooser");
    }

    protected void createNav() {
        $objectMap.put("nav", nav = new javax.swing.JTree());
        nav.setName("nav");
        if (nav.getFont() != null) {
            nav.setFont(nav.getFont().deriveFont((float) 11));
        }
        nav.setRootVisible(false);
        nav.setShowsRootHandles(true);
    }

    protected void createSend() {
        $objectMap.put("send", send = new javax.swing.JButton());
        send.setName("send");
        send.setText(_("vradi.email.send"));
        send.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__send"));
    }

    protected void createSessionDatePicker() {
        $objectMap.put("sessionDatePicker", sessionDatePicker = new org.jdesktop.swingx.JXDatePicker());
        sessionDatePicker.setName("sessionDatePicker");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToEmailPopupUI();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JPanel0, JSplitPane.LEFT);
        $JSplitPane0.add(content, JSplitPane.RIGHT);
        // inline complete setup of $JPanel0
        $JPanel0.add($JPanel1, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JPanel1
        $JPanel1.add($Table0, BorderLayout.CENTER);
        $JPanel1.add($JButton0, BorderLayout.EAST);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sessionDatePicker, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(filterChooser, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(nav);
        // inline complete setup of $Table1
        $Table1.add($JButton1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(send, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(closeSession, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 14 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        $JSplitPane0.setResizeWeight(0.1);
        sessionDatePicker.setDate(new java.util.Date());
        filterChooser.setModel(new DefaultComboBoxModel(EmailNavigationTreeHelper.EmailFilterEnum.values()));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("search"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("search"));
        send.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("send"));
        send.setEnabled(isOpenSession());
        closeSession.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        closeSession.setEnabled(isOpenSession());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("emailPopupUI", this);
        createContentLayout();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new javax.swing.JSplitPane());
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.session"));
        createSessionDatePicker();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.email.filter"));
        createFilterChooser();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createNav();
        createContent();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        $Table1.setName("$Table1");
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.email.bind"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createSend();
        createCloseSession();
        // inline creation of emailPopupUI
        setName("emailPopupUI");
        SwingUtil.setComponentHeight(emailPopupUI,600);
        emailPopupUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.email.title"));
        SwingUtil.setComponentWidth(emailPopupUI,1024);
        emailPopupUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__emailPopupUI"));
        
        $completeSetup();
    }

}