package com.jurismarches.vradi.ui.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.editors.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public abstract class VradiEditor<O, M extends VradiEditorModel<O>> extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_NAME_LABEL_TEXT = "fieldNameLabel.text";
    public static final String BINDING_FIELD_NAME_LABEL_TOOL_TIP_TEXT = "fieldNameLabel.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Sy24TMRS9mTZpk5DyqChFLdACWxz2QVAUiCAKD5EKVWSDE7uNI8/Y2J52ygLxCXwC7NkgsWOFWLBmwQbxCwixYIuwnVcDg1qpzMIzc33P8fG55/U3yGoFqz2cJEjFkWEhRfXrGxv32j3aMTeo7igmjVDQfzIBBC0oklFdG7jQajh4eQAvV0UoRUSjPehKAwra7HKqu5QaA2cmER2ty83RdiWRsRqyjkSlsb788T14QZ6/CgASadVN2aus7Ica32S6AQEjBk7Yk7ZxmeNoy8pQLNqyekuuVuVY67s4pE/gGcw0ICexsmQGzh/8yp7D4xNpYPZi/T6OKL9s4FJHhKgXK6ZDrDpdqtG2woShmCFKmPMWPXSFm/5HSk+SMzC3ySgnTlUDtym3+p3UBOkdqxzVfdG15keIUp+vKiLj1U8CvJ4BQMHShH92Mmg8mbF1mRZkVWzLBhZbfw/zgd3qj3HxjzE6Qr/7a2H+87uvb2vD2bkYnkxt3RM966lUQlJlmDv6aH9wsWG8fAfLSgvymnKbW5/L5RRhzcG2FWfPO+7gyMHRLay7liI78+X9h4XHn6YgqEGBC0xq2PXfhrzpKuuC4CSR19a8oiM7s3Y95rQZyHG8K2Jr7twVgg1eabOIWHuvJtaE5RQTRkra+Y8/55tv1oZGZKyw0/9sH5uRfQQ5FnEWUR/jQUJTY1uUmsZEjJOYls2MexfkIGen/LqUdtNiyCIWxmGTPfUHnE1i9zrntbuvVU9VOgBVSSq6SZWi5D+QTRuamENyFI0QfJ3J9f2pfgMHUBW1OwUAAA==";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.editors.VradiEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel editorContent;
    protected javax.swing.JLabel fieldNameLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VradiEditor $JPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
     * Initialize the editor, must be call before any use of it.
     */
    public void init() {
        // model is null, when coming here from parent
        applyDataBinding("fieldNameLabel.text");
    }
    
    public abstract VradiEditorModel<O> getModel();
    
    public String getFieldName() {
        return getModel().getFieldName();
    }
    
    public void setFieldName(String newValue) {
        getModel().setFieldName(newValue);
    }
    
    public String getFieldDescription() {
        return getModel().getFieldDescription();
    }
    
    public void setFieldDescription(String newValue) {
        getModel().setFieldDescription(newValue);
    }
    
    public String getExtensionName() {
        return getModel().getExtensionName();
    }
    
    public void setExtensionName(String newValue) {
        getModel().setExtensionName(newValue);
    }
    
    public String getExtensionFieldName() {
        return getModel().getExtensionFieldName();
    }
    
    public void setExtensionFieldName(String newValue) {
        getModel().setExtensionFieldName(newValue);
    }
    
    public O getValue() {
        return getModel().getValue();
    }
    
    public void setValue(O newValue) {
        getModel().setValue(newValue);
    }
    
    public String getValidatorContext() {
        return getModel().getValidatorContext();
    }
    
    public void setValidatorContext(String newValue) {
        getModel().setValidatorContext(newValue);
        registerValidator();
    }
    
    abstract void registerValidator();

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VradiEditor() {
        $initialize();
    }

    public VradiEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getEditorContent() {
        return editorContent;
    }

    public javax.swing.JLabel getFieldNameLabel() {
        return fieldNameLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createEditorContent() {
        $objectMap.put("editorContent", editorContent = new javax.swing.JPanel());
        editorContent.setName("editorContent");
    }

    protected void createFieldNameLabel() {
        $objectMap.put("fieldNameLabel", fieldNameLabel = new javax.swing.JLabel());
        fieldNameLabel.setName("fieldNameLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(fieldNameLabel, BorderLayout.WEST);
        add(editorContent, BorderLayout.CENTER);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        fieldNameLabel.setMinimumSize(new Dimension(0,28));
        fieldNameLabel.setPreferredSize(new Dimension(80,15));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 2 data bindings
        $registerDefaultBindings();
        $objectMap.put("$JPanel0", this);
        createFieldNameLabel();
        createEditorContent();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_NAME_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("fieldName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    fieldNameLabel.setText(_(getModel().getFieldName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("fieldName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_NAME_LABEL_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("fieldDescription", this);
                }
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("fieldName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    fieldNameLabel.setToolTipText(_(getModel().getFieldDescription() != null ?                     SwingUtil.getStringValue(getModel().getFieldDescription()) :                     SwingUtil.getStringValue(getModel().getFieldName())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("fieldDescription", this);
                }
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("fieldName", this);
                }
            }
        });
    }

}