package com.jurismarches.vradi.ui.editors;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.editors.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class IdEditor extends com.jurismarches.vradi.ui.editors.VradiEditor<String, StringEditorModel> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_TEXT = "editor.text";
    public static final String BINDING_WIKITTY_ID_TEXT = "wikittyId.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UPW8TQRAdm9iJE8yHI0wigggEgQDpjESDlCgEAhaJHEAxiiLcsPYu8Ya9u2V3L7lQIH4CPwF6GiQ6KkRBTUGD+AsIUdAiZs8fF8NBTgIXd9bMvDdv387cyy+Q0wpObpIwdFTgGe4yZ/nq+vrt5iZrmetMtxSXxlfQ+WWykG3AGO3HtYGZRs3CK114ZdF3pe8xbxd6tgaj2uwIptuMGQPHBxEtrSv1fno2lIHqsfZFJbE+//Y1+4w+fZEFCCWqy+NRpvdCxScZqkGWUwMl7LRFKoJ4GyhDcW8D9RZtbFEQrW8Rlz2CJzBcg7wkCskMnEp/5IgjwofSQPH0miKU36Acay4aON/yXWczUFy7RLXaTDtbNu8E3GFRjXaWaKdayogmbyDn+pQJA5X04BWLiBkKW0RwSjBh4MKAY/2Eo7fRCadun2u9YMxQ7HRY9D0TOVKyfoVd0PId4u1ul+8UGygPVN1loalyJqgtK8XitvlDbszOUhQ/2k0qODYgFIfGiYcmvtVMA3IqwLCBicbvc7aKqc6ETfwyYZYwyv4oj3988/l1tTdWBex9JLF011bgdUvlS6YMt60PdmYqMFxUVoicbSALE7hS0cpMJQird9MoDvsdtnDHwp2bRLeRIjf86e278v0P+yBbhVHhE1oltn4JCqat0AVf0FBeWYgU7d8ewechqw3dF2THD/CODszhJZLpJvco+j8foglTCSb0lTQL77+P118t9IzIoLDJP5bHZuTuQZ57gnss2rDu8iRu1JjULKB+vCRJa5Ox73HZnacT0XMm6aRjLgm5G7h1/jhqcCYM7OtspN3+O5eaarjli8D18LJKc52zTBODH4dmYNh8Mm05lULupVCYhqooFXvAlGL0P5ANGdzFf+QYsVtOmiLScimZZ3JPHhu+/Bcl6Riu7cHwEzQehJL5BgAA";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTextField editor;
    protected com.jurismarches.vradi.ui.editors.IdEditorModel model;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.editors.IdEditorModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    protected javax.swing.JTextField wikittyId;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private IdEditor $VradiEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
            void registerValidator() {
                validator.setContextName(model.getValidatorContext());
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
    
                log.debug("registration : " + validator.getContextName());
            }
    
            public String getModifiablePartOfValue(String value) {
                if(value == null) {
                    return null;
                }
                int modifiablePartLength =
                        VradiConstants.FORM_ID_DATE_FORMAT.toPattern().length();
                return value.substring(0, modifiablePartLength);
            }
    
            public String getUnmodifiablePartOfValue(String value) {
                if(value == null) {
                    return null;
                }
                int unmodifiablePartLength =
                        VradiConstants.FORM_ID_DATE_FORMAT.toPattern().length();
                return value.substring(unmodifiablePartLength);
            }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public IdEditor() {
        super();
        $initialize();
    }

    public IdEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.editors.IdEditorModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyReleased__on__editor(java.awt.event.KeyEvent event) {
        setValue(editor.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTextField getEditor() {
        return editor;
    }

    public com.jurismarches.vradi.ui.editors.IdEditorModel getModel() {
        return model;
    }

    public javax.swing.JTextField getWikittyId() {
        return wikittyId;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(SwingUtil.boxComponentWithJxLayer(editor), BorderLayout.WEST);
        editorContent.add(wikittyId, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(model);
        validator.setFieldRepresentation("value", editor);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new javax.swing.JTextField());
        editor.setName("editor");
        editor.setColumns(15);
        editor.setColumns(8);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        ((javax.swing.JPanel) editorContent).setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new com.jurismarches.vradi.ui.editors.IdEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.editors.IdEditorModel >(com.jurismarches.vradi.ui.editors.IdEditorModel.class, null));
    }

    protected void createWikittyId() {
        $objectMap.put("wikittyId", wikittyId = new javax.swing.JTextField());
        wikittyId.setName("wikittyId");
        wikittyId.setColumns(15);
        wikittyId.setEditable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToEditorContent();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        ((javax.swing.JPanel) editorContent).setMaximumSize(new Dimension(0, 28));
        editor.setMinimumSize(new Dimension(0,28));
        editor.setPreferredSize(new Dimension(0,28));
        wikittyId.setMinimumSize(new Dimension(0,28));
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 2 data bindings
        $registerDefaultBindings();
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createValidator();
        createEditor();
        createWikittyId();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    jaxx.runtime.SwingUtil.setText(editor, getModifiablePartOfValue(model.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WIKITTY_ID_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    jaxx.runtime.SwingUtil.setText(wikittyId, getUnmodifiablePartOfValue(model.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
    }

}