package com.jurismarches.vradi.ui.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.editors.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class EmailEditor extends com.jurismarches.vradi.ui.editors.VradiEditor<String, EmailEditorModel> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_TEXT = "editor.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTTW8TMRCdhCYlLeUjUatWFKlAJRCIDeJaBC2lEVQpIIKqilxwslbjyOs1trfdckD8BH4C3LkgceOEOHDmwAXxFxDiwBUx9ibZBrZqK3LwRjPz3jw/z7z5DgWt4GyXxLGnImFYQL3VpY2N+60ubZvbVLcVkyZUkPxyecg3YdwfxLWB8826hVd78OpyGMhQULELvVCHMW12ONUdSo2BM8OIttbVxiC9EMtI9VkHorJYX/38kX/pv3idB4glqiviVeb2Q6U3GalDnvkGythpi1Q5EZsoQzGxiXonbGyZE63vkYA+hecwWoeiJArJDJw7+JUdh8PH0sDE/LoiPlvxGdZcNXClHQZeN1JMB0S1O1R7WzbvRcyjrkZ7KwFhPAFI6ZiKBgpB6FNu4Nqh8GsWlJKUtghnPsGEgctDvg0Snt5GP7yGPdf7wZRhImmyHArjfClb1+IeaPUBEbvbFZNiA5NDVY9obJYUJbaqnGqbX70VGRMKNKkyVJ+Ee9UKTg8Jx1Hy0lFK3zrXhIKKMGxguvnv9D3EVDJ303/NnSV02d9TlS/vv72r9YfN7s1kZumuXcEhkCqUVBlmW59IJi0yjFfXiFxoQklTjovmFmk2Q1ijl0Zx2O+UhXsW7t0huoMUhdGvHz5OPfl8BPI1GOMh8WvE1t+FkukodCHkfixvLjpFx7aP4nnSasPX4GQnRCvh+HV8VDLXYsJHf2/EaMJshgkDJa3Sp1+VxtvFvhE5FDazZ3lqRuExFJngTFC3d72Vytyzcalp5Ifp6mQtU85+K7I3X3PunM+66XjABAuioMGeuQYX4sh+Ljrt9t8lRzV1AKoRg8P6vxysnYzvHhwzB+AYpYK0OPX3ofkDEI4T4t8FAAA=";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTextArea editor;
    protected com.jurismarches.vradi.ui.editors.EmailEditorModel model;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.editors.EmailEditorModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EmailEditor $VradiEditor0 = this;
    private javax.swing.JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
            }
    
            protected void createEmail() {
                try {
                    UIHelper.createEmail(editor.getText());
                } catch(java.io.IOException eee) {
                    if (log.isErrorEnabled()) {
                        log.error(eee);
                    }
                    ErrorDialogUI.showError(eee);
                } catch(java.net.URISyntaxException eee) {
                    if (log.isErrorEnabled()) {
                        log.error(eee);
                    }
                    ErrorDialogUI.showError(eee);
                } catch(java.lang.UnsupportedOperationException eee) {
                    if (log.isErrorEnabled()) {
                        log.error(eee);
                    }
                    ErrorDialogUI.showError(eee);
                }
            }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EmailEditor() {
        super();
        $initialize();
    }

    public EmailEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.editors.EmailEditorModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        createEmail();
    }

    public void doKeyReleased__on__editor(java.awt.event.KeyEvent event) {
        setValue(editor.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTextArea getEditor() {
        return editor;
    }

    public com.jurismarches.vradi.ui.editors.EmailEditorModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(SwingUtil.boxComponentWithJxLayer(editor), BorderLayout.CENTER);
        editorContent.add($JButton0, BorderLayout.EAST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(model);
        validator.setFieldRepresentation("value", editor);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new javax.swing.JTextArea());
        editor.setName("editor");
        editor.setColumns(15);
        editor.setLineWrap(true);
        editor.setWrapStyleWord(true);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        ((javax.swing.JPanel) editorContent).setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new com.jurismarches.vradi.ui.editors.EmailEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.editors.EmailEditorModel >(com.jurismarches.vradi.ui.editors.EmailEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToEditorContent();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        editor.setMinimumSize(new Dimension(0,28));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("send"));
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 2 data bindings
        $registerDefaultBindings();
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createValidator();
        createEditor();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    jaxx.runtime.SwingUtil.setText(editor, model.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("value", this);
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    $JButton0.setEnabled(getValue() != null && validator.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("value", this);
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}