package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.InfogeneImpl;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.FieldSelectModel;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidatorMessageListRenderer;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminFormTypeUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<WikittyExtension> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_TEMPLATE_CHOICE_MODEL = "templateChoice.model";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.sharengo.wikitty.WikittyExtension bean;
    protected jaxx.runtime.swing.CardLayout2 cardLayout;
    protected javax.swing.JPanel cardPanel;
    protected jaxx.runtime.swing.VBox content;
    protected javax.swing.JButton create;
    protected javax.swing.JButton createForm;
    protected jaxx.runtime.swing.Table fieldListUI;
    protected jaxx.runtime.swing.HidorButton hidorInfogene;
    protected javax.swing.JPanel infogene;
    protected jaxx.runtime.swing.HBox lastModified;
    protected javax.swing.JButton newTemplate;
    protected javax.swing.JButton templateBindingButton;
    protected javax.swing.JComboBox templateChoice;
    protected javax.swing.JButton templateExampleButton;
    protected javax.swing.JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminFormTypeUI $AdminContentUI0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    @Override
    public void openUI(NavigationTreeNode node) throws Exception {
        super.openUI(node);
    
        content.removeAll();
        infogene.removeAll();
        lastModified.removeAll();
    
        if (getBean() != null) {
            int i = 0;
            Collection<String> fieldNames = getBean().getFieldNames();
            for (String fieldName : fieldNames) {
                FieldType fieldType = getBean().getFieldType(fieldName);
                String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
                FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldDesc,
                        VradiHelper.getFieldTypeEnum(fieldType), i);
                create(fieldSelectModel);
                i = i + 1;
            }
            String date = getBean().getTagValue(VradiHelper.TYPE_LAST_MODIFIED_DATE);
            String time = getBean().getTagValue(VradiHelper.TYPE_LAST_MODIFIED_TIME);
            String user = getBean().getTagValue(VradiHelper.TYPE_LAST_MODIFIED_BY);
    
            log.debug(date + " " + time + " " + user);
            if(date != null && time != null && user != null) {
                String labelText = String.format(_("vradi.entity.lastModified.strings"), date, time, user);
                lastModified.add(new JLabel(labelText));
            }
            lastModified.validate();
            
            fillInfogenePanel();
    
            templateChoice.getModel().setSelectedItem(VradiHelper.getFormTypeTemplate(bean));
        }
        title.setText(_("vradi.adminForm.title", getStringValue(bean == null ? "" : bean.getName())));
        setModified(false);
    }
    
    @Override
    public void save() {
        getHandler().saveFormType(this);
        setModified(false);
    }
    
    protected void create() {
        create(new FieldSelectModel(content.getComponentCount()));
    }
    
    protected void create(FieldSelectModel fieldSelectModel){
       FieldSelectUI result = new FieldSelectUI(this);
    
       result.updateBean(fieldSelectModel);
       result.addPropertyChangeListener(FieldSelectUI.PROPERTY_MODIFIED, new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent evt) {
                    FieldSelectUI field = (FieldSelectUI) evt.getSource();
                    log.debug("field " + field + " modified value =  " + evt.getNewValue());
                    setModified(true);
                    if(evt.getNewValue() == null) {
    
                        if(field != null) {
                            field.setVisible(false);
                            content.remove(field);
                        }
                        if(field.getBean().isUpOrDown() != null) {
                            if(field.getBean().isUpOrDown() && field.getBean().getPosition() == 0) {
                                content.add(field, 0);
                            } else if(!field.getBean().isUpOrDown() && field.getBean().getPosition() == content.getComponentCount()) {
                                content.add(field);
                            } else {
                                int fieldToMovePosition = field.getBean().isUpOrDown() ?
                                        field.getBean().getPosition() - 1 : field.getBean().getPosition();
                                int fieldToAddPosition = field.getBean().isUpOrDown() ?
                                        field.getBean().getPosition() - 1 : field.getBean().getPosition() + 1;
                                FieldSelectUI fieldToMove = (FieldSelectUI) content.getComponent(fieldToMovePosition);
                                log.debug(fieldToMove.getBean().getNameValue() + " : " + fieldToMove.getBean().getPosition());
    
                                content.add(field, fieldToAddPosition);
                                for(int i = 0 ; i < content.getComponentCount() ; i++) {
                                    FieldSelectUI fieldSelectUI = (FieldSelectUI) content.getComponent(i);
                                    fieldSelectUI.getBean().setPosition(i);
                                    log.debug(fieldSelectUI.getBean().getNameValue() + " : " + fieldSelectUI.getBean().getPosition());
                                }
                            }
                            field.getBean().setUpOrDown(null);
                            field.setVisible(true);
                        }
                        content.validate();
                    }
                }
        });
        result.setModified(false);
    
       content.add(result);
       validate();
    }
    
    private void fillInfogenePanel() {
        WikittyExtension extension = InfogeneImpl.extensionInfogene;
        int i = 0;
        java.util.List<String> fieldNames = new ArrayList<String>();
        fieldNames.add(Infogene.FIELD_ID);
        fieldNames.add(Infogene.FIELD_OBJET);
        fieldNames.add(Infogene.FIELD_DESCRIPTION);
        fieldNames.add(Infogene.FIELD_CREATIONDATE);
        fieldNames.add(Infogene.FIELD_ENTITY);
        fieldNames.add(Infogene.FIELD_SOURCETEXT);
        fieldNames.add(Infogene.FIELD_SOURCEURL);
        fieldNames.add(Infogene.FIELD_COUNTRY);
        fieldNames.add(Infogene.FIELD_DEPARTMENT);
        fillInfogenePanel(fieldNames, extension, i);
    
        extension = FormImpl.extensionForm;
        fieldNames.clear();
        fieldNames.add(Form.FIELD_DATEPUB);
        fieldNames.add(Form.FIELD_DATEPEREMPTION);
        fillInfogenePanel(fieldNames, extension, i);
    }
    
    private void fillInfogenePanel(java.util.List<String> fieldNames,
                                   WikittyExtension extension, int i) {
        for (String fieldName : fieldNames) {
            FieldType fieldType = extension.getFieldType(fieldName);
            String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
    
            FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldDesc,
                    FieldTypeEnum.valueOf(fieldType), i);
    
            FieldDisplayUI fieldDisplayUI = new FieldDisplayUI(this);
            fieldDisplayUI.updateBean(fieldSelectModel);
    
            infogene.add(fieldDisplayUI);
            i = i + 1;
        }
    
    }
    
    private void onHidorInfogene() {
        if (hidorInfogene.isSelected()) {
            cardLayout.show(cardPanel, "infogene");
        } else {
            cardLayout.show(cardPanel, "content");
        }
    }
    
    private void openTemplateFieldBindingUI() {
        TemplateFieldBindingUI templateFieldBindingUI =
                new TemplateFieldBindingUI(this);
        getHandler().updateTemplateFieldTableModel(templateFieldBindingUI,
                getBean(), (File) templateChoice.getSelectedItem());
        templateFieldBindingUI.setVisible(true);
    }
    
    @Override
    protected void updateBeanFromEntity(WikittyExtension bean) {
        setBean(bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminFormTypeUI() {
        super();
        $initialize();
    }

    public AdminFormTypeUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__create(java.awt.event.ActionEvent event) {
        create();
    }

    public void doActionPerformed__on__createForm(java.awt.event.ActionEvent event) {
        getHandler().createFormType(this, getHelper()); setModified(true);
    }

    public void doActionPerformed__on__hidorInfogene(java.awt.event.ActionEvent event) {
        onHidorInfogene();
    }

    public void doActionPerformed__on__newTemplate(java.awt.event.ActionEvent event) {
        getHandler().uploadNewTemplate(this);                                         openTemplateFieldBindingUI();
    }

    public void doActionPerformed__on__templateBindingButton(java.awt.event.ActionEvent event) {
        openTemplateFieldBindingUI();
    }

    public void doActionPerformed__on__templateChoice(java.awt.event.ActionEvent event) {
        setModified(true);
    }

    public void doActionPerformed__on__templateExampleButton(java.awt.event.ActionEvent event) {
        getHandler().showTemplateExample(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.sharengo.wikitty.WikittyExtension getBean() {
        return bean;
    }

    public jaxx.runtime.swing.CardLayout2 getCardLayout() {
        return cardLayout;
    }

    public javax.swing.JPanel getCardPanel() {
        return cardPanel;
    }

    public jaxx.runtime.swing.VBox getContent() {
        return content;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JButton getCreateForm() {
        return createForm;
    }

    public jaxx.runtime.swing.Table getFieldListUI() {
        return fieldListUI;
    }

    public jaxx.runtime.swing.HidorButton getHidorInfogene() {
        return hidorInfogene;
    }

    public javax.swing.JPanel getInfogene() {
        return infogene;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public javax.swing.JButton getNewTemplate() {
        return newTemplate;
    }

    public javax.swing.JButton getTemplateBindingButton() {
        return templateBindingButton;
    }

    public javax.swing.JComboBox getTemplateChoice() {
        return templateChoice;
    }

    public javax.swing.JButton getTemplateExampleButton() {
        return templateExampleButton;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(org.sharengo.wikitty.WikittyExtension newValue) {
        org.sharengo.wikitty.WikittyExtension oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(fieldListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToCardPanel() {
        if (!allComponentsCreated) {
            return;
        }
        cardPanel.add(content, "content");
        cardPanel.add(infogene, "infogene");
    }

    protected void addChildrenToFieldListUI() {
        if (!allComponentsCreated) {
            return;
        }
        fieldListUI.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        toolbar.add(createForm, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCardLayout() {
        $objectMap.put("cardLayout", cardLayout = new jaxx.runtime.swing.CardLayout2());
    }

    protected void createCardPanel() {
        $objectMap.put("cardPanel", cardPanel = new javax.swing.JPanel());
        cardPanel.setName("cardPanel");
        cardPanel.setLayout(cardLayout);
    }

    protected void createContent() {
        $objectMap.put("content", content = new jaxx.runtime.swing.VBox());
        content.setName("content");
    }

    protected void createCreate() {
        $objectMap.put("create", create = new javax.swing.JButton());
        create.setName("create");
        create.setText(_("vradi.adminField.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createCreateForm() {
        $objectMap.put("createForm", createForm = new javax.swing.JButton());
        createForm.setName("createForm");
        createForm.setText(_("vradi.adminForm.createForm"));
        createForm.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForm"));
    }

    protected void createFieldListUI() {
        $objectMap.put("fieldListUI", fieldListUI = new jaxx.runtime.swing.Table());
        fieldListUI.setName("fieldListUI");
    }

    protected void createHidorInfogene() {
        $objectMap.put("hidorInfogene", hidorInfogene = new jaxx.runtime.swing.HidorButton());
        hidorInfogene.setName("hidorInfogene");
        hidorInfogene.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hidorInfogene"));
    }

    protected void createInfogene() {
        $objectMap.put("infogene", infogene = new javax.swing.JPanel());
        infogene.setName("infogene");
        infogene.setLayout(new GridLayout(0,1));
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createNewTemplate() {
        $objectMap.put("newTemplate", newTemplate = new javax.swing.JButton());
        newTemplate.setName("newTemplate");
        newTemplate.setText(_("vradi.adminFormType.template.new"));
        newTemplate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newTemplate"));
    }

    protected void createTemplateBindingButton() {
        $objectMap.put("templateBindingButton", templateBindingButton = new javax.swing.JButton());
        templateBindingButton.setName("templateBindingButton");
        templateBindingButton.setText(_("vradi.adminFormType.template.fieldBinding"));
        templateBindingButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateBindingButton"));
    }

    protected void createTemplateChoice() {
        $objectMap.put("templateChoice", templateChoice = new javax.swing.JComboBox());
        templateChoice.setName("templateChoice");
        templateChoice.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateChoice"));
    }

    protected void createTemplateExampleButton() {
        $objectMap.put("templateExampleButton", templateExampleButton = new javax.swing.JButton());
        templateExampleButton.setName("templateExampleButton");
        templateExampleButton.setText(_("vradi.adminFormType.template.showExample"));
        templateExampleButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateExampleButton"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new jaxx.runtime.swing.Table());
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToToolbar();
        addChildrenToBody();
        addChildrenToFieldListUI();
        // inline complete setup of $JPanel0
        $JPanel0.add(create);
        $JPanel0.add(hidorInfogene);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(cardPanel);
        addChildrenToCardPanel();
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel1);
        $JPanel1.add(templateChoice);
        $JPanel1.add(newTemplate);
        $JPanel1.add(templateBindingButton);
        $JPanel1.add(templateExampleButton);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        cardLayout.setUseOnlyVisibleComponentDimension(true);
        hidorInfogene.setHideText(_("vradi.adminFormType.hideInfogene"));
        hidorInfogene.setShowText(_("vradi.adminFormType.showInfogene"));
        hidorInfogene.setTarget(new jaxx.runtime.swing.Spacer());
        hidorInfogene.setTargetVisible(false);
        templateChoice.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 2 data bindings
        $registerDefaultBindings();
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createCardLayout();
        createTitle();
        createCreateForm();
        createFieldListUI();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.title"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        createCreate();
        createHidorInfogene();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createCardPanel();
        createContent();
        createInfogene();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminFormType.template.label"));
        createTemplateChoice();
        createNewTemplate();
        createTemplateBindingButton();
        createTemplateExampleButton();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((javax.swing.JPanel) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEMPLATE_CHOICE_MODEL, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                templateChoice.setModel(getHandler().getTemplateComboBoxModel(getBean()));
            }
        });
    }

}