package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiService;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.ClientNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.FormNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.GroupNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.helpers.XmlStreamNavigationTreeHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminPopupUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_TABS_MODEL = "adminTabs.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminPopupUI adminPopupUI = this;
    protected com.jurismarches.vradi.ui.admin.content.AdminStatusUI adminStatus;
    protected javax.swing.JTabbedPane adminTabs;
    protected com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI adminThesaurus;
    protected com.jurismarches.vradi.ui.admin.nav.AdminClientNavUI clientAdminNavUI;
    protected com.jurismarches.vradi.ui.admin.AdminNavUI formAdminNavUI;
    protected com.jurismarches.vradi.ui.admin.nav.AdminGroupNavUI groupAdminNavUI;
    protected com.jurismarches.vradi.ui.admin.AdminNavUI xmlStreamAdminNavUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.TabInfo $TabInfo0;
    private jaxx.runtime.swing.TabInfo $TabInfo1;
    private jaxx.runtime.swing.TabInfo $TabInfo2;
    private jaxx.runtime.swing.TabInfo $TabInfo3;
    private jaxx.runtime.swing.TabInfo $TabInfo4;
    private jaxx.runtime.swing.TabInfo $TabInfo5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean contextInitialized;
    private SingleSelectionModel selectionModel;
    
    
    public  AdminPopupUI(JAXXContext parentContext, Window parent) {
        super();$initialize();
    
        SwingUtil.initContext(this, parentContext);
        jaxx.runtime.JAXXUtil.assignment(selectionModel = new DefaultSingleSelectionModel() {
            private static final long serialVersionUID = 1L;
    
            @Override
            public void setSelectedIndex(int index) {
                int oldIndex = getSelectedIndex();
                if (oldIndex != -1) {
                    // on verifie que l'onglet en cours n'est pas modifie
                    AdminNavUI tab = getCurrentTab();
    
                    // null if is thesaurus selected
                    if (tab == null){
                        boolean canContinue = getThesaurusHandler().answerToSaveBeforeQuit(getTesaurusTab());
                        if (!canContinue) {
                            // l'utilisateur ne veut pas partir au final
                            return;
                        }
                    } else {
                        log.debug("current tab to close " + tab.getName());
                        AdminContentUI<?> content = tab.getCurrentContent();
                        boolean canContinue = getHandler().answerToSave(content);
                        if (!canContinue) {
                            // l'utilisateur ne veut pas partir au final
                            return;
                        }
                    }
                }
                super.setSelectedIndex(index);
            }
        }, "selectionModel", com.jurismarches.vradi.ui.admin.AdminPopupUI.this);
        jaxx.runtime.JAXXUtil.assignment(contextInitialized = true, "contextInitialized", com.jurismarches.vradi.ui.admin.AdminPopupUI.this);
    $initialize();
    }
    
    protected ThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, ThesaurusHandler.class);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public void close(){
        AdminNavUI navSelected = getCurrentTab();
        AdminHandler handler = getHandler();
        // if is thesaurus selected
        if (navSelected == null){
            boolean canContinue = getThesaurusHandler().answerToSaveBeforeQuit(getTesaurusTab());
            if (canContinue) {
                handler.close(this);
            }
            return;
        }
        AdminContentUI currentContent = navSelected.getCurrentContent();
        boolean canContinue = handler.answerToSave(currentContent);
        if (canContinue) {
            handler.close(this);
        }
    }
    
    public void showTab(int i){
        adminTabs.setSelectedIndex(i);
    }
    
    public AdminNavUI getCurrentTab() {
        Component selected = adminTabs.getSelectedComponent();
        if (selected instanceof AdminThesaurusUI ||
            selected instanceof AdminStatusUI) {
            return null;
        }
        return (AdminNavUI) selected;
    }
    
    public AdminStatusUI getStatusTab(){
        return (AdminStatusUI)adminTabs.getComponentAt(4);
    }
    
    public AdminThesaurusUI getTesaurusTab(){
        return (AdminThesaurusUI)adminTabs.getComponentAt(5);
    }
    
    public void updateTab(AdminNavUI ui) {
        // If id AdminThesaurus selected
        if (ui != null){
            TreePath path = ui.getNav().getSelectionPath();
            Object old = path == null ? null : path.getLastPathComponent();
    
            ui.getHelper().createTreeModel();
    
            if (old != null && old instanceof NavigationTreeNode) {
                // reselect node (if found)
                NavigationTreeNode node = (NavigationTreeNode) old;
                ui.getHelper().reSelectNode(ui, node.getFullPath());
            }
            ui.open();
        }
    }
    
    void $afterCompleteSetup() {
        SwingUtil.center(getOwner(), this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminPopupUI() {
        $initialize();
    }

    public AdminPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doStateChanged__on__adminTabs(javax.swing.event.ChangeEvent event) {
        updateTab(getCurrentTab());
    }

    public void doWindowClosing__on__adminPopupUI(java.awt.event.WindowEvent event) {
        close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.ui.admin.content.AdminStatusUI getAdminStatus() {
        return adminStatus;
    }

    public javax.swing.JTabbedPane getAdminTabs() {
        return adminTabs;
    }

    public com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI getAdminThesaurus() {
        return adminThesaurus;
    }

    public com.jurismarches.vradi.ui.admin.nav.AdminClientNavUI getClientAdminNavUI() {
        return clientAdminNavUI;
    }

    public com.jurismarches.vradi.ui.admin.AdminNavUI getFormAdminNavUI() {
        return formAdminNavUI;
    }

    public com.jurismarches.vradi.ui.admin.nav.AdminGroupNavUI getGroupAdminNavUI() {
        return groupAdminNavUI;
    }

    public com.jurismarches.vradi.ui.admin.AdminNavUI getXmlStreamAdminNavUI() {
        return xmlStreamAdminNavUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminPopupUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(adminTabs, BorderLayout.CENTER);
        add($JButton0, BorderLayout.SOUTH);
    }

    protected void addChildrenToAdminTabs() {
        if (!allComponentsCreated) {
            return;
        }
        adminTabs.add(clientAdminNavUI);
        adminTabs.add(groupAdminNavUI);
        adminTabs.add(formAdminNavUI);
        adminTabs.add(xmlStreamAdminNavUI);
        adminTabs.add(adminStatus);
        adminTabs.add(adminThesaurus);
        $TabInfo0.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 0));
        adminTabs.setTitleAt(0, _("vradi.admin.client"));
        $TabInfo1.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 1));
        adminTabs.setTitleAt(1, _("vradi.admin.group"));
        $TabInfo2.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 2));
        adminTabs.setTitleAt(2, _("vradi.admin.form"));
        $TabInfo3.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 3));
        adminTabs.setTitleAt(3, _("vradi.admin.xmlStream"));
        $TabInfo4.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 4));
        adminTabs.setTitleAt(4, _("vradi.admin.status"));
        $TabInfo5.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 5));
        adminTabs.setTitleAt(5, _("vradi.admin.thesaurus"));
    }

    protected void createAdminStatus() {
        $objectMap.put("adminStatus", adminStatus = new com.jurismarches.vradi.ui.admin.content.AdminStatusUI(this));
        adminStatus.setName("adminStatus");
        if (((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont() != null) {
            ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().deriveFont((float) 20));
        }
        if (((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont() != null) {
            ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().deriveFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().getStyle() | Font.BOLD));
        }
    }

    protected void createAdminTabs() {
        $objectMap.put("adminTabs", adminTabs = new javax.swing.JTabbedPane());
        adminTabs.setName("adminTabs");
        adminTabs.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__adminTabs"));
    }

    protected void createAdminThesaurus() {
        $objectMap.put("adminThesaurus", adminThesaurus = new com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI(this, new ThesaurusTreeHelper(AdminPopupUI.this,                 "edit", ListSelectionModel.SINGLE_SELECTION)));
        adminThesaurus.setName("adminThesaurus");
    }

    protected void createClientAdminNavUI() {
        $objectMap.put("clientAdminNavUI", clientAdminNavUI = new com.jurismarches.vradi.ui.admin.nav.AdminClientNavUI(this, new ClientNavigationTreeHelper(this)));
        clientAdminNavUI.setName("clientAdminNavUI");
        ((com.jurismarches.vradi.ui.admin.nav.AdminClientNavUI) clientAdminNavUI.getObjectById("clientAdminNavUI")).setContinuousLayout(true);
        ((com.jurismarches.vradi.ui.admin.nav.AdminClientNavUI) clientAdminNavUI.getObjectById("clientAdminNavUI")).setOneTouchExpandable(true);
        ((com.jurismarches.vradi.ui.admin.nav.AdminClientNavUI) clientAdminNavUI.getObjectById("clientAdminNavUI")).setDividerSize(12);
    }

    protected void createFormAdminNavUI() {
        $objectMap.put("formAdminNavUI", formAdminNavUI = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new FormNavigationTreeHelper(this)));
        formAdminNavUI.setName("formAdminNavUI");
    }

    protected void createGroupAdminNavUI() {
        $objectMap.put("groupAdminNavUI", groupAdminNavUI = new com.jurismarches.vradi.ui.admin.nav.AdminGroupNavUI(this, new GroupNavigationTreeHelper(this)));
        groupAdminNavUI.setName("groupAdminNavUI");
        ((com.jurismarches.vradi.ui.admin.nav.AdminGroupNavUI) groupAdminNavUI.getObjectById("groupAdminNavUI")).setContinuousLayout(true);
        ((com.jurismarches.vradi.ui.admin.nav.AdminGroupNavUI) groupAdminNavUI.getObjectById("groupAdminNavUI")).setOneTouchExpandable(true);
        ((com.jurismarches.vradi.ui.admin.nav.AdminGroupNavUI) groupAdminNavUI.getObjectById("groupAdminNavUI")).setDividerSize(12);
    }

    protected void createXmlStreamAdminNavUI() {
        $objectMap.put("xmlStreamAdminNavUI", xmlStreamAdminNavUI = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new XmlStreamNavigationTreeHelper(this)));
        xmlStreamAdminNavUI.setName("xmlStreamAdminNavUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminPopupUI();
        addChildrenToAdminTabs();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setHorizontalTextPosition(JLabel.LEFT);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("adminPopupUI", this);
        createAdminTabs();
        createClientAdminNavUI();
        createGroupAdminNavUI();
        createFormAdminNavUI();
        createXmlStreamAdminNavUI();
        createAdminStatus();
        createAdminThesaurus();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.action.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new jaxx.runtime.swing.TabInfo());
        $TabInfo0.setTitle(_("vradi.admin.client"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new jaxx.runtime.swing.TabInfo());
        $TabInfo1.setTitle(_("vradi.admin.group"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new jaxx.runtime.swing.TabInfo());
        $TabInfo2.setTitle(_("vradi.admin.form"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new jaxx.runtime.swing.TabInfo());
        $TabInfo3.setTitle(_("vradi.admin.xmlStream"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new jaxx.runtime.swing.TabInfo());
        $TabInfo4.setTitle(_("vradi.admin.status"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new jaxx.runtime.swing.TabInfo());
        $TabInfo5.setTitle(_("vradi.admin.thesaurus"));
        // inline creation of adminPopupUI
        setName("adminPopupUI");
        SwingUtil.setComponentHeight(adminPopupUI,600);
        adminPopupUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.admin.title"));
        SwingUtil.setComponentWidth(adminPopupUI,1024);
        adminPopupUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__adminPopupUI"));
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADMIN_TABS_MODEL, true ,"selectionModel") {
        
            @Override
            public void processDataBinding() {
                adminTabs.setModel(selectionModel);
            }
        });
    }

}