package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.OfferListTableModel;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.MaskFormatter;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class OfferListUI extends javax.swing.JSplitPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADVANCED_SEARCH_COLLAPSED = "advancedSearchCollapsed";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_OFFER_LIST_TABLE_MODEL = "offerListTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.OfferListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean advancedSearchCollapsed;
    protected javax.swing.JTabbedPane editTabs;
    protected javax.swing.JButton exportButton;
    protected com.jurismarches.vradi.ui.OfferTable listTable;
    protected OfferListUI offerList = this;
    protected com.jurismarches.vradi.ui.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.models.OfferListTableModel offerListTableModel;
    protected javax.swing.JPanel paginationPanel;
    protected com.jurismarches.vradi.ui.search.PaginationUI paginationUI;
    protected javax.swing.JPanel searchPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public OfferListHandler getHandler() {
        return getContextValue(OfferListHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return getContextValue(SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        final JTableHeader header = listTable.getTableHeader();
        header.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == MouseEvent.BUTTON1) {
                    // Get column selected
                    TableColumnModel columnModel = ((JTableHeader)e.getSource()).getColumnModel();
                    int columnIndex = columnModel.getColumnIndexAtX(e.getX());
                    TableColumn column = columnModel.getColumn(columnIndex);
    
                    final String fqName = offerListTableModel.getColumnFqName(columnIndex);
                    offerListTableModel.setAscending(!offerListTableModel.isAscending());
                    offerListTableModel.setFieldToSort(fqName);
                } 
            }
        });
    
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "offerListTableModel", offerListTableModel) {
           @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    getSearchHandler().executeQuery(offerList);
                }
            }
        };
      
        registerDataBinding(djb);
        djb.applyDataBinding();
    
        validate();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferListUI() {
        $initialize();
    }

    public OfferListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__exportButton(java.awt.event.ActionEvent event) {
        getSearchHandler().exportToCSV(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getAdvancedSearchCollapsed() {
        return advancedSearchCollapsed;
    }

    public javax.swing.JTabbedPane getEditTabs() {
        return editTabs;
    }

    public javax.swing.JButton getExportButton() {
        return exportButton;
    }

    public com.jurismarches.vradi.ui.OfferTable getListTable() {
        return listTable;
    }

    public com.jurismarches.vradi.ui.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.models.OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public javax.swing.JPanel getPaginationPanel() {
        return paginationPanel;
    }

    public com.jurismarches.vradi.ui.search.PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public javax.swing.JPanel getSearchPanel() {
        return searchPanel;
    }

    public java.lang.Boolean isAdvancedSearchCollapsed() {
        return advancedSearchCollapsed !=null && advancedSearchCollapsed;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAdvancedSearchCollapsed(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.advancedSearchCollapsed;
        this.advancedSearchCollapsed = newValue;
        firePropertyChange(PROPERTY_ADVANCED_SEARCH_COLLAPSED, oldValue, newValue);
    }

    public void setOfferListColumnFactory(com.jurismarches.vradi.ui.OfferListColumnFactory newValue) {
        com.jurismarches.vradi.ui.OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, newValue);
    }

    public void setOfferListTableModel(com.jurismarches.vradi.ui.models.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.models.OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToOfferList() {
        if (!allComponentsCreated) {
            return;
        }
        add($JPanel0, JSplitPane.LEFT);
        add(editTabs, JSplitPane.RIGHT);
    }

    protected void addChildrenToPaginationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        paginationPanel.add(paginationUI, BorderLayout.NORTH);
        paginationPanel.add(exportButton, BorderLayout.SOUTH);
    }

    protected void createAdvancedSearchCollapsed() {
        $objectMap.put("advancedSearchCollapsed", advancedSearchCollapsed = false);
    }

    protected void createEditTabs() {
        $objectMap.put("editTabs", editTabs = new javax.swing.JTabbedPane());
        editTabs.setName("editTabs");
    }

    protected void createExportButton() {
        $objectMap.put("exportButton", exportButton = new javax.swing.JButton());
        exportButton.setName("exportButton");
        exportButton.setText(_("vradi.export.cvs"));
        exportButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__exportButton"));
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new com.jurismarches.vradi.ui.OfferTable());
        listTable.setName("listTable");
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createPaginationPanel() {
        $objectMap.put("paginationPanel", paginationPanel = new javax.swing.JPanel());
        paginationPanel.setName("paginationPanel");
        paginationPanel.setLayout(new BorderLayout());
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new com.jurismarches.vradi.ui.search.PaginationUI(this));
        paginationUI.setName("paginationUI");
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new javax.swing.JPanel());
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToOfferList();
        // inline complete setup of $JPanel0
        $JPanel0.add(searchPanel, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationPanel, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(listTable);
        addChildrenToPaginationPanel();
        
        // apply 16 property setters
        setDividerLocation(Integer.MAX_VALUE);
        setDividerSize(0);
        setOrientation(JSplitPane.VERTICAL_SPLIT);
        setResizeWeight(1);
        offerListTableModel.setNbFormsPerPage(10);
        offerListTableModel.setPageToShow(1);
        listTable.setAutoResizeMode(2);
        listTable.setColumnControlVisible(true);
        listTable.setColumnFactory(offerListColumnFactory);
        listTable.setGridColor(Color.GRAY);
        listTable.setHorizontalScrollEnabled(true);
        listTable.setModel(offerListTableModel);
        listTable.setShowGrid(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("offerList", this);
        createOfferListColumnFactory();
        createOfferListTableModel();
        createAdvancedSearchCollapsed();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createSearchPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createListTable();
        createPaginationPanel();
        createPaginationUI();
        createExportButton();
        createEditTabs();
        // inline creation of offerList
        setName("offerList");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        
        $completeSetup();
    }

}