/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.i18n.I18n;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Infogene;
import com.jurismarches.vradi.entities.InfogeneImpl;

/**
 * <code>OfferListColumnFactory</code> restore the visibility state of
 * <code>Infogene</code> colums.
 *
 * OfferListColumnFactory is used by OfferListColumnFactory and
 * OfferListUI.jaxx.
 * 
 * @author $Author: schorlet $
 * @version $Revision: 632 $ $Date: 2010-03-17 15:59:55 +0100 (mer., 17 mars 2010) $
 * @since 0.0.4
 */
public class OfferListColumnFactory extends ColumnFactory {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(OfferListColumnFactory.class);
    private static final String I18N_COLUMN_PREFIX = "vradi.offer.";
    
    private final List<TableColumnExt> columnExts = new ArrayList<TableColumnExt>();
    
    public OfferListColumnFactory() {
        initAvailableColumns();
    }
    
    @Override
    public TableColumnExt createTableColumn(int modelIndex) {
        TableColumnExt columnExt = new TableColumnExt(columnExts.get(modelIndex));
        return columnExt;
    }
    
    @Override
    public void packColumn(JXTable table, TableColumnExt columnExt, int margin,
            int max) {
        int preferredWidth = columnExt.getPreferredWidth();
        if (preferredWidth < 400) {
            super.packColumn(table, columnExt, margin, 400);
        } else {
            // consider the column has been manually resized
        }
    }
    
    protected void initAvailableColumns() {
        List<String> vradiListColumns = VradiHelper.getVradiListColumns();
        boolean empty = vradiListColumns.isEmpty();

        List<String> fieldNames = new ArrayList<String>();
        for(String fieldName : InfogeneImpl.extensionInfogene.getFieldNames()) {
            fieldNames.add(Infogene.EXT_INFOGENE + "." + fieldName);
        }
        fieldNames.add(Form.FQ_FIELD_XMLSTREAMURL);

        for (String fieldName : fieldNames) {
            boolean visible = vradiListColumns.contains(fieldName);
            visible = visible || empty;

            TableColumnExt columnExt = initAvailableColumn(fieldName,
                    columnExts.size(), visible);
            columnExts.add(columnExt);
            
            if (empty) {
                // default hidden columns: id and description
                if (fieldName.equals(Infogene.FQ_FIELD_ID) ||
                        fieldName.equals(Infogene.FQ_FIELD_DESCRIPTION)) {
                    columnExt.setVisible(false);
                    
                } else {
                    // add fqField to vradi.columns property
                    VradiHelper.addVradiListColumns(fieldName);
                }
            }
        }
    }
    
    private TableColumnExt initAvailableColumn(String fqField,
            int modelIndex, boolean visible) {
        TableColumnExt tableColumnExt = new TableColumnExt(modelIndex);
        
        tableColumnExt.setIdentifier(fqField);
        tableColumnExt.putClientProperty("fqFieldName", fqField);
        
        tableColumnExt.setEditable(false);
        tableColumnExt.setSortable(true);
        tableColumnExt.setVisible(visible);
        
        tableColumnExt.setToolTipText(I18n._(I18N_COLUMN_PREFIX + fqField)); // + ".tip"
        
        if (log.isTraceEnabled()) {
            log.trace(String.format("adding column: %s; position: %s; visible: %s",
                    fqField, modelIndex, visible));
        }
        
        return tableColumnExt;
    }
}
