package com.jurismarches.vradi;

import java.util.Iterator;
import java.util.ServiceLoader;

import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.caucho.hessian.client.HessianProxyFactory;
import com.jurismarches.vradi.services.MailingService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.XmlStreamService;

/**
 * VradiService.
 *
 * @author $Author: schorlet $
 * @version $Revision: 691 $ $Date: 2010-04-09 16:40:57 +0200 (ven., 09 avril 2010) $
 * @since 18 févr. 2010 17:33:03
 */
public class VradiService {
    private static final Log log = LogFactory.getLog(VradiService.class);
    
    private static final String storageUrl = "/storage";
    private static final String xmlStreamUrl = "/xmlstream";
    private static final String mailingUrl = "/mailing";
    
    private static VradiStorageService vradiStorageService = null;
    private static XmlStreamService xmlStreamService = null;
    private static MailingService mailingService = null;
    private static VradiService instance = null;
    
    private final String serviceContext;

    public String getServiceContext() {
        return serviceContext;
    }

    private VradiService() {
        String serviceEmbeded = System.getProperty("vradi.service.embeded", null);
        
        if (serviceEmbeded != null && serviceEmbeded.equals("true")) {
            try {
                log.info("Starting embeded server on http://localhost:9000");
                VradiEmbededHessian server = new VradiEmbededHessian(9000);
                server.start();
                serviceContext = "http://localhost:9000";
                log.info("Embeded server started");
            } catch (Exception e) {
                throw new UnhandledException(e);
            }
        } else {
            serviceContext = System.getProperty("vradi.service.context", null);
        }
    }
    
    public static synchronized VradiService getInstance() {
        if (instance == null) {
            instance = new VradiService();
        }
        return instance;
    }
    
    public static synchronized VradiStorageService getVradiStorageService() {
        if (vradiStorageService == null) {
            VradiService serviceInstance = getInstance();
            vradiStorageService = serviceInstance.getService(VradiStorageService.class, storageUrl);
        }
        return vradiStorageService;
    }

    public static synchronized XmlStreamService getXmlStreamService() {
        if (xmlStreamService == null) {
            VradiService serviceInstance = getInstance();
            xmlStreamService = serviceInstance.getService(XmlStreamService.class, xmlStreamUrl);
        }
        return xmlStreamService;
    }

    public static synchronized MailingService getMailingService() {
        if (mailingService == null) {
            VradiService serviceInstance = getInstance();
            mailingService = serviceInstance.getService(MailingService.class, mailingUrl);
        }
        return mailingService;
    }
    
    public <S> S getService(Class<S> serviceClass, String serviceUrl) {
        try {
            log.debug("Creating a service instance of: " + serviceClass.getName());
            
            if (serviceContext == null) {
                ServiceLoader<S> serviceLoader = ServiceLoader.load(serviceClass);
                Iterator<S> iterator = serviceLoader.iterator();
                
                if (iterator.hasNext()) {
                    return iterator.next();
                    
                } else {
                    // let the exception raise later
                    log.fatal("Unable to create an instance of:" + serviceClass.getName());
                    return null;
                }
                
            } else {
                HessianProxyFactory factory = new HessianProxyFactory();
                return (S) factory.create(serviceClass, serviceContext + serviceUrl);
            }
            
        } catch (Exception e) {
            throw new UnhandledException(e);
        }
    }
    
}
