/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.aspectwerkz.hook.ClassLoaderPatcher;

public class JDWPPlug {
    private static final String TRANSPORT_JDWP = "transport";
    private static final String ADDRESS_JDWP = "address";
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$hook$impl$ClassLoaderPreProcessorImpl;

    private VirtualMachine connect(Map jdwp) throws Exception {
        String transport = (String)jdwp.get(TRANSPORT_JDWP);
        String address = (String)jdwp.get(ADDRESS_JDWP);
        String name = null;
        if ("dt_socket".equals(transport)) {
            name = "com.sun.jdi.SocketAttach";
        } else if ("dt_shmem".equals(transport)) {
            name = "com.sun.jdi.SharedMemoryAttach";
        }
        Connector connector = null;
        Iterator<AttachingConnector> i = Bootstrap.virtualMachineManager().attachingConnectors().iterator();
        while (i.hasNext()) {
            AttachingConnector aConnector = i.next();
            if (!aConnector.name().equals(name)) continue;
            connector = aConnector;
            break;
        }
        if (connector == null) {
            throw new Exception("no AttachingConnector for transport: " + transport);
        }
        Map<String, Connector.Argument> args = connector.defaultArguments();
        if ("dt_socket".equals(transport)) {
            args.get("port").setValue(address);
        } else if ("dt_shmem".equals(transport)) {
            args.get("name").setValue(address);
        }
        try {
            VirtualMachine vm = connector.attach(args);
            return vm;
        }
        catch (IllegalConnectorArgumentsException e) {
            System.err.println("failed to attach to VM (" + transport + ", " + address + "):");
            e.printStackTrace();
            Iterator<String> i2 = e.argumentNames().iterator();
            while (i2.hasNext()) {
                System.err.println("wrong or missing argument - " + i2.next());
            }
            return null;
        }
        catch (IOException e) {
            System.err.println("failed to attach to VM (" + transport + ", " + address + "):");
            e.printStackTrace();
            return null;
        }
    }

    public void resume(Map jdwp) throws Exception {
        VirtualMachine vm = this.connect(jdwp);
        if (vm != null) {
            vm.resume();
            vm.dispose();
        }
    }

    public void info(Map jdwp) throws Exception {
        VirtualMachine vm = this.connect(jdwp);
        if (vm != null) {
            System.out.println("java.vm.name = " + vm.name());
            System.out.println("java.version = " + vm.version());
            System.out.println(vm.description());
            vm.resume();
            vm.dispose();
        }
    }

    public void hotswap(Map jdwp) throws Exception {
        VirtualMachine vm = ClassLoaderPatcher.hotswapClassLoader(System.getProperty("aspectwerkz.classloader.clpreprocessor", (class$org$codehaus$aspectwerkz$hook$impl$ClassLoaderPreProcessorImpl == null ? (class$org$codehaus$aspectwerkz$hook$impl$ClassLoaderPreProcessorImpl = JDWPPlug.class$("org.codehaus.aspectwerkz.hook.impl.ClassLoaderPreProcessorImpl")) : class$org$codehaus$aspectwerkz$hook$impl$ClassLoaderPreProcessorImpl).getName()), (String)jdwp.get(TRANSPORT_JDWP), (String)jdwp.get(ADDRESS_JDWP));
        if (vm != null) {
            vm.resume();
            vm.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

