/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.Stomp;
import org.apache.activemq.transport.stomp.StompFrame;

public interface FrameTranslator {
    public ActiveMQMessage convertFrame(ProtocolConverter var1, StompFrame var2) throws JMSException, ProtocolException;

    public StompFrame convertMessage(ProtocolConverter var1, ActiveMQMessage var2) throws IOException, JMSException;

    public String convertDestination(ProtocolConverter var1, Destination var2);

    public ActiveMQDestination convertDestination(ProtocolConverter var1, String var2) throws ProtocolException;

    public static final class Helper {
        private Helper() {
        }

        public static void copyStandardHeadersFromMessageToFrame(ProtocolConverter converter, ActiveMQMessage message, StompFrame command, FrameTranslator ft) throws IOException {
            Map<String, Object> properties;
            Map<String, String> headers = command.getHeaders();
            headers.put("destination", ft.convertDestination(converter, message.getDestination()));
            headers.put("message-id", message.getJMSMessageID());
            if (message.getJMSCorrelationID() != null) {
                headers.put("correlation-id", message.getJMSCorrelationID());
            }
            headers.put("expires", "" + message.getJMSExpiration());
            if (message.getJMSRedelivered()) {
                headers.put("redelivered", "true");
            }
            headers.put("priority", "" + message.getJMSPriority());
            if (message.getJMSReplyTo() != null) {
                headers.put("reply-to", ft.convertDestination(converter, message.getJMSReplyTo()));
            }
            headers.put("timestamp", "" + message.getJMSTimestamp());
            if (message.getJMSType() != null) {
                headers.put("type", message.getJMSType());
            }
            if (message.getUserID() != null) {
                headers.put("JMSXUserID", message.getUserID());
            }
            if ((properties = message.getProperties()) != null) {
                for (Map.Entry<String, Object> prop : properties.entrySet()) {
                    headers.put(prop.getKey(), "" + prop.getValue());
                }
            }
        }

        public static void copyStandardHeadersFromFrameToMessage(ProtocolConverter converter, StompFrame command, ActiveMQMessage msg, FrameTranslator ft) throws ProtocolException, JMSException {
            HashMap<String, String> headers = new HashMap<String, String>(command.getHeaders());
            String destination = (String)headers.remove("destination");
            msg.setDestination(ft.convertDestination(converter, destination));
            msg.setJMSCorrelationID((String)headers.remove("correlation-id"));
            Object o = headers.remove("expires");
            if (o != null) {
                msg.setJMSExpiration(Long.parseLong((String)o));
            }
            if ((o = headers.remove("priority")) != null) {
                msg.setJMSPriority(Integer.parseInt((String)o));
            }
            if ((o = headers.remove("type")) != null) {
                msg.setJMSType((String)o);
            }
            if ((o = headers.remove("reply-to")) != null) {
                msg.setJMSReplyTo(ft.convertDestination(converter, (String)o));
            }
            if ((o = headers.remove(Stomp.Headers.Send.PERSISTENT)) != null) {
                msg.setPersistent("true".equals(o));
            }
            msg.setProperties(headers);
        }
    }
}

