/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.protobuf;

import java.util.List;
import org.apache.activemq.protobuf.BufferInputStream;
import org.apache.activemq.protobuf.BufferOutputStream;
import org.apache.activemq.protobuf.UTF8Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Buffer
implements Comparable<Buffer> {
    public final byte[] data;
    public final int offset;
    public final int length;

    public Buffer(Buffer other) {
        this(other.data, other.offset, other.length);
    }

    public Buffer(byte[] data) {
        this(data, 0, data.length);
    }

    public Buffer(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    @Deprecated
    public Buffer(String value) {
        this(UTF8Buffer.encode(value));
    }

    public final Buffer slice(int low, int high) {
        int sz = high < 0 ? this.length + high : high - low;
        if (sz < 0) {
            sz = 0;
        }
        return new Buffer(this.data, this.offset + low, sz);
    }

    public final byte[] getData() {
        return this.data;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getOffset() {
        return this.offset;
    }

    public Buffer compact() {
        if (this.length != this.data.length) {
            return new Buffer(this.toByteArray());
        }
        return this;
    }

    public final byte[] toByteArray() {
        if (this.length != this.data.length) {
            byte[] t = new byte[this.length];
            System.arraycopy(this.data, this.offset, t, 0, this.length);
        }
        return this.data;
    }

    public byte byteAt(int i) {
        return this.data[this.offset + i];
    }

    public int hashCode() {
        byte[] target = new byte[4];
        for (int i = 0; i < this.length; ++i) {
            int n = i % 4;
            target[n] = (byte)(target[n] ^ this.data[this.offset + i]);
        }
        return target[0] << 24 | target[1] << 16 | target[2] << 8 | target[3];
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != Buffer.class) {
            return false;
        }
        return this.equals((Buffer)obj);
    }

    public final boolean equals(Buffer obj) {
        if (this.length != obj.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (obj.data[obj.offset + i] == this.data[this.offset + i]) continue;
            return false;
        }
        return true;
    }

    public final BufferInputStream newInput() {
        return new BufferInputStream(this);
    }

    public final BufferOutputStream newOutput() {
        return new BufferOutputStream(this);
    }

    public final boolean isEmpty() {
        return this.length == 0;
    }

    public final boolean contains(byte value) {
        return this.indexOf(value, 0) >= 0;
    }

    public final int indexOf(byte value, int pos) {
        for (int i = pos; i < this.length; ++i) {
            if (this.data[this.offset + i] != value) continue;
            return i;
        }
        return -1;
    }

    public static final Buffer join(List<Buffer> items, Buffer seperator) {
        if (items.isEmpty()) {
            return new Buffer(seperator.data, 0, 0);
        }
        int size = 0;
        for (Buffer item : items) {
            size += item.length;
        }
        int pos = 0;
        byte[] data = new byte[size += seperator.length * (items.size() - 1)];
        for (Buffer item : items) {
            if (pos != 0) {
                System.arraycopy(seperator.data, seperator.offset, data, pos, seperator.length);
                pos += seperator.length;
            }
            System.arraycopy(item.data, item.offset, data, pos, item.length);
            pos += item.length;
        }
        return new Buffer(data, 0, size);
    }

    @Deprecated
    public String toStringUtf8() {
        return UTF8Buffer.decode(this);
    }

    @Override
    public int compareTo(Buffer o) {
        int minLength = Math.min(this.length, o.length);
        if (this.offset == o.offset) {
            int limit = minLength + this.offset;
            for (int pos = this.offset; pos < limit; ++pos) {
                byte b1 = this.data[pos];
                byte b2 = o.data[pos];
                if (b1 == b2) continue;
                return b1 - b2;
            }
        } else {
            int offset1 = this.offset;
            int offset2 = o.offset;
            while (minLength-- != 0) {
                byte b2;
                byte b1;
                if ((b1 = this.data[offset1++]) == (b2 = o.data[offset2++])) continue;
                return b1 - b2;
            }
        }
        return this.length - o.length;
    }
}

