/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.data;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.data.DataFile;
import org.apache.activemq.kaha.impl.data.DataItem;
import org.apache.activemq.kaha.impl.data.RedoListener;
import org.apache.activemq.kaha.impl.data.SyncDataFileReader;
import org.apache.activemq.kaha.impl.data.SyncDataFileWriter;
import org.apache.activemq.kaha.impl.index.RedoStoreIndexItem;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IOHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DataManagerImpl
implements DataManager {
    public static final int ITEM_HEAD_SIZE = 5;
    public static final byte DATA_ITEM_TYPE = 1;
    public static final byte REDO_ITEM_TYPE = 2;
    public static final long MAX_FILE_LENGTH = 0x2000000L;
    private static final Log LOG = LogFactory.getLog(DataManagerImpl.class);
    private static final String NAME_PREFIX = "data-";
    private final File directory;
    private final String name;
    private SyncDataFileReader reader;
    private SyncDataFileWriter writer;
    private DataFile currentWriteFile;
    private long maxFileLength = 0x2000000L;
    private Map<Integer, DataFile> fileMap = new HashMap<Integer, DataFile>();
    private Marshaller redoMarshaller = RedoStoreIndexItem.MARSHALLER;
    private String dataFilePrefix;
    private final AtomicLong storeSize;

    public DataManagerImpl(File dir, String name, AtomicLong storeSize) {
        this.directory = dir;
        this.name = name;
        this.storeSize = storeSize;
        this.dataFilePrefix = IOHelper.toFileSystemSafeName(NAME_PREFIX + name + "-");
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String n) {
                return dir.equals(DataManagerImpl.this.directory) && n.startsWith(DataManagerImpl.this.dataFilePrefix);
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String n = file.getName();
                String numStr = n.substring(this.dataFilePrefix.length(), n.length());
                int num = Integer.parseInt(numStr);
                DataFile dataFile = new DataFile(file, num);
                storeSize.addAndGet(dataFile.getLength());
                this.fileMap.put(dataFile.getNumber(), dataFile);
                if (this.currentWriteFile != null && this.currentWriteFile.getNumber() >= num) continue;
                this.currentWriteFile = dataFile;
            }
        }
    }

    private DataFile createAndAddDataFile(int num) {
        String fileName = this.dataFilePrefix + num;
        File file = new File(this.directory, fileName);
        DataFile result = new DataFile(file, num);
        this.fileMap.put(result.getNumber(), result);
        return result;
    }

    public String getName() {
        return this.name;
    }

    synchronized DataFile findSpaceForData(DataItem item) throws IOException {
        if (this.currentWriteFile == null || this.currentWriteFile.getLength() + (long)item.getSize() > this.maxFileLength) {
            int nextNum;
            int n = nextNum = this.currentWriteFile != null ? this.currentWriteFile.getNumber() + 1 : 1;
            if (this.currentWriteFile != null && this.currentWriteFile.isUnused()) {
                this.removeDataFile(this.currentWriteFile);
            }
            this.currentWriteFile = this.createAndAddDataFile(nextNum);
        }
        item.setOffset(this.currentWriteFile.getLength());
        item.setFile(this.currentWriteFile.getNumber());
        int len = item.getSize() + 5;
        this.currentWriteFile.incrementLength(len);
        this.storeSize.addAndGet(len);
        return this.currentWriteFile;
    }

    DataFile getDataFile(StoreLocation item) throws IOException {
        Integer key = item.getFile();
        DataFile dataFile = this.fileMap.get(key);
        if (dataFile == null) {
            LOG.error((Object)("Looking for key " + key + " but not found in fileMap: " + this.fileMap));
            throw new IOException("Could not locate data file data-" + this.name + "-" + item.getFile());
        }
        return dataFile;
    }

    public synchronized Object readItem(Marshaller marshaller, StoreLocation item) throws IOException {
        return this.getReader().readItem(marshaller, item);
    }

    public synchronized StoreLocation storeDataItem(Marshaller marshaller, Object payload) throws IOException {
        return this.getWriter().storeItem(marshaller, payload, (byte)1);
    }

    public synchronized StoreLocation storeRedoItem(Object payload) throws IOException {
        return this.getWriter().storeItem(this.redoMarshaller, payload, (byte)2);
    }

    public synchronized void updateItem(StoreLocation location, Marshaller marshaller, Object payload) throws IOException {
        this.getWriter().updateItem((DataItem)location, marshaller, payload, (byte)1);
    }

    public synchronized void recoverRedoItems(RedoListener listener) throws IOException {
        if (this.currentWriteFile == null) {
            return;
        }
        DataItem item = new DataItem();
        item.setFile(this.currentWriteFile.getNumber());
        item.setOffset(0L);
        while (true) {
            byte type;
            try {
                type = this.getReader().readDataItemSize(item);
            }
            catch (IOException ignore) {
                LOG.trace((Object)("End of data file reached at (header was invalid): " + item));
                return;
            }
            if (type == 2) {
                Object object;
                try {
                    object = this.readItem(this.redoMarshaller, item);
                }
                catch (IOException e1) {
                    LOG.trace((Object)("End of data file reached at (payload was invalid): " + item));
                    return;
                }
                try {
                    listener.onRedoItem(item, object);
                    item = item.copy();
                }
                catch (Exception e) {
                    throw IOExceptionSupport.create("Recovery handler failed: " + e, e);
                }
            }
            item.setOffset(item.getOffset() + 5L + (long)item.getSize());
        }
    }

    public synchronized void close() throws IOException {
        this.getWriter().close();
        for (DataFile dataFile : this.fileMap.values()) {
            this.getWriter().force(dataFile);
            dataFile.close();
        }
        this.fileMap.clear();
    }

    public synchronized void force() throws IOException {
        for (DataFile dataFile : this.fileMap.values()) {
            this.getWriter().force(dataFile);
        }
    }

    public synchronized boolean delete() throws IOException {
        boolean result = true;
        for (DataFile dataFile : this.fileMap.values()) {
            this.storeSize.addAndGet(-dataFile.getLength());
            result &= dataFile.delete();
        }
        this.fileMap.clear();
        return result;
    }

    public synchronized void addInterestInFile(int file) throws IOException {
        if (file >= 0) {
            Integer key = file;
            DataFile dataFile = this.fileMap.get(key);
            if (dataFile == null) {
                dataFile = this.createAndAddDataFile(file);
            }
            this.addInterestInFile(dataFile);
        }
    }

    synchronized void addInterestInFile(DataFile dataFile) {
        if (dataFile != null) {
            dataFile.increment();
        }
    }

    public synchronized void removeInterestInFile(int file) throws IOException {
        if (file >= 0) {
            Integer key = file;
            DataFile dataFile = this.fileMap.get(key);
            this.removeInterestInFile(dataFile);
        }
    }

    synchronized void removeInterestInFile(DataFile dataFile) throws IOException {
        if (dataFile != null && dataFile.decrement() <= 0 && dataFile != this.currentWriteFile) {
            this.removeDataFile(dataFile);
        }
    }

    public synchronized void consolidateDataFiles() throws IOException {
        ArrayList<DataFile> purgeList = new ArrayList<DataFile>();
        for (DataFile dataFile : this.fileMap.values()) {
            if (!dataFile.isUnused() || dataFile == this.currentWriteFile) continue;
            purgeList.add(dataFile);
        }
        for (int i = 0; i < purgeList.size(); ++i) {
            DataFile dataFile;
            dataFile = (DataFile)purgeList.get(i);
            this.removeDataFile(dataFile);
        }
    }

    private void removeDataFile(DataFile dataFile) throws IOException {
        this.fileMap.remove(dataFile.getNumber());
        if (this.writer != null) {
            this.writer.force(dataFile);
        }
        this.storeSize.addAndGet(-dataFile.getLength());
        boolean result = dataFile.delete();
        LOG.debug((Object)("discarding data file " + dataFile + (result ? "successful " : "failed")));
    }

    public Marshaller getRedoMarshaller() {
        return this.redoMarshaller;
    }

    public void setRedoMarshaller(Marshaller redoMarshaller) {
        this.redoMarshaller = redoMarshaller;
    }

    public long getMaxFileLength() {
        return this.maxFileLength;
    }

    public void setMaxFileLength(long maxFileLength) {
        this.maxFileLength = maxFileLength;
    }

    public String toString() {
        return "DataManager:(data-" + this.name + ")";
    }

    public synchronized SyncDataFileReader getReader() {
        if (this.reader == null) {
            this.reader = this.createReader();
        }
        return this.reader;
    }

    protected synchronized SyncDataFileReader createReader() {
        return new SyncDataFileReader(this);
    }

    public synchronized void setReader(SyncDataFileReader reader) {
        this.reader = reader;
    }

    public synchronized SyncDataFileWriter getWriter() {
        if (this.writer == null) {
            this.writer = this.createWriter();
        }
        return this.writer;
    }

    private SyncDataFileWriter createWriter() {
        return new SyncDataFileWriter(this);
    }

    public synchronized void setWriter(SyncDataFileWriter writer) {
        this.writer = writer;
    }
}

