/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class ResourceManager {
    static Map nameToRM = new HashMap();
    private ResourceBundle bundle;

    public static ResourceManager get(Class clazz) {
        String bundleName = clazz.getName() + "RB";
        return ResourceManager.get(bundleName);
    }

    public static ResourceManager get(String bundleName) {
        ResourceManager rm = (ResourceManager)nameToRM.get(bundleName);
        if (rm == null) {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
            rm = new ResourceManager(bundle);
            nameToRM.put(bundleName, rm);
        }
        return rm;
    }

    public static ResourceManager all(Class clazz) {
        return ResourceManager.get(ResourceManager.getPackage(clazz) + ".AllRB");
    }

    public static ResourceManager common() {
        return ResourceManager.all(ResourceManager.class);
    }

    public static String resolve(String rbAndProperty) {
        return ResourceManager.common().resolve0(rbAndProperty);
    }

    public static String resolve(String rbAndProperty, Object[] args) {
        String value = ResourceManager.common().resolve0(rbAndProperty);
        return MessageFormat.format(value, args);
    }

    private ResourceManager(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public String getString(String key) {
        return this.resolve0(String.valueOf(this.bundle.getObject(key)));
    }

    public String getString(String key, Object[] args) {
        String value = this.getString(key);
        return MessageFormat.format(value, args);
    }

    public char getChar(String key) {
        String s = this.getString(key);
        if (s == null || s.trim().length() == 0) {
            return '\u0000';
        }
        return s.charAt(0);
    }

    private String resolve0(String property) {
        int index;
        String result = property;
        if (property != null && (index = property.indexOf("${")) != -1) {
            int endIndex = property.indexOf("}", index);
            String sub = property.substring(index + 2, endIndex);
            int colon = sub.indexOf(":");
            if (colon != -1) {
                String rbName = sub.substring(0, colon);
                String keyName = sub.substring(colon + 1);
                sub = ResourceManager.get(rbName).getString(keyName);
            } else {
                sub = this.getString(sub);
            }
            result = property.substring(0, index) + sub + this.resolve0(property.substring(endIndex + 1));
        }
        return result;
    }

    private static String getPackage(Class clazz) {
        String pck = clazz.getName();
        int index = pck.lastIndexOf(46);
        pck = index != -1 ? pck.substring(0, index) : "";
        return pck;
    }
}

