/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.common;

import com.arjuna.ats.arjuna.logging.tsLogger;

public class Mutex {
    public static final int LOCKED = 0;
    public static final int UNLOCKED = 1;
    public static final int WOULD_BLOCK = 2;
    public static final int ERROR = 3;
    private Object _lock = new Object();
    private int _users = 0;
    private Thread _owner = null;
    private boolean _reentrant;
    private int _recursiveCalls;

    public Mutex() {
        this(false);
    }

    public Mutex(boolean reentrant) {
        this._reentrant = reentrant;
        this._recursiveCalls = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lock() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 128L, "Mutex::lock()");
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._users == 0) {
                this._users = 1;
                if (this._reentrant) {
                    this._owner = Thread.currentThread();
                    this._recursiveCalls = 1;
                }
            } else {
                boolean done = false;
                if (this._reentrant && this._owner == Thread.currentThread()) {
                    ++this._recursiveCalls;
                    done = true;
                }
                if (!done) {
                    ++this._users;
                    try {
                        this._lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unlock() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 128L, "Mutex::unlock()");
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._users <= 0) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.common.Mutex_2");
                }
                return 0;
            }
            boolean done = false;
            if (this._reentrant) {
                if (this._owner == Thread.currentThread()) {
                    if (--this._recursiveCalls == 0) {
                        this._owner = null;
                    }
                    done = true;
                } else {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.common.Mutex_2");
                    }
                    return 0;
                }
            }
            if (!done && --this._users >= 0) {
                this._lock.notify();
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tryLock() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 128L, "Mutex::tryLock()");
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._users == 0) {
                return this.lock();
            }
            if (this._reentrant && this._owner == Thread.currentThread()) {
                return this.lock();
            }
            return 2;
        }
    }
}

