/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.pdmodel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSString;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdfparser.PDFStreamParser;
import org.pdfbox.pdfwriter.ContentStreamWriter;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.util.PDFOperator;

public class ReplaceString {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String inputFile, String outputFile, String strToFind, String message) throws IOException, COSVisitorException {
        PDDocument doc = null;
        try {
            doc = PDDocument.load(inputFile);
            List pages = doc.getDocumentCatalog().getAllPages();
            for (int i = 0; i < pages.size(); ++i) {
                PDPage page = (PDPage)pages.get(i);
                PDStream contents = page.getContents();
                PDFStreamParser parser = new PDFStreamParser(contents.getStream());
                parser.parse();
                List tokens = parser.getTokens();
                for (int j = 0; j < tokens.size(); ++j) {
                    COSBase previous;
                    Object next = tokens.get(j);
                    if (!(next instanceof PDFOperator)) continue;
                    PDFOperator op = (PDFOperator)next;
                    if (op.getOperation().equals("Tj")) {
                        previous = (COSString)tokens.get(j - 1);
                        String string = ((COSString)previous).getString();
                        string = string.replaceFirst(strToFind, message);
                        ((COSString)previous).reset();
                        ((COSString)previous).append(string.getBytes());
                        continue;
                    }
                    if (!op.getOperation().equals("TJ")) continue;
                    previous = (COSArray)tokens.get(j - 1);
                    for (int k = 0; k < ((COSArray)previous).size(); ++k) {
                        COSBase arrElement = ((COSArray)previous).getObject(k);
                        if (!(arrElement instanceof COSString)) continue;
                        COSString cosString = (COSString)arrElement;
                        String string = cosString.getString();
                        string = string.replaceFirst(strToFind, message);
                        cosString.reset();
                        cosString.append(string.getBytes());
                    }
                }
                PDStream updatedStream = new PDStream(doc);
                OutputStream out = updatedStream.createOutputStream();
                ContentStreamWriter tokenWriter = new ContentStreamWriter(out);
                tokenWriter.writeTokens(tokens);
                page.setContents(updatedStream);
            }
            doc.save(outputFile);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) {
        ReplaceString app = new ReplaceString();
        try {
            if (args.length != 4) {
                app.usage();
            } else {
                app.doIt(args[0], args[1], args[2], args[3]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-file> <output-file> <search-string> <Message>");
    }
}

