/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation.handler;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.navigation.NavigationContentUI;
import jaxx.runtime.swing.navigation.NavigationContextHelper;
import jaxx.runtime.swing.navigation.NavigationMultiContentUI;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.handler.NavigationHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractNavigationHandler<E extends NavigationNode<E>>
extends DefaultTreeSelectionModel
implements NavigationHandler<E> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractNavigationHandler.class);
    protected JAXXContext context;
    protected NavigationHandler.Strategy strategy;
    protected NavigationContextHelper<E> contextHelper;

    protected AbstractNavigationHandler(String contextPrefix, JAXXObject context, NavigationHandler.Strategy strategy) {
        this.contextHelper = new NavigationContextHelper(contextPrefix);
        this.context = context;
        this.strategy = strategy;
        this.addTreeSelectionListener(this);
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Value changed for path : " + event.getPath()));
            log.debug((Object)("Old lead selection path : " + event.getOldLeadSelectionPath()));
        }
        if (event.getOldLeadSelectionPath() != null && event.getOldLeadSelectionPath().equals(event.getPath())) {
            return;
        }
        NavigationNode node = (NavigationNode)event.getPath().getLastPathComponent();
        this.selectNodeUI(node);
    }

    @Override
    public JAXXContext getContext() {
        return this.context;
    }

    @Override
    public NavigationContextHelper<E> getContextHelper() {
        return this.contextHelper;
    }

    @Override
    public void setSelectionPath(TreePath path) {
        if (path.equals(this.getSelectionPath())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("skip stay on path " + path));
            }
            return;
        }
        Component component = this.getCurrentUI();
        try {
            if (!this.closeUI(component)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"changing node canceled!");
                }
                return;
            }
            if (component instanceof NavigationContentUI) {
                ((NavigationContentUI)((Object)component)).closeUI((NavigationNode)path.getLastPathComponent());
            }
        }
        catch (Exception ex) {
            this.treateError(ex);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will select path " + path));
        }
        super.setSelectionPath(path);
    }

    @Override
    public void setSelectionPaths(TreePath[] paths) {
        if (Arrays.equals(paths, this.getSelectionPaths())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("skip stay on path " + Arrays.toString(paths)));
            }
            return;
        }
        Component component = this.getCurrentUI();
        try {
            if (!this.closeUI(component)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"changing node canceled!");
                }
                return;
            }
            if (component instanceof NavigationMultiContentUI && paths.length == 1) {
                NavigationContextHelper<E> helper = this.getContextHelper();
                ((NavigationMultiContentUI)((Object)component)).closeUI(helper.getSelectedNodes(this.getContext()));
            }
        }
        catch (Exception ex) {
            this.treateError(ex);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will select " + paths.length + " paths"));
        }
        super.setSelectionPaths(paths);
    }

    protected void selectNodeUI(E node) {
        try {
            String path = node.getFullPath();
            if (log.isTraceEnabled()) {
                log.trace((Object)path);
            }
            Component newUI = this.getUI(node);
            Object data = this.getNavigationTreeModel().getBean(path);
            this.addSelectedBeanInContext(node, data);
            if (newUI == null) {
                newUI = this.createUI(node);
            }
            JAXXContext ctxt = this.getContext();
            NavigationContextHelper<E> helper = this.getContextHelper();
            helper.setSelectedPath(ctxt, node.getFullPath());
            helper.setSelectedNode(ctxt, node);
            if (newUI instanceof NavigationContentUI) {
                ((NavigationContentUI)((Object)newUI)).openUI(node);
            }
            this.openUI(newUI, node);
        }
        catch (Exception e) {
            this.treateError(e);
        }
    }

    protected JAXXContext createUIContext(E node) throws Exception {
        if (node.getUIHandlerClass() == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("no action associated with ui " + node.getUIClass()));
            }
            return this.getContext();
        }
        JAXXAction action = node.getUIHandlerClass().newInstance();
        JAXXInitialContext uiContext = action.init(this.getContext(), new Object[0]);
        return uiContext;
    }

    protected void addSelectedBeanInContext(E node, Object data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("find data for contextPath <" + node.getFullPath() + "> : " + (data == null ? null : data.getClass())));
        }
        JAXXContext ctxt = this.getContext();
        NavigationContextHelper<E> helper = this.getContextHelper();
        helper.setSelectedBean(ctxt, null);
        if (data != null) {
            helper.setSelectedBean(ctxt, data);
        }
    }
}

