/*
 * Decompiled with CFR 0.152.
 */
package com.karneim.util.collection.regex;

import com.karneim.util.collection.regex.Automaton_Pattern;
import com.karneim.util.collection.regex.ParseException;
import java.text.ParsePosition;
import java.util.Vector;

class PScanner {
    public static final int UNLIMITED_MAX_LENGTH = Integer.MAX_VALUE;
    private final Automaton_Pattern.TerminalFormat[] terminalFormats;
    private final int[] terminalsMaxLength;
    private final boolean terminalFormatsAreExclusive;

    public PScanner(Automaton_Pattern.TerminalFormat[] terminalFormatArray) {
        this(terminalFormatArray, false);
    }

    public PScanner(Automaton_Pattern.TerminalFormat[] terminalFormatArray, boolean bl) {
        int n;
        this.terminalFormats = terminalFormatArray;
        this.terminalFormatsAreExclusive = bl;
        int n2 = this.terminalFormats.length;
        if (!this.terminalFormatsAreExclusive) {
            for (n = n2 - 1 >> 1; n >= 0; --n) {
                Automaton_Pattern.TerminalFormat terminalFormat = this.terminalFormats[n];
                this.terminalFormats[n] = this.terminalFormats[n2 - n];
                this.terminalFormats[n2 - n] = terminalFormat;
            }
        }
        this.terminalsMaxLength = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.terminalsMaxLength[n] = this.terminalFormats[n].maxLength();
        }
    }

    public Vector scan(String string) {
        return this.scan(string, 0);
    }

    public Vector scan(String string, int n) {
        int n2;
        int n3;
        if (string == null) {
            String string2 = "null source specified";
            throw new IllegalArgumentException(string2);
        }
        char[] cArray = string.toCharArray();
        int n4 = -1;
        int n5 = -1;
        for (n3 = this.terminalFormats.length - 1; n3 >= 0; --n3) {
            if (this.terminalFormats[n3] == null) continue;
            n5 = n3;
            break;
        }
        if (n5 == -1) {
            String string3 = "no terminal formats added";
            throw new NullPointerException(string3);
        }
        for (n3 = 0; n3 <= n5; ++n3) {
            if (this.terminalFormats[n3] == null) continue;
            n4 = n3;
            break;
        }
        Vector<Object> vector = new Vector<Object>();
        int n6 = cArray.length;
        ParsePosition parsePosition = new ParsePosition(n);
        for (int i = n; i < n6; i += n2) {
            n2 = -1;
            Object object = null;
            for (int j = n5; j >= n4; --j) {
                if (this.terminalsMaxLength[j] < n2) continue;
                parsePosition.setIndex(i);
                Object object2 = this.terminalFormats[j].parseObject(cArray, parsePosition);
                int n7 = parsePosition.getIndex() - i;
                if (object2 == null) continue;
                if (this.terminalFormatsAreExclusive) {
                    n2 = n7;
                    object = object2;
                    break;
                }
                if (n7 < n2) continue;
                n2 = n7;
                object = object2;
            }
            if (object == null) {
                String string4 = String.valueOf(String.valueOf(new StringBuffer("can not scan input:\n").append(new String(cArray, n, cArray.length - n)).append("\nerrorPosition: ").append(i).append("\n").append(new String(cArray, i, cArray.length - i))));
                throw new ParseException(string4);
            }
            vector.addElement(object);
        }
        return vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Scanner(");
        if (this.terminalFormatsAreExclusive) {
            stringBuffer.append("exclusive");
        }
        stringBuffer.append(")");
        for (int i = 0; i < this.terminalFormats.length; ++i) {
            if (this.terminalFormats[i] == null) continue;
            stringBuffer.append('\n').append(this.terminalFormats[i]);
        }
        return stringBuffer.toString();
    }

    static {
        UNLIMITED_MAX_LENGTH = Integer.MAX_VALUE;
    }
}

