/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.config.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.config.model.OptionModel;

public class CategoryModel
implements Iterable<OptionModel> {
    public static final String RELOAD_PROPERTY_NAME = "reload";
    public static final String MODIFIED_PROPERTY_NAME = "modified";
    public static final String VALID_PROPERTY_NAME = "valid";
    protected String category;
    protected String categoryLabel;
    protected List<OptionModel> entries;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    protected CategoryModel(String category, String categoryLabel) {
        this.category = category;
        this.categoryLabel = categoryLabel;
        this.entries = new ArrayList<OptionModel>();
    }

    protected void addOption(OptionModel option) {
        this.entries.add(option);
    }

    @Deprecated
    public CategoryModel(String category, String categoryLabel, OptionModel[] entries) {
        this.category = category;
        this.categoryLabel = categoryLabel;
        this.entries = Collections.unmodifiableList(Arrays.asList(entries));
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLabel() {
        return this.categoryLabel;
    }

    public List<OptionModel> getEntries() {
        return this.entries;
    }

    public boolean isModified() {
        boolean modified = false;
        for (OptionModel m : this) {
            if (!m.isModified()) continue;
            modified = true;
            break;
        }
        return modified;
    }

    public boolean isValid() {
        boolean valid = true;
        for (OptionModel m : this) {
            if (m.isValid()) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public void setValue(OptionModel key, Object val) {
        boolean wasModified = this.isModified();
        boolean wasValid = this.isValid();
        key.setValue(val);
        boolean modified = this.isModified();
        boolean valid = this.isValid();
        if (wasModified != modified) {
            this.firePropertyChange(MODIFIED_PROPERTY_NAME, wasModified, modified);
        }
        if (wasValid != valid) {
            this.firePropertyChange(VALID_PROPERTY_NAME, wasValid, valid);
        }
    }

    @Override
    public Iterator<OptionModel> iterator() {
        return this.entries.iterator();
    }

    public List<OptionModel> getInvalidOptions() {
        ArrayList<OptionModel> result = new ArrayList<OptionModel>();
        for (OptionModel m : this) {
            if (m.isValid()) continue;
            result.add(m);
        }
        return result;
    }

    public List<OptionModel> getModifiedOptions() {
        ArrayList<OptionModel> result = new ArrayList<OptionModel>();
        for (OptionModel m : this) {
            if (!m.isModified()) continue;
            result.add(m);
        }
        return result;
    }

    public List<OptionModel> getSavedOptions() {
        ArrayList<OptionModel> result = new ArrayList<OptionModel>();
        for (OptionModel option : this) {
            if (!option.isSaved()) continue;
            result.add(option);
        }
        return result;
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public void destroy() {
        JAXXUtil.destroy((PropertyChangeSupport)this.pcs);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }
}

