/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.QueryMakerImpl;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.SendingImpl;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.SessionImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.Configuration;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.ServiceUtil;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.dto.DTOHelper;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiQueryBean;
import com.jurismarches.vradi.services.managers.ClientManager;
import com.jurismarches.vradi.services.managers.SearchManager;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

public class FormManager {
    private static final Log log = LogFactory.getLog(FormManager.class);
    private final WikittyProxy proxy;
    private final ThesaurusManager thesaurusManager;
    private final SearchManager searchManager;

    public FormManager(WikittyProxy proxy, ThesaurusManager thesaurusManager, SearchManager searchManager) {
        this.proxy = proxy;
        this.thesaurusManager = thesaurusManager;
        this.searchManager = searchManager;
    }

    public FormManager(ThesaurusManager thesaurusManager, SearchManager searchManager) {
        this.proxy = ServiceFactory.getWikittyProxy();
        this.thesaurusManager = thesaurusManager;
        this.searchManager = searchManager;
    }

    public List<Form> getAllForms() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllForms()");
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Form");
        Criteria criteria = search.criteria();
        PagedResult forms = this.proxy.findAllByCriteria(Form.class, criteria);
        List all = forms.getAll();
        return all;
    }

    public List<Form> getForms(List<String> formIds) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getForms(" + formIds + ")"));
        }
        List forms = this.proxy.restore(Form.class, formIds);
        return forms;
    }

    public Form getForm(String formId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getForm(" + formId + ")"));
        }
        Form form = (Form)this.proxy.restore(Form.class, formId);
        return form;
    }

    public void deleteForm(String formId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteForm(" + formId + ")"));
        }
        this.proxy.delete(formId);
    }

    public Form updateForm(Form form) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateForm(form)");
        }
        List<Form> forms = Arrays.asList(form);
        List<Form> updateForms = this.updateForms(forms);
        Form updatedForm = updateForms.get(0);
        return updatedForm;
    }

    public List<Form> updateForms(List<Form> forms) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateForms(forms)");
        }
        if (forms == null || forms.isEmpty()) {
            return forms;
        }
        ArrayList<TreeNodeImpl> thesaurusList = new ArrayList<TreeNodeImpl>();
        for (Form form : forms) {
            Set thesaurus;
            if (log.isDebugEnabled()) {
                log.debug((Object)("updating form: " + form.getId()));
            }
            if (form.getCreationDate() == null) {
                form.setCreationDate(new Date());
            } else {
                if (!form.getExtensionNames().contains("ModificationTag")) {
                    BusinessEntityWikitty businessEntityWikitty = (BusinessEntityWikitty)form;
                    Wikitty wikitty = businessEntityWikitty.getWikitty();
                    wikitty.addExtension(ModificationTag.EXTENSION_MODIFICATION_TAG);
                }
                form.setField("ModificationTag", "lastModified", (Object)new Date());
            }
            if ((thesaurus = form.getThesaurus()) == null) continue;
            for (String thesaurusId : thesaurus) {
                TreeNodeImpl node = this.thesaurusManager.getThesaurus(thesaurusId);
                if (node.getChildren() != null && node.getChildren().contains(form.getWikittyId())) continue;
                node.addChildren(form.getWikittyId());
                if (thesaurusList.contains(node)) continue;
                thesaurusList.add(node);
            }
        }
        List result = this.proxy.store(forms);
        if (!thesaurusList.isEmpty()) {
            this.proxy.store(thesaurusList);
        }
        return result;
    }

    public Session getLastOpenSession() {
        Criteria criteria = Search.query().or().eq("Session.status", String.valueOf(VradiConstants.SessionStatus.ACTIVE.getValue())).eq("Session.status", String.valueOf(VradiConstants.SessionStatus.STOPPED.getValue())).eq("Session.status", String.valueOf(VradiConstants.SessionStatus.ERROR.getValue())).criteria();
        criteria.setEndIndex(0);
        criteria.addSortDescending("Session.sessionDate");
        PagedResult sessions = this.proxy.findAllByCriteria(Session.class, criteria);
        if (sessions.size() == 0) {
            return null;
        }
        Session result = (Session)sessions.getFirst();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Last sessions found : " + result.getSessionDate() + " status : " + result.getStatus()));
        }
        return result;
    }

    public List<Session> getSessions(Date sessionDate) {
        Session lastOpenSession;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSessions for date " + sessionDate.toString()));
        }
        Search search = Search.query();
        search.bw("Session.sessionDate", ServiceUtil.getBeginOfDaySolrDate(sessionDate), ServiceUtil.getEndOfDaySolrDate(sessionDate));
        Criteria criteria = search.criteria();
        ArrayList<Session> listSessions = new ArrayList<Session>(this.proxy.findAllByCriteria(Session.class, criteria).getAll());
        if (listSessions.isEmpty() && (lastOpenSession = this.getLastOpenSession()) != null) {
            listSessions.add(lastOpenSession);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(listSessions.size() + " sessions found"));
        }
        return listSessions;
    }

    public void bindForms() throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"bindForms");
        }
        try {
            Session currentSession = this.getLastOpenSession();
            if (currentSession == null) {
                List<Session> sessionList = this.getSessions(new Date());
                int num = 0;
                if (sessionList != null && !sessionList.isEmpty()) {
                    for (Session session : sessionList) {
                        if (num >= session.getNum()) continue;
                        num = session.getNum();
                    }
                }
                ++num;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No session found, creating a new one");
                }
                currentSession = new SessionImpl();
                currentSession.setSessionDate(new Date());
                currentSession.setNum(num);
                currentSession.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
            } else {
                Set sendingsIds = currentSession.getSending();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Mark to not search in " + (sendingsIds == null ? 0 : sendingsIds.size()) + " sendings"));
                    if (sendingsIds != null) {
                        for (String sending : sendingsIds) {
                            log.debug((Object)("Deleting sending : " + sending));
                        }
                    }
                }
                if (sendingsIds != null) {
                    this.proxy.delete((Collection)sendingsIds);
                }
                currentSession.clearSending();
                currentSession = (Session)this.proxy.store((BusinessEntity)currentSession);
            }
            List<Sending> toSend = this.executeQueries(currentSession);
            if (log.isDebugEnabled()) {
                int size = currentSession.getSending() == null || currentSession.getSending().isEmpty() ? 0 : currentSession.getSending().size();
                log.debug((Object)("Saving session " + currentSession.getSessionDate() + " number " + currentSession.getNum() + " with " + size + " sending"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Cant bind form : ", (Throwable)e);
            throw new VradiException("Cant bind form : ", e);
        }
    }

    protected List<Sending> executeQueries(Session currentSession) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"executeQueries");
        }
        List<Sending> toSend = new ArrayList<Sending>();
        ArrayList<QueryMaker> queryMakers = new ArrayList<QueryMaker>(this.searchManager.findQueryMakersWithQueries());
        for (QueryMaker queryMaker : queryMakers) {
            List<Form> formsToBind = null;
            Set queries = queryMaker.getQueries();
            if (queries == null) continue;
            for (String queryEntry : queries) {
                try {
                    VradiQueryBean queryBean = new VradiQueryBean(queryEntry);
                    String query = queryBean.getQuery();
                    VradiFormPageDTO vradiFormPage = new VradiFormPageDTO();
                    Status status = this.getSelectionneStatus();
                    Date olderInscriptionDate = this.getOlderInscriptionDate(queryMaker);
                    vradiFormPage = this.searchManager.findForms(query, vradiFormPage, olderInscriptionDate, status.getWikittyId());
                    formsToBind = vradiFormPage.getFormsToShow();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Query " + query + " return " + formsToBind.size() + " forms"));
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (formsToBind == null || formsToBind.isEmpty()) continue;
            toSend.addAll(this.createAllSending(currentSession, queryMaker, (List<? extends Form>)formsToBind, true));
        }
        toSend = this.addEmptyClientSending(currentSession, toSend);
        return toSend;
    }

    protected List<Sending> addEmptyClientSending(Session currentSession, List<Sending> toSend) {
        log.info((Object)("addEmptyClientSending " + toSend.size()));
        ArrayList<Sending> result = new ArrayList<Sending>(toSend);
        for (Sending s : toSend) {
            String userId = s.getUser();
            if (userId == null) continue;
            User user = (User)this.proxy.restore(User.class, userId);
            log.info((Object)("Search sending for client of " + user.getName()));
            Client client = (Client)this.proxy.restore(Client.class, user.getClient());
            Sending clientSending = this.findExistingOrCreateSending(currentSession, (QueryMaker)client);
            Set forms = clientSending.getForm();
            log.info((Object)("Client sending " + client.getName() + " has " + (forms == null ? 0 : forms.size()) + " forms"));
            clientSending.setClient(client.getWikittyId());
            currentSession.addSending(clientSending.getWikittyId());
            result.add((Sending)this.proxy.store((BusinessEntity)clientSending));
        }
        currentSession = (Session)this.proxy.store((BusinessEntity)currentSession);
        return result;
    }

    protected Date getOlderInscriptionDate(QueryMaker queryMaker) {
        Date result = new Date();
        if (queryMaker instanceof User) {
            User user = (User)queryMaker;
            Date inscriptionDate = user.getInscriptionDate();
            if (inscriptionDate != null && result.before(inscriptionDate)) {
                result = inscriptionDate;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("The older inscription date for user " + user.getName() + " is " + result));
            }
        }
        if (queryMaker instanceof Client) {
            Client client = (Client)queryMaker;
            List<User> users = DTOHelper.getClientUser(client.getWikittyId());
            for (User user : users) {
                Date inscriptionDate = this.getOlderInscriptionDate((QueryMaker)user);
                if (inscriptionDate == null || !result.before(inscriptionDate)) continue;
                result = inscriptionDate;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("The older inscription date for client " + client.getName() + " is " + result));
            }
        }
        if (queryMaker instanceof Group) {
            Set clientIds;
            Group group = (Group)queryMaker;
            Set userIds = group.getUser();
            if (userIds != null) {
                for (String userId : userIds) {
                    User user = (User)this.proxy.restore(User.class, userId);
                    Date inscriptionDate = this.getOlderInscriptionDate((QueryMaker)user);
                    if (inscriptionDate == null || !result.before(inscriptionDate)) continue;
                    result = inscriptionDate;
                }
            }
            if ((clientIds = group.getClient()) != null) {
                for (String clientId : clientIds) {
                    Client client = (Client)this.proxy.restore(Client.class, clientId);
                    Date inscriptionDate = this.getOlderInscriptionDate((QueryMaker)client);
                    if (inscriptionDate == null || !result.before(inscriptionDate)) continue;
                    result = inscriptionDate;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("The older inscription date for group " + group.getName() + " is " + result));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("The older inscription date " + result));
        }
        return result;
    }

    public List<Sending> createAllSending(Session currentSession, QueryMaker queryMaker, List<? extends Form> formsToBind, boolean removeAlreadyBind) {
        Set formsAttached;
        List<Object> result = new ArrayList<Sending>();
        queryMaker = ClientManager.castAsRealQueryMaker((QueryMakerImpl)queryMaker);
        Sending sending = this.findExistingOrCreateSending(currentSession, queryMaker);
        if (queryMaker instanceof Client) {
            sending.setClient(queryMaker.getWikittyId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add client " + queryMaker.getWikittyId()));
            }
            List<User> users = DTOHelper.getClientUser(queryMaker.getWikittyId());
            for (User user : users) {
                result.addAll(this.createAllSending(currentSession, (QueryMaker)user, formsToBind, removeAlreadyBind));
            }
        } else if (queryMaker instanceof User) {
            sending.setUser(queryMaker.getWikittyId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add user " + queryMaker.getWikittyId()));
            }
        } else if (queryMaker instanceof Group) {
            Set set;
            Set clientIds;
            sending.setGroup(queryMaker.getWikittyId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add group " + queryMaker.getWikittyId()));
            }
            if ((clientIds = ((Group)queryMaker).getClient()) != null) {
                for (String string : clientIds) {
                    Client client = (Client)this.proxy.restore(Client.class, string);
                    if (client == null) continue;
                    result.addAll(this.createAllSending(currentSession, (QueryMaker)client, formsToBind, removeAlreadyBind));
                }
            }
            if ((set = ((Group)queryMaker).getUser()) != null) {
                for (String userId : set) {
                    User user = (User)this.proxy.restore(User.class, userId);
                    if (user == null) continue;
                    result.addAll(this.createAllSending(currentSession, (QueryMaker)user, formsToBind, removeAlreadyBind));
                }
            }
        }
        if (formsToBind != null) {
            if (removeAlreadyBind) {
                formsToBind = this.removeAlreadyBound(formsToBind, queryMaker);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding " + formsToBind.size() + " forms to sending"));
                }
                if (queryMaker instanceof User) {
                    User user = (User)queryMaker;
                    for (Form form : new ArrayList<Form>(formsToBind)) {
                        Date formCreationDate = (Date)form.getField("ModificationTag", "lastModified");
                        Date userInscriptionDate = user.getInscriptionDate();
                        if (userInscriptionDate == null || !formCreationDate.before(userInscriptionDate)) continue;
                        formsToBind.remove(form);
                    }
                }
            }
            for (Form form : formsToBind) {
                String string = form.getWikittyId();
                sending.removeForm(string);
                sending.addForm(string);
            }
        }
        if ((formsAttached = sending.getForm()) != null && !formsAttached.isEmpty()) {
            result.add(sending);
        }
        if (!result.isEmpty()) {
            for (Sending sending2 : result) {
                currentSession.addSending(sending2.getWikittyId());
            }
            result = this.proxy.store(result);
            currentSession = (Session)this.proxy.store((BusinessEntity)currentSession);
        }
        return result;
    }

    public List<Sending> removeAllSending(Session session, Form form, QueryMaker queryMaker) {
        Set sendingList = session.getSending();
        ArrayList sendingArray = Collections.EMPTY_LIST;
        if (sendingList != null) {
            sendingArray = new ArrayList(sendingList);
        }
        List sendings = this.proxy.restore(Sending.class, sendingArray);
        queryMaker = ClientManager.castAsRealQueryMaker((QueryMakerImpl)queryMaker);
        ArrayList<String> impacted = new ArrayList<String>();
        impacted.add(queryMaker.getWikittyId());
        if (queryMaker instanceof Client) {
            List<User> users = DTOHelper.getClientUser(queryMaker.getWikittyId());
            for (User user : users) {
                impacted.add(user.getWikittyId());
            }
        } else if (queryMaker instanceof Group) {
            Set userIds;
            Set ids = ((Group)queryMaker).getClient();
            if (ids != null) {
                for (String clientId : ids) {
                    Client client = (Client)this.proxy.restore(Client.class, clientId);
                    impacted.add(clientId);
                    List<User> users = DTOHelper.getClientUser(queryMaker.getWikittyId());
                    for (User user : users) {
                        impacted.add(user.getWikittyId());
                    }
                }
            }
            if ((userIds = ((Group)queryMaker).getUser()) != null) {
                for (String userId : userIds) {
                    impacted.add(userId);
                }
            }
        }
        ArrayList<Sending> sendingImpacted = new ArrayList<Sending>();
        for (Sending sending : sendings) {
            if (sending.getForm().contains(form.getWikittyId()) && (impacted.contains(sending.getClient()) || impacted.contains(sending.getUser()) || impacted.contains(sending.getGroup()))) {
                sending.removeForm(form.getWikittyId());
                sending.addDeletedForms(form.getWikittyId());
                sendingImpacted.add(sending);
            }
            if (!sending.getForm().isEmpty()) continue;
            sending.setStatus(VradiConstants.SendingStatus.DELETED.getValue());
        }
        this.proxy.store(sendingImpacted);
        return this.proxy.restore(Sending.class, sendingArray);
    }

    public Sending findExistingOrCreateSending(Session currentSession, QueryMaker queryMaker) {
        Set sendingsId = currentSession.getSending();
        List sendings = new ArrayList();
        if (sendingsId != null) {
            sendings = this.proxy.restore(Sending.class, new ArrayList(sendingsId));
        }
        for (Sending sending : sendings) {
            String qmId = queryMaker.getWikittyId();
            if (!qmId.equals(sending.getUser()) && !qmId.equals(sending.getClient()) && (!qmId.equals(sending.getGroup()) || sending.getStatus() == VradiConstants.SendingStatus.DELETED.getValue())) continue;
            return sending;
        }
        SendingImpl newSending = new SendingImpl();
        newSending.setSentDate(null);
        newSending.setReceptionDate(null);
        newSending.setParagraph("");
        newSending.setReceptionProof(false);
        newSending.setStatus(VradiConstants.SendingStatus.TO_SEND.getValue());
        return newSending;
    }

    protected List<? extends Form> removeAlreadyBound(List<? extends Form> forms, QueryMaker queryMaker) {
        ArrayList<String> formIds = new ArrayList<String>();
        for (Form form : forms) {
            formIds.add(form.getWikittyId());
        }
        String qmId = queryMaker.getWikittyId();
        Search search = Search.query().and();
        search.or().contains("Sending.form", formIds).contains("Sending.deletedForms", formIds);
        search.or().eq("Sending.client", qmId).eq("Sending.user", qmId).eq("Sending.group", qmId);
        search.not().eq("Sending.status", String.valueOf(VradiConstants.SendingStatus.DELETED.getValue()));
        PagedResult pagedResult = this.proxy.findAllByCriteria(Sending.class, search.criteria());
        if (log.isDebugEnabled()) {
            List sendings = pagedResult.getAll();
            log.debug((Object)("Remove " + sendings.size() + " already bounds forms"));
        }
        for (Sending send : pagedResult.getAll()) {
            formIds.removeAll(send.getForm());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rest " + formIds.size() + " forms"));
        }
        List result = this.proxy.restore(Form.class, formIds);
        return result;
    }

    public Status getStatus(String statusId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStatus(" + statusId + ")"));
        }
        Status status = (Status)this.proxy.restore(Status.class, statusId);
        return status;
    }

    public List<Status> getStatuses(List<String> statusIds) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getStatuses(statusIds)");
        }
        List statuses = this.proxy.restore(Status.class, statusIds);
        return new ArrayList<Status>(statuses);
    }

    public List<Status> getAllStatuses() throws VradiException {
        Search search;
        Criteria criteria;
        PagedResult statuses;
        ArrayList<Status> all;
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllStatus()");
        }
        if ((all = (statuses = this.proxy.findAllByCriteria(Status.class, criteria = (search = Search.query().eq(Element.ELT_EXTENSION, "Status")).criteria())).getAll()) == null || all.isEmpty()) {
            log.warn((Object)"no status found, creating ...");
            all = new ArrayList<Status>();
            all.add(this.getNonTraiteStatus());
            all.add(this.getNonSelectionneStatus());
            all.add(this.getPreselectionneStatus());
            all.add(this.getSelectionneStatus());
        }
        return new ArrayList<Status>(all);
    }

    public Status getNonTraiteStatus() {
        VradiConstants.FormStatus nonTraite = VradiConstants.FormStatus.NON_TRAITE;
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Status");
        search.eq("Status.name", nonTraite.getName());
        Criteria criteria = search.criteria();
        Status toTreatStatus = (Status)this.proxy.findByCriteria(Status.class, criteria);
        if (toTreatStatus == null) {
            toTreatStatus = new StatusImpl();
            toTreatStatus.setName(nonTraite.getName());
            toTreatStatus.setValue(nonTraite.getValue());
            toTreatStatus.setDescription(nonTraite.getDescription());
            toTreatStatus.setModifiable(false);
            toTreatStatus = (Status)this.proxy.store((BusinessEntity)toTreatStatus);
        }
        return toTreatStatus;
    }

    public Status getNonSelectionneStatus() {
        VradiConstants.FormStatus nonSelectionne = VradiConstants.FormStatus.NON_SELECTIONNE;
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Status");
        search.eq("Status.name", nonSelectionne.getName());
        Criteria criteria = search.criteria();
        Status toTreatStatus = (Status)this.proxy.findByCriteria(Status.class, criteria);
        if (toTreatStatus == null) {
            toTreatStatus = new StatusImpl();
            toTreatStatus.setName(nonSelectionne.getName());
            toTreatStatus.setValue(nonSelectionne.getValue());
            toTreatStatus.setDescription(nonSelectionne.getDescription());
            toTreatStatus.setModifiable(false);
            toTreatStatus = (Status)this.proxy.store((BusinessEntity)toTreatStatus);
        }
        return toTreatStatus;
    }

    public Status getPreselectionneStatus() {
        VradiConstants.FormStatus preselectionne = VradiConstants.FormStatus.PRESELECTIONNE;
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Status");
        search.eq("Status.name", preselectionne.getName());
        Criteria criteria = search.criteria();
        Status validatedStatus = (Status)this.proxy.findByCriteria(Status.class, criteria);
        if (validatedStatus == null) {
            validatedStatus = new StatusImpl();
            validatedStatus.setName(preselectionne.getName());
            validatedStatus.setValue(preselectionne.getValue());
            validatedStatus.setDescription(preselectionne.getDescription());
            validatedStatus.setModifiable(false);
            validatedStatus = (Status)this.proxy.store((BusinessEntity)validatedStatus);
        }
        return validatedStatus;
    }

    public Status getSelectionneStatus() {
        VradiConstants.FormStatus selectionne = VradiConstants.FormStatus.SELECTIONNE;
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Status");
        search.eq("Status.name", selectionne.getName());
        Criteria criteria = search.criteria();
        Status validatedStatus = (Status)this.proxy.findByCriteria(Status.class, criteria);
        if (validatedStatus == null) {
            validatedStatus = new StatusImpl();
            validatedStatus.setName(selectionne.getName());
            validatedStatus.setValue(selectionne.getValue());
            validatedStatus.setDescription(selectionne.getDescription());
            validatedStatus.setModifiable(false);
            validatedStatus = (Status)this.proxy.store((BusinessEntity)validatedStatus);
        }
        return validatedStatus;
    }

    public List<Status> updateStatuses(List<Status> statuses) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateStatuses(statuses)");
        }
        try {
            List result = this.proxy.store(statuses);
            return result;
        }
        catch (Exception e) {
            log.error((Object)"Cant update statuses : ", (Throwable)e);
            throw new VradiException("Cant update statuses : ", e);
        }
    }

    public Status updateStatus(Status status) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateStatus(status)");
        }
        try {
            status = (Status)this.proxy.store((BusinessEntity)status);
            return status;
        }
        catch (Exception e) {
            log.error((Object)"Cant update status : ", (Throwable)e);
            throw new VradiException("Cant update status : ", e);
        }
    }

    public void deleteStatuses(List<String> statusIds) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteStatus(" + statusIds + ")"));
        }
        try {
            this.proxy.delete(statusIds);
        }
        catch (Exception e) {
            log.error((Object)"Cant delete status : ", (Throwable)e);
            throw new VradiException("Cant delete status : ", e);
        }
    }

    @Deprecated
    public void uploadFiles(Form form, List<File> files) throws IOException {
        File embededFilesDir = Configuration.getInstance().getEmbededFilesDir();
        File copyDir = new File(embededFilesDir, form.getWikittyId());
        for (File file : files) {
            File copyFile = new File(copyDir, file.getName());
            FileUtil.copy((File)file, (File)copyFile);
        }
    }

    @Deprecated
    public void uploadAttachments(Form form, List<File> attachments) throws IOException {
        File attachmentsDir = Configuration.getInstance().getAttachmentsDir();
        File copyDir = new File(attachmentsDir, form.getWikittyId());
        for (File attachment : attachments) {
            File copyFile = new File(copyDir, attachment.getName());
            FileUtil.copy((File)attachment, (File)copyFile);
        }
    }
}

