/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.UserBean;
import com.jurismarches.vradi.services.dto.SendingContainer;
import com.jurismarches.vradi.services.dto.VradiDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import java.util.Date;
import java.util.HashSet;

public class VradiUserDTO
extends UserBean
implements VradiDTO<User>,
SendingContainer {
    private static final long serialVersionUID = 1L;
    protected VradiSendingDTO currentSending = null;
    protected String clientName = null;

    public VradiUserDTO() {
        this.QueryMaker$queries = new HashSet();
    }

    @Override
    public void fromWikitty(User wikitty) {
        if (wikitty == null) {
            this.reset();
        } else {
            this.setWikittyId(wikitty.getWikittyId());
            this.setCreationDate(wikitty.getCreationDate());
            this.setAddress(wikitty.getAddress());
            this.setEmail(wikitty.getEmail());
            this.setName(wikitty.getName());
            this.setPhone(wikitty.getPhone());
            this.setService(wikitty.getService());
            this.setValidEmail(wikitty.getValidEmail());
            this.setInscriptionDate(wikitty.getInscriptionDate());
            if (wikitty.getExtensionNames().contains("ModificationTag")) {
                Object lastModified = wikitty.getField("ModificationTag", "lastModified");
                this.setLastModified(lastModified != null ? (Date)lastModified : null);
                Object lastModifier = wikitty.getField("ModificationTag", "lastModifier");
                this.setLastModifier(lastModifier != null ? (String)lastModifier : null);
            } else {
                this.setLastModified(null);
                this.setLastModifier(null);
            }
            this.QueryMaker$queries.clear();
            this.addAllQueries(wikitty.getQueries());
        }
    }

    @Override
    public void reset() {
        this.setWikittyId(null);
        this.setCreationDate(null);
        this.setAddress(null);
        this.setEmail(null);
        this.setName(null);
        this.setPhone(null);
        this.setService(null);
        this.setValidEmail(false);
        this.setLastModified(null);
        this.setLastModifier(null);
        this.setInscriptionDate(null);
        this.clearQueries();
    }

    @Override
    public void toWikitty(User wikitty) {
        wikitty.setCreationDate(this.getCreationDate());
        wikitty.setAddress(this.getAddress());
        wikitty.setEmail(this.getEmail());
        wikitty.setName(this.getName());
        wikitty.setPhone(this.getPhone());
        wikitty.setService(this.getService());
        wikitty.setValidEmail(this.getValidEmail());
        wikitty.setInscriptionDate(this.getInscriptionDate());
        wikitty.setField("ModificationTag", "lastModified", (Object)this.getLastModified());
        wikitty.setField("ModificationTag", "lastModifier", (Object)this.getLastModifier());
        wikitty.clearQueries();
        for (String id : this.getQueries()) {
            wikitty.addQueries(id);
        }
    }

    @Override
    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        this.propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public Date getLastModified() {
        return (Date)this.getField("ModificationTag", "lastModified");
    }

    public void setLastModified(Date lastModified) {
        Date oldValue = this.getLastModified();
        this.setField("ModificationTag", "lastModified", lastModified);
        this.propertyChange.firePropertyChange("lastModified", oldValue, lastModified);
    }

    public String getLastModifier() {
        return (String)this.getField("ModificationTag", "lastModifier");
    }

    public void setLastModifier(String lastModifier) {
        String oldValue = this.getLastModifier();
        this.setField("ModificationTag", "lastModifier", lastModifier);
        this.propertyChange.firePropertyChange("lastModifier", oldValue, lastModifier);
    }

    public void addAllQueries(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                this.QueryMaker$queries.add(s);
            }
        }
        this.propertyChange.firePropertyChange("queries", null, this.QueryMaker$queries);
    }

    @Override
    public VradiSendingDTO getCurrentSending() {
        return this.currentSending;
    }

    @Override
    public void setCurrentSending(VradiSendingDTO currentSending) {
        this.currentSending = currentSending;
    }

    @Override
    public int getNbFormToSend() {
        VradiSendingDTO sending = this.getCurrentSending();
        return sending == null ? 0 : sending.getFormDTOs().size();
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public Date getInscriptionDate() {
        Date inscriptionDate = super.getInscriptionDate();
        if (inscriptionDate == null) {
            this.setInscriptionDate(new Date());
        }
        return super.getInscriptionDate();
    }

    public String toString() {
        return this.getName();
    }
}

