/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.entities.ClientImpl;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.GroupImpl;
import com.jurismarches.vradi.entities.InfogeneImpl;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.QueryMakerImpl;
import com.jurismarches.vradi.entities.SendingImpl;
import com.jurismarches.vradi.entities.SessionImpl;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.UserImpl;
import com.jurismarches.vradi.entities.VradiAdminImpl;
import com.jurismarches.vradi.entities.XmlFieldBindingImpl;
import com.jurismarches.vradi.entities.XmlStreamImpl;
import com.jurismarches.vradi.migration.Migration005;
import com.jurismarches.vradi.migration.MigrationWikittyService;
import com.jurismarches.vradi.services.Configuration;
import com.jurismarches.vradi.services.MailingService;
import com.jurismarches.vradi.services.MailingServiceImpl;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.VradiStorageServiceImpl;
import com.jurismarches.vradi.services.XmlStreamService;
import com.jurismarches.vradi.services.XmlStreamServiceImpl;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyService;
import org.sharengo.wikitty.WikittyStorage;
import org.sharengo.wikitty.jdbc.WikittyExtensionStorageJDBC;
import org.sharengo.wikitty.jdbc.WikittyStorageJDBC;
import org.sharengo.wikitty.jms.WikittyExtensionStorageJMS;
import org.sharengo.wikitty.jms.WikittyExtensionSubscriberJMS;
import org.sharengo.wikitty.jms.WikittyStorageJMS;
import org.sharengo.wikitty.jms.WikittyStorageSubscriberJMS;
import org.sharengo.wikitty.multistorage.MultiStorageConfiguration;

public class ServiceFactory {
    static final Log log = LogFactory.getLog(ServiceFactory.class);
    private static VradiStorageService vradiStorageService = null;
    private static XmlStreamService xmlStreamService = null;
    private static MailingService mailingService = null;
    private static WikittyProxy wikittyProxy = null;

    public static synchronized VradiStorageService getVradiStorageService() {
        if (vradiStorageService == null) {
            vradiStorageService = new VradiStorageServiceImpl();
        }
        return vradiStorageService;
    }

    public static synchronized XmlStreamService getXmlStreamService() {
        if (xmlStreamService == null) {
            xmlStreamService = new XmlStreamServiceImpl();
        }
        return xmlStreamService;
    }

    public static synchronized MailingService getMailingService() {
        if (mailingService == null) {
            mailingService = new MailingServiceImpl();
        }
        return mailingService;
    }

    public static synchronized WikittyProxy getWikittyProxy() {
        if (wikittyProxy == null) {
            boolean performMigration = !Configuration.getInstance().skipMigration();
            Migration005 migration = new Migration005();
            if (performMigration) {
                migration.prepareMigration();
            }
            MultiStorageConfiguration.BasicConfiguration configuration = new MultiStorageConfiguration.BasicConfiguration();
            ServiceFactory.configureJDBC((MultiStorageConfiguration)configuration);
            ServiceFactory.configurePublisherJMS((MultiStorageConfiguration)configuration);
            ServiceFactory.configureSubscriberJMS((MultiStorageConfiguration)configuration);
            MigrationWikittyService multiStorage = new MigrationWikittyService((MultiStorageConfiguration)configuration);
            wikittyProxy = new WikittyProxy();
            wikittyProxy.setWikittyService((WikittyService)multiStorage);
            ServiceFactory.updateExtensions(wikittyProxy);
            if (performMigration) {
                migration.performMigration(wikittyProxy);
            }
        }
        return wikittyProxy;
    }

    static void updateExtensions(WikittyProxy wikittyProxy) {
        List<WikittyExtension> extensions = Arrays.asList(ClientImpl.extensionClient, FormImpl.extensionForm, GroupImpl.extensionGroup, InfogeneImpl.extensionInfogene, QueryMakerImpl.extensionQueryMaker, SendingImpl.extensionSending, SessionImpl.extensionSession, StatusImpl.extensionStatus, UserImpl.extensionUser, VradiAdminImpl.extensionVradiAdmin, XmlFieldBindingImpl.extensionXmlFieldBinding, XmlStreamImpl.extensionXmlStream, ModificationTag.EXTENSION_MODIFICATION_TAG, Thesaurus.EXTENSION_THESAURUS);
        WikittyService wikittyService = wikittyProxy.getWikittyService();
        wikittyService.storeExtension(extensions);
    }

    static void configureSubscriberJMS(MultiStorageConfiguration configuration) {
        Properties subscriberProperties = Configuration.getInstance().getJmsSubscriberProperties();
        String connectorURL = subscriberProperties.getProperty("connectorURL");
        if (connectorURL != null) {
            Properties brokerProperties = Configuration.getInstance().getJmsPublisherProperties();
            String brokerConnectorURL = brokerProperties.getProperty("connectorURL");
            if (connectorURL.equals(brokerConnectorURL)) {
                return;
            }
            Properties properties = new Properties();
            properties.put("java.naming.provider.url", connectorURL);
            try {
                WikittyStorage wikittyStorage = configuration.getCurrentMasterWikittyStorage();
                WikittyStorageSubscriberJMS storageSubscriberJMS = new WikittyStorageSubscriberJMS(wikittyStorage, properties);
                WikittyExtensionStorage extensionStorage = configuration.getCurrentMasterExtensionStorage();
                WikittyExtensionSubscriberJMS extensionSubscriberJMS = new WikittyExtensionSubscriberJMS(extensionStorage, properties);
                storageSubscriberJMS.start();
                extensionSubscriberJMS.start();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new WikittyException(e);
            }
        }
    }

    static void configurePublisherJMS(MultiStorageConfiguration configuration) {
        Properties brokerProperties = Configuration.getInstance().getJmsPublisherProperties();
        if (brokerProperties.isEmpty()) {
            return;
        }
        try {
            String connectorURL = brokerProperties.getProperty("connectorURL");
            if (connectorURL == null) {
                return;
            }
            URL jmsConfigURL = Configuration.getInstance().getJmsPublisherURL();
            BrokerFactory.createBroker((String)("wikitty:" + jmsConfigURL.toExternalForm()), (boolean)true);
            Properties properties = new Properties();
            properties.put("java.naming.provider.url", connectorURL);
            WikittyExtensionStorageJMS extensionStorage = new WikittyExtensionStorageJMS(properties);
            WikittyStorageJMS wikittyStorage = new WikittyStorageJMS(properties);
            configuration.addExtensionStorage((WikittyExtensionStorage)extensionStorage, false);
            configuration.addWikittyStorage((WikittyStorage)wikittyStorage, false);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WikittyException(e);
        }
    }

    static void configureJDBC(MultiStorageConfiguration configuration) {
        Properties properties = Configuration.getInstance().getJdbcConfigProperties();
        WikittyExtensionStorageJDBC extensionStorage = new WikittyExtensionStorageJDBC(properties);
        WikittyStorageJDBC wikittyStorage = new WikittyStorageJDBC((WikittyExtensionStorage)extensionStorage, properties);
        configuration.addExtensionStorage((WikittyExtensionStorage)extensionStorage, true);
        configuration.addWikittyStorage((WikittyStorage)wikittyStorage, true);
    }

    public static Configuration getServiceConfiguration() {
        return Configuration.getInstance();
    }

    public static void main(String[] args) {
        ServiceFactory.getWikittyProxy();
    }

    static {
        Configuration config = Configuration.getInstance();
        config.printConfig();
    }
}

