/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18nLanguage;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;
import org.nuiton.i18n.init.I18nInitializer;

public class I18nStore {
    private static final Log log = LogFactory.getLog(I18nStore.class);
    protected I18nLanguage language;
    protected List<I18nLanguage> languages;
    protected I18nBundle[] bundles;
    protected Locale defaultLocale;
    protected I18nInitializer resolver;

    public I18nStore(Locale defaultLocale, I18nInitializer resolver) {
        this.defaultLocale = defaultLocale;
        this.resolver = resolver;
    }

    public I18nLanguage getLanguage() {
        return this.language;
    }

    public List<I18nLanguage> getLanguages() {
        if (this.languages == null) {
            this.languages = new ArrayList<I18nLanguage>();
        }
        return this.languages;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public boolean isEmpty() {
        boolean isEmpty = I18nBundleUtil.isEmpty(this.getBundles());
        return isEmpty;
    }

    public Locale[] getLocales() {
        Locale[] result = I18nBundleUtil.getLocales(this.getBundles());
        return result;
    }

    public I18nBundle[] getBundles() {
        this.checkInit();
        return this.bundles;
    }

    public I18nBundle[] getBundles(Locale l) {
        I18nBundle[] result = I18nBundleUtil.getBundles(l, this.getBundles());
        return result;
    }

    public I18nBundleEntry[] getBundleEntries() {
        I18nBundleEntry[] result = I18nBundleUtil.getBundleEntries(this.getBundles());
        return result;
    }

    public I18nBundleEntry[] getBundleEntries(Locale l) {
        I18nBundleEntry[] result = I18nBundleUtil.getBundleEntries(l, this.getDefaultLocale(), this.getBundles());
        return result;
    }

    protected void init() {
        if (this.isInit()) {
            return;
        }
        if (this.resolver == null) {
            throw new NullPointerException("resolver can not be null in org.nuiton.i18n.I18nStore.init method");
        }
        try {
            this.bundles = this.resolver.resolvBundles();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not init store for reason " + e.getMessage(), e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(this.bundles.length + " bundle(s) found, [" + this.getBundleEntries().length + " file(s)]."));
        }
    }

    protected synchronized void setLanguage(Locale locale) {
        I18nLanguage result;
        this.init();
        if (log.isDebugEnabled()) {
            log.debug((Object)("locale: " + locale));
        }
        if ((result = this.getLanguage(locale)) == null) {
            result = this.addLanguage(locale);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("using cached language : " + result));
        }
        this.language = result;
        Locale.setDefault(locale);
    }

    protected void close() {
        if (this.languages != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("will close " + this.languages.size() + " language(s)."));
            }
            for (I18nLanguage l : this.languages) {
                l.close();
            }
            this.languages.clear();
            this.languages = null;
        }
        if (this.bundles != null) {
            this.bundles = null;
        }
        this.language = null;
    }

    protected I18nLanguage getLanguage(Locale locale) {
        if (this.languages != null && !this.languages.isEmpty()) {
            for (I18nLanguage l : this.languages) {
                if (!locale.equals(l.getLocale())) continue;
                return l;
            }
        }
        return null;
    }

    protected I18nLanguage addLanguage(Locale locale) {
        I18nLanguage result = new I18nLanguage(locale);
        I18nBundleEntry[] entries = this.getBundleEntries(locale);
        result.load(entries);
        if (log.isInfoEnabled()) {
            log.info((Object)(result + ", nbEntries: " + entries.length + ", nbSentences: " + result.size() + "."));
        }
        this.getLanguages().add(result);
        return result;
    }

    protected boolean isInit() {
        return this.bundles != null;
    }

    protected void checkInit() {
        if (!this.isInit()) {
            throw new IllegalStateException("should call init method on " + I18nStore.class);
        }
    }
}

