/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Constants;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.TransformationUtil;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AlreadyAddedMethodAdapter;

public class AddWrapperVisitor
extends ClassAdapter
implements Constants,
TransformationConstants {
    private ContextImpl m_context;
    private Set m_addedMethods;

    public AddWrapperVisitor(ClassVisitor classVisitor, Context context, Set alreadyAddedMethods) {
        super(classVisitor);
        this.m_context = (ContextImpl)context;
        this.m_addedMethods = alreadyAddedMethods;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        List jps = this.m_context.getEmittedJoinPoints();
        Iterator iterator = jps.iterator();
        while (iterator.hasNext()) {
            EmittedJoinPoint emittedJoinPoint = (EmittedJoinPoint)iterator.next();
            int jpType = emittedJoinPoint.getJoinPointType();
            String calleeName = emittedJoinPoint.getCalleeMemberName();
            if (Modifier.isPublic(emittedJoinPoint.getCalleeMemberModifiers()) || !name.equals(emittedJoinPoint.getCalleeClassName())) continue;
            switch (jpType) {
                case 6: {
                    this.createGetFieldWrapperMethod(Modifier.isStatic(emittedJoinPoint.getCalleeMemberModifiers()), name, emittedJoinPoint.getCalleeMemberName(), emittedJoinPoint.getCalleeMemberDesc());
                    break;
                }
                case 5: {
                    this.createPutFieldWrapperMethod(Modifier.isStatic(emittedJoinPoint.getCalleeMemberModifiers()), name, emittedJoinPoint.getCalleeMemberName(), emittedJoinPoint.getCalleeMemberDesc());
                    break;
                }
                case 1: 
                case 2: {
                    this.createMethodWrapperMethod(emittedJoinPoint.getCalleeMemberModifiers(), name, emittedJoinPoint.getCalleeMemberName(), emittedJoinPoint.getCalleeMemberDesc(), new String[0], null);
                }
            }
        }
        super.visit(version, access, name, superName, interfaces, sourceFile);
    }

    private void createGetFieldWrapperMethod(boolean isStaticField, String declaringTypeName, String name, String desc) {
        String wrapperName = TransformationUtil.getWrapperMethodName(name, desc, declaringTypeName, "GETFIELD$_AW_$");
        StringBuffer signature = new StringBuffer();
        signature.append('(');
        signature.append(')');
        signature.append(desc);
        String wrapperKey = AlreadyAddedMethodAdapter.getMethodKey(wrapperName, signature.toString());
        if (this.m_addedMethods.contains(wrapperKey)) {
            return;
        }
        this.m_addedMethods.add(wrapperKey);
        int modifiers = 4096;
        if (isStaticField) {
            modifiers |= 8;
        }
        CodeVisitor mv = this.cv.visitMethod(modifiers, wrapperName, signature.toString(), new String[0], null);
        if (isStaticField) {
            mv.visitFieldInsn(178, declaringTypeName, name, desc);
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, declaringTypeName, name, desc);
        }
        AsmHelper.addReturnStatement(mv, Type.getType(desc));
        mv.visitMaxs(0, 0);
    }

    private void createPutFieldWrapperMethod(boolean isStaticField, String declaringTypeName, String name, String desc) {
        String wrapperName = TransformationUtil.getWrapperMethodName(name, desc, declaringTypeName, "PUTFIELD$_AW_$");
        StringBuffer signature = new StringBuffer();
        signature.append('(');
        signature.append(desc);
        signature.append(')');
        signature.append('V');
        String wrapperKey = AlreadyAddedMethodAdapter.getMethodKey(wrapperName, signature.toString());
        if (this.m_addedMethods.contains(wrapperKey)) {
            return;
        }
        this.m_addedMethods.add(wrapperKey);
        int modifiers = 4096;
        if (isStaticField) {
            modifiers |= 8;
        }
        CodeVisitor mv = this.cv.visitMethod(modifiers, wrapperName, signature.toString(), new String[0], null);
        Type fieldType = Type.getType(desc);
        if (isStaticField) {
            AsmHelper.loadArgumentTypes(mv, new Type[]{fieldType}, true);
            mv.visitFieldInsn(179, declaringTypeName, name, desc);
        } else {
            mv.visitVarInsn(25, 0);
            AsmHelper.loadArgumentTypes(mv, new Type[]{fieldType}, false);
            mv.visitFieldInsn(181, declaringTypeName, name, desc);
        }
        AsmHelper.addReturnStatement(mv, Type.VOID_TYPE);
        mv.visitMaxs(0, 0);
    }

    private void createMethodWrapperMethod(int access, String declaringTypeName, String name, String desc, String[] exceptions, Attribute attrs) {
        String wrapperName = TransformationUtil.getWrapperMethodName(name, desc, declaringTypeName, "INVOKE$_AW_$");
        String wrapperKey = AlreadyAddedMethodAdapter.getMethodKey(wrapperName, desc);
        if (this.m_addedMethods.contains(wrapperKey)) {
            return;
        }
        this.m_addedMethods.add(wrapperKey);
        int modifiers = 4096;
        if (Modifier.isStatic(access)) {
            modifiers |= 8;
        }
        CodeVisitor mv = super.visitMethod(modifiers, wrapperName, desc, exceptions, attrs);
        if (Modifier.isStatic(access)) {
            AsmHelper.loadArgumentTypes(mv, Type.getArgumentTypes(desc), Modifier.isStatic(access));
            mv.visitMethodInsn(184, declaringTypeName, name, desc);
        } else {
            mv.visitVarInsn(25, 0);
            AsmHelper.loadArgumentTypes(mv, Type.getArgumentTypes(desc), Modifier.isStatic(access));
            mv.visitMethodInsn(182, declaringTypeName, name, desc);
        }
        AsmHelper.addReturnStatement(mv, Type.getReturnType(desc));
        mv.visitMaxs(0, 0);
    }
}

