/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.deployer;

import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.transform.inlining.deployer.Redefiner;
import org.codehaus.aspectwerkz.util.ContextClassLoader;

public class RedefinerFactory {
    private static final String HOTSWAP_REDEFINER_CLASS_NAME = "org.codehaus.aspectwerkz.extension.hotswap.HotSwapRedefiner";
    private static final String JVMTI_REDEFINER_CLASS_NAME = "org.codehaus.aspectwerkz.hook.JVMTIRedefiner";

    public static Redefiner newRedefiner(Type type) {
        if (type.equals(Type.HOTSWAP)) {
            try {
                Class redefinerClass = ContextClassLoader.forName(JVMTI_REDEFINER_CLASS_NAME);
                return (Redefiner)redefinerClass.newInstance();
            }
            catch (Throwable t) {
                try {
                    Class redefinerClass = ContextClassLoader.forName(HOTSWAP_REDEFINER_CLASS_NAME);
                    return (Redefiner)redefinerClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new WrappedRuntimeException("redefiner class [HotSwapRedefiner] could not be found on classpath, make sure you have the aspectwerkz extensions jar file in your classpath", e);
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException("redefiner class [HotSwapRedefiner] could not be instantiated", e);
                }
            }
        }
        if (type.equals(Type.JVMTI)) {
            throw new UnsupportedOperationException("JVMTI is not supported yet");
        }
        throw new UnsupportedOperationException("unknown redefiner type: " + type.toString());
    }

    public static class Type {
        public static final Type HOTSWAP = new Type("HOTSWAP");
        public static final Type JVMTI = new Type("JVMTI");
        private final String m_name;

        private Type(String name) {
            this.m_name = name;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

