/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.compiler;

import org.codehaus.aspectwerkz.cflow.CflowCompiler;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.expression.ExpressionVisitor;
import org.codehaus.aspectwerkz.expression.Undeterministic;
import org.codehaus.aspectwerkz.expression.ast.ASTAnd;
import org.codehaus.aspectwerkz.expression.ast.ASTArgs;
import org.codehaus.aspectwerkz.expression.ast.ASTCall;
import org.codehaus.aspectwerkz.expression.ast.ASTCflow;
import org.codehaus.aspectwerkz.expression.ast.ASTCflowBelow;
import org.codehaus.aspectwerkz.expression.ast.ASTExecution;
import org.codehaus.aspectwerkz.expression.ast.ASTGet;
import org.codehaus.aspectwerkz.expression.ast.ASTHandler;
import org.codehaus.aspectwerkz.expression.ast.ASTHasField;
import org.codehaus.aspectwerkz.expression.ast.ASTHasMethod;
import org.codehaus.aspectwerkz.expression.ast.ASTNot;
import org.codehaus.aspectwerkz.expression.ast.ASTOr;
import org.codehaus.aspectwerkz.expression.ast.ASTPointcutReference;
import org.codehaus.aspectwerkz.expression.ast.ASTSet;
import org.codehaus.aspectwerkz.expression.ast.ASTStaticInitialization;
import org.codehaus.aspectwerkz.expression.ast.ASTTarget;
import org.codehaus.aspectwerkz.expression.ast.ASTThis;
import org.codehaus.aspectwerkz.expression.ast.ASTWithin;
import org.codehaus.aspectwerkz.expression.ast.ASTWithinCode;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Constants;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.compiler.AbstractJoinPointCompiler;

public class RuntimeCheckVisitor
extends ExpressionVisitor
implements Constants {
    private AbstractJoinPointCompiler m_compiler;
    private CodeVisitor cv;
    private ExpressionInfo m_expressionInfo;
    private boolean m_isOptimizedJoinPoint;
    private int m_joinPointIndex;
    private int m_calleeIndex;

    public RuntimeCheckVisitor(AbstractJoinPointCompiler compiler, CodeVisitor cv, ExpressionInfo info, boolean isOptimizedJoinPoint, int joinPointIndex, int calleeIndex) {
        super(info, info.toString(), info.getNamespace(), info.getExpression().getASTRoot());
        this.m_compiler = compiler;
        this.m_expressionInfo = info;
        this.m_isOptimizedJoinPoint = isOptimizedJoinPoint;
        this.m_joinPointIndex = joinPointIndex;
        this.m_calleeIndex = calleeIndex;
        this.cv = cv;
    }

    public void pushCheckOnStack(ExpressionContext context) {
        super.match(context);
    }

    public Object visit(ASTOr node, Object data) {
        Boolean matchL = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        Boolean matchR = (Boolean)node.jjtGetChild(1).jjtAccept(this, data);
        Boolean intermediate = Undeterministic.or(matchL, matchR);
        this.cv.visitInsn(128);
        for (int i = 2; i < node.jjtGetNumChildren(); ++i) {
            Boolean matchNext = (Boolean)node.jjtGetChild(i).jjtAccept(this, data);
            intermediate = Undeterministic.or(intermediate, matchNext);
            this.cv.visitInsn(128);
        }
        return intermediate;
    }

    public Object visit(ASTAnd node, Object data) {
        Boolean matchL = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        Boolean matchR = (Boolean)node.jjtGetChild(1).jjtAccept(this, data);
        Boolean intermediate = Undeterministic.and(matchL, matchR);
        this.cv.visitInsn(126);
        for (int i = 2; i < node.jjtGetNumChildren(); ++i) {
            Boolean matchNext = (Boolean)node.jjtGetChild(i).jjtAccept(this, data);
            intermediate = Undeterministic.and(intermediate, matchNext);
            this.cv.visitInsn(126);
        }
        return intermediate;
    }

    public Object visit(ASTNot node, Object data) {
        Boolean match = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        this.cv.visitInsn(116);
        return Undeterministic.not(match);
    }

    public Object visit(ASTTarget node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        if (match != null) {
            this.push(match);
        } else {
            String boundedTypeDesc = AsmHelper.convertReflectDescToTypeDesc(node.getBoundedType(this.m_expressionInfo));
            this.m_compiler.loadCallee(this.cv, this.m_isOptimizedJoinPoint, this.m_joinPointIndex, this.m_calleeIndex);
            this.cv.visitTypeInsn(193, boundedTypeDesc.substring(1, boundedTypeDesc.length() - 1));
        }
        return match;
    }

    public Object visit(ASTThis node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTCflow node, Object data) {
        String cflowClassName = CflowCompiler.getCflowAspectClassName(node.hashCode());
        this.cv.visitMethodInsn(184, cflowClassName, "isInCflow", "()Z");
        return (Boolean)super.visit(node, data);
    }

    public Object visit(ASTCflowBelow node, Object data) {
        String cflowClassName = CflowCompiler.getCflowAspectClassName(node.hashCode());
        this.cv.visitMethodInsn(184, cflowClassName, "isInCflow", "()Z");
        return (Boolean)super.visit(node, data);
    }

    public Object visit(ASTArgs node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTPointcutReference node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        ExpressionNamespace namespace = ExpressionNamespace.getNamespace(this.m_namespace);
        ExpressionVisitor expression = namespace.getExpression(node.getName());
        RuntimeCheckVisitor referenced = new RuntimeCheckVisitor(this.m_compiler, this.cv, expression.getExpressionInfo(), this.m_isOptimizedJoinPoint, this.m_joinPointIndex, this.m_calleeIndex);
        return referenced.matchUndeterministic(context);
    }

    public Object visit(ASTExecution node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTCall node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTSet node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTGet node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTHandler node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTStaticInitialization node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTWithin node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTWithinCode node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTHasMethod node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTHasField node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    private void push(Boolean b) {
        if (b == null) {
            throw new Error("attempt to push an undetermined match result");
        }
        if (b.booleanValue()) {
            this.cv.visitInsn(4);
        } else {
            this.cv.visitInsn(2);
        }
    }
}

