/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining;

import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.transform.AspectWerkzPreProcessor;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;

public class ContextImpl
implements Context {
    private final String m_className;
    private final byte[] m_initialBytecode;
    private byte[] m_currentBytecode;
    private final ClassLoader m_loader;
    private boolean m_advised = false;
    private boolean m_madeAdvisable = false;
    private boolean m_readOnly = false;
    private Map m_metaData = new HashMap();
    private final Set m_definitions;
    private final List m_emittedJoinPoints = new ArrayList();
    private final TObjectIntHashMap m_labelTolineNumbers = new TObjectIntHashMap();
    private long m_serialVerUid;

    public ContextImpl(String className, byte[] bytecode, ClassLoader loader) {
        this.m_className = className.replace('.', '/');
        this.m_loader = loader;
        this.m_initialBytecode = bytecode;
        this.m_currentBytecode = bytecode;
        this.m_definitions = SystemDefinitionContainer.getDefinitionsFor(this.m_loader);
    }

    public String getClassName() {
        return this.m_className;
    }

    public byte[] getInitialBytecode() {
        return this.m_initialBytecode;
    }

    public byte[] getCurrentBytecode() {
        return this.m_currentBytecode;
    }

    public void setCurrentBytecode(byte[] bytecode) {
        this.m_currentBytecode = bytecode;
    }

    public ClassLoader getLoader() {
        return this.m_loader;
    }

    public Set getDefinitions() {
        return this.m_definitions;
    }

    public void markAsAdvised() {
        this.m_advised = true;
    }

    public void markMadeAdvisable() {
        this.m_madeAdvisable = true;
    }

    public void resetAdvised() {
        this.m_advised = false;
    }

    public boolean isAdvised() {
        return this.m_advised;
    }

    public boolean isMadeAdvisable() {
        return this.m_madeAdvisable;
    }

    public void markAsReadOnly() {
        this.m_readOnly = true;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public Object getMetaData(Object key) {
        return this.m_metaData.get(key);
    }

    public void addMetaData(Object key, Object value) {
        if (this.m_readOnly) {
            throw new IllegalStateException("context is read only");
        }
        this.m_metaData.put(key, value);
    }

    public void dump(String dumpDir) {
        try {
            int lastSegmentIndex = this.m_className.lastIndexOf(47);
            if (lastSegmentIndex < 0) {
                lastSegmentIndex = 0;
            }
            File dir = new File(dumpDir + File.separator + this.m_className.substring(0, lastSegmentIndex));
            dir.mkdirs();
            FileOutputStream os = new FileOutputStream(dumpDir + File.separator + this.m_className.replace('.', '/') + ".class");
            os.write(this.m_currentBytecode);
            os.close();
        }
        catch (Exception e) {
            AspectWerkzPreProcessor.log("failed to dump " + this.m_className);
            e.printStackTrace();
        }
    }

    public void addEmittedJoinPoint(EmittedJoinPoint jp) {
        this.m_emittedJoinPoints.add(jp);
    }

    public List getEmittedJoinPoints() {
        return this.m_emittedJoinPoints;
    }

    public void setSerialVerUid(long initialSerialVerUid) {
        this.m_serialVerUid = initialSerialVerUid;
    }

    public long getSerialVerUid() {
        return this.m_serialVerUid;
    }

    public void addLineNumberInfo(Label label, int lineNumber) {
        this.m_labelTolineNumbers.put((Object)label, lineNumber);
    }

    public int resolveLineNumberInfo(Label label) {
        if (this.m_labelTolineNumbers.containsKey((Object)label)) {
            return this.m_labelTolineNumbers.get((Object)label);
        }
        return 0;
    }
}

