/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassReader;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ConstructorInfo;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfo;
import org.codehaus.aspectwerkz.transform.AspectWerkzPreProcessor;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.util.ContextClassLoader;

public class AsmHelper
implements TransformationConstants {
    public static final ClassInfo INTEGER = JavaClassInfo.getClassInfo(Integer.TYPE);
    public static final ClassInfo VOID = JavaClassInfo.getClassInfo(Void.TYPE);
    public static final ClassInfo BOOLEAN = JavaClassInfo.getClassInfo(Boolean.TYPE);
    public static final ClassInfo BYTE = JavaClassInfo.getClassInfo(Byte.TYPE);
    public static final ClassInfo CHARACTER = JavaClassInfo.getClassInfo(Character.TYPE);
    public static final ClassInfo SHORT = JavaClassInfo.getClassInfo(Short.TYPE);
    public static final ClassInfo DOUBLE = JavaClassInfo.getClassInfo(Double.TYPE);
    public static final ClassInfo FLOAT = JavaClassInfo.getClassInfo(Float.TYPE);
    public static final ClassInfo LONG = JavaClassInfo.getClassInfo(Long.TYPE);
    private static Class CLASS_LOADER;
    private static Method CLASS_LOADER_DEFINE;
    private static final ProtectionDomain PROTECTION_DOMAIN;
    public static final boolean IS_JAVA_5;
    public static int JAVA_VERSION;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$transform$inlining$AsmHelper;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$security$ProtectionDomain;

    public static ClassWriter newClassWriter(boolean computeMax) {
        return new ClassWriter(computeMax, true);
    }

    public static Type[] getArgumentTypes(Constructor constructor) {
        Class<?>[] classes = constructor.getParameterTypes();
        Type[] types = new Type[classes.length];
        for (int i = classes.length - 1; i >= 0; --i) {
            types[i] = Type.getType(classes[i]);
        }
        return types;
    }

    public static void dumpClass(String dumpDir, String className, byte[] bytes) throws IOException {
        File dir = className.lastIndexOf(47) > 0 ? new File(dumpDir + File.separator + className.substring(0, className.lastIndexOf(47))) : new File(dumpDir);
        dir.mkdirs();
        String fileName = dumpDir + File.separator + className + ".class";
        if (AspectWerkzPreProcessor.VERBOSE) {
            System.out.println("AW INFO: dumping class " + className + " to " + dumpDir);
        }
        FileOutputStream os = new FileOutputStream(fileName);
        os.write(bytes);
        os.close();
    }

    public static void dumpClass(String dumpDir, String className, ClassWriter cw) throws IOException {
        File dir = new File(dumpDir + File.separator + className.substring(0, className.lastIndexOf(47)));
        dir.mkdirs();
        String fileName = dumpDir + File.separator + className + ".class";
        if (AspectWerkzPreProcessor.VERBOSE) {
            System.out.println("AW INFO: dumping class " + className + " to " + dumpDir);
        }
        FileOutputStream os = new FileOutputStream(fileName);
        os.write(cw.toByteArray());
        os.close();
    }

    public static Class defineClass(ClassLoader loader, byte[] bytes, String name) {
        String className = name.replace('/', '.');
        try {
            if (loader == null) {
                loader = ContextClassLoader.getLoader();
            }
            Object[] args = new Object[]{className, bytes, new Integer(0), new Integer(bytes.length), PROTECTION_DOMAIN};
            Class clazz = (Class)CLASS_LOADER_DEFINE.invoke((Object)loader, args);
            return clazz;
        }
        catch (InvocationTargetException e) {
            Class failoverJoinpointClass;
            if (e.getTargetException() instanceof LinkageError && (failoverJoinpointClass = AsmHelper.forName(loader, className)) != null) {
                return failoverJoinpointClass;
            }
            throw new WrappedRuntimeException(e);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static Class forName(ClassLoader loader, String name) {
        String className = name.replace('/', '.');
        try {
            if (loader == null) {
                loader = ContextClassLoader.getLoader();
            }
            return Class.forName(className, false, loader);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int calculateMethodHash(String name, String desc) {
        int hash = 17;
        hash = 37 * hash + name.replace('/', '.').hashCode();
        Type[] argumentTypes = Type.getArgumentTypes(desc);
        for (int i = 0; i < argumentTypes.length; ++i) {
            hash = 37 * hash + AsmHelper.convertTypeDescToReflectDesc(argumentTypes[i].getDescriptor()).hashCode();
        }
        return hash;
    }

    public static int calculateConstructorHash(String desc) {
        return AsmHelper.calculateMethodHash("<init>", desc);
    }

    public static int calculateFieldHash(String name, String desc) {
        int hash = 17;
        hash = 37 * hash + name.hashCode();
        Type type = Type.getType(desc);
        hash = 37 * hash + AsmHelper.convertTypeDescToReflectDesc(type.getDescriptor()).hashCode();
        return hash;
    }

    public static int calculateClassHash(String declaringType) {
        return AsmHelper.convertTypeDescToReflectDesc(declaringType).hashCode();
    }

    public static String convertArrayTypeName(String typeName) {
        int index = typeName.lastIndexOf(91);
        if (index != -1) {
            StringBuffer arrayType = new StringBuffer();
            if (typeName.endsWith("I")) {
                arrayType.append("int");
            } else if (typeName.endsWith("J")) {
                arrayType.append("long");
            } else if (typeName.endsWith("S")) {
                arrayType.append("short");
            } else if (typeName.endsWith("F")) {
                arrayType.append("float");
            } else if (typeName.endsWith("D")) {
                arrayType.append("double");
            } else if (typeName.endsWith("Z")) {
                arrayType.append("boolean");
            } else if (typeName.endsWith("C")) {
                arrayType.append("char");
            } else if (typeName.endsWith("B")) {
                arrayType.append("byte");
            } else {
                arrayType.append(typeName.substring(index + 2, typeName.length() - 1));
            }
            for (int i = 0; i < index + 1; ++i) {
                arrayType.append("[]");
            }
            return arrayType.toString();
        }
        return typeName;
    }

    public static String convertTypeDescToReflectDesc(String typeDesc) {
        if (typeDesc == null) {
            return null;
        }
        String result = null;
        if (typeDesc.startsWith("[")) {
            result = typeDesc;
        } else if (typeDesc.startsWith("L") && typeDesc.endsWith(";")) {
            result = typeDesc.substring(1, typeDesc.length() - 1);
        } else if (typeDesc.equals("I")) {
            result = "int";
        } else if (typeDesc.equals("J")) {
            result = "long";
        } else if (typeDesc.equals("S")) {
            result = "short";
        } else if (typeDesc.equals("F")) {
            result = "float";
        } else if (typeDesc.equals("D")) {
            result = "double";
        } else if (typeDesc.equals("Z")) {
            result = "boolean";
        } else if (typeDesc.equals("C")) {
            result = "char";
        } else if (typeDesc.equals("B")) {
            result = "byte";
        } else {
            throw new RuntimeException("unknown primitive type " + typeDesc);
        }
        return result.replace('/', '.');
    }

    public static String convertReflectDescToTypeDesc(String desc) {
        int i;
        if (desc == null) {
            return null;
        }
        String typeDesc = desc;
        int dimension = 0;
        char[] arr = desc.toCharArray();
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] != ']') continue;
            ++dimension;
        }
        typeDesc = desc.substring(0, desc.length() - dimension * 2);
        typeDesc = typeDesc.equals("int") ? "I" : (typeDesc.equals("short") ? "S" : (typeDesc.equals("long") ? "J" : (typeDesc.equals("float") ? "F" : (typeDesc.equals("double") ? "D" : (typeDesc.equals("byte") ? "B" : (typeDesc.equals("char") ? "C" : (typeDesc.equals("boolean") ? "Z" : 'L' + typeDesc + ';')))))));
        for (i = 0; i < dimension; ++i) {
            typeDesc = '[' + typeDesc;
        }
        return typeDesc.replace('.', '/');
    }

    public static void addReturnStatement(CodeVisitor mv, Type type) {
        switch (type.getSort()) {
            case 0: {
                mv.visitInsn(177);
                break;
            }
            case 7: {
                mv.visitInsn(173);
                break;
            }
            case 5: {
                mv.visitInsn(172);
                break;
            }
            case 4: {
                mv.visitInsn(172);
                break;
            }
            case 8: {
                mv.visitInsn(175);
                break;
            }
            case 6: {
                mv.visitInsn(174);
                break;
            }
            case 3: {
                mv.visitInsn(172);
                break;
            }
            case 1: {
                mv.visitInsn(172);
                break;
            }
            case 2: {
                mv.visitInsn(172);
                break;
            }
            case 9: {
                mv.visitInsn(176);
                break;
            }
            case 10: {
                mv.visitInsn(176);
            }
        }
    }

    public static void loadArgumentTypes(CodeVisitor mv, Type[] argumentTypes, boolean staticMethod) {
        int index = staticMethod ? 0 : 1;
        for (int i = 0; i < argumentTypes.length; ++i) {
            index = AsmHelper.loadType(mv, index, argumentTypes[i]);
        }
    }

    public static int loadType(CodeVisitor cv, int index, Type type) {
        switch (type.getSort()) {
            case 7: {
                cv.visitVarInsn(22, index++);
                ++index;
                break;
            }
            case 5: {
                cv.visitVarInsn(21, index++);
                break;
            }
            case 4: {
                cv.visitVarInsn(21, index++);
                break;
            }
            case 8: {
                cv.visitVarInsn(24, index++);
                ++index;
                break;
            }
            case 6: {
                cv.visitVarInsn(23, index++);
                break;
            }
            case 3: {
                cv.visitVarInsn(21, index++);
                break;
            }
            case 1: {
                cv.visitVarInsn(21, index++);
                break;
            }
            case 2: {
                cv.visitVarInsn(21, index++);
                break;
            }
            case 9: {
                cv.visitVarInsn(25, index++);
                break;
            }
            case 10: {
                cv.visitVarInsn(25, index++);
            }
        }
        return index;
    }

    public static int storeType(CodeVisitor cv, int index, Type type) {
        switch (type.getSort()) {
            case 0: {
                break;
            }
            case 7: {
                cv.visitVarInsn(55, index++);
                ++index;
                break;
            }
            case 5: {
                cv.visitVarInsn(54, index++);
                break;
            }
            case 4: {
                cv.visitVarInsn(54, index++);
                break;
            }
            case 8: {
                cv.visitVarInsn(57, index++);
                ++index;
                break;
            }
            case 6: {
                cv.visitVarInsn(56, index++);
                break;
            }
            case 3: {
                cv.visitVarInsn(54, index++);
                break;
            }
            case 1: {
                cv.visitVarInsn(54, index++);
                break;
            }
            case 2: {
                cv.visitVarInsn(54, index++);
                break;
            }
            case 9: {
                cv.visitVarInsn(58, index++);
                break;
            }
            case 10: {
                cv.visitVarInsn(58, index++);
            }
        }
        return index;
    }

    public static void loadIntegerConstant(CodeVisitor cv, int index) {
        switch (index) {
            case 0: {
                cv.visitInsn(3);
                break;
            }
            case 1: {
                cv.visitInsn(4);
                break;
            }
            case 2: {
                cv.visitInsn(5);
                break;
            }
            case 3: {
                cv.visitInsn(6);
                break;
            }
            case 4: {
                cv.visitInsn(7);
                break;
            }
            case 5: {
                cv.visitInsn(8);
                break;
            }
            default: {
                cv.visitIntInsn(16, index);
            }
        }
    }

    public static void prepareWrappingOfPrimitiveType(CodeVisitor cv, Type type) {
        switch (type.getSort()) {
            case 4: {
                cv.visitTypeInsn(187, "java/lang/Short");
                cv.visitInsn(89);
                break;
            }
            case 5: {
                cv.visitTypeInsn(187, "java/lang/Integer");
                cv.visitInsn(89);
                break;
            }
            case 7: {
                cv.visitTypeInsn(187, "java/lang/Long");
                cv.visitInsn(89);
                break;
            }
            case 6: {
                cv.visitTypeInsn(187, "java/lang/Float");
                cv.visitInsn(89);
                break;
            }
            case 8: {
                cv.visitTypeInsn(187, "java/lang/Double");
                cv.visitInsn(89);
                break;
            }
            case 3: {
                cv.visitTypeInsn(187, "java/lang/Byte");
                cv.visitInsn(89);
                break;
            }
            case 1: {
                cv.visitTypeInsn(187, "java/lang/Boolean");
                cv.visitInsn(89);
                break;
            }
            case 2: {
                cv.visitTypeInsn(187, "java/lang/Character");
                cv.visitInsn(89);
            }
        }
    }

    public static void wrapPrimitiveType(CodeVisitor cv, Type type) {
        switch (type.getSort()) {
            case 0: {
                cv.visitInsn(1);
                break;
            }
            case 4: {
                cv.visitMethodInsn(183, "java/lang/Short", "<init>", "(S)V");
                break;
            }
            case 5: {
                cv.visitMethodInsn(183, "java/lang/Integer", "<init>", "(I)V");
                break;
            }
            case 7: {
                cv.visitMethodInsn(183, "java/lang/Long", "<init>", "(J)V");
                break;
            }
            case 6: {
                cv.visitMethodInsn(183, "java/lang/Float", "<init>", "(F)V");
                break;
            }
            case 8: {
                cv.visitMethodInsn(183, "java/lang/Double", "<init>", "(D)V");
                break;
            }
            case 3: {
                cv.visitMethodInsn(183, "java/lang/Byte", "<init>", "(B)V");
                break;
            }
            case 1: {
                cv.visitMethodInsn(183, "java/lang/Boolean", "<init>", "(Z)V");
                break;
            }
            case 2: {
                cv.visitMethodInsn(183, "java/lang/Character", "<init>", "(C)V");
            }
        }
    }

    public static void unwrapType(CodeVisitor cv, Type type) {
        switch (type.getSort()) {
            case 10: {
                String objectTypeName = type.getClassName().replace('.', '/');
                cv.visitTypeInsn(192, objectTypeName);
                return;
            }
            case 9: {
                cv.visitTypeInsn(192, type.getDescriptor());
                return;
            }
            case 0: {
                return;
            }
        }
        Label l0If = new Label();
        Label l1End = new Label();
        cv.visitInsn(89);
        cv.visitJumpInsn(199, l0If);
        cv.visitInsn(87);
        AsmHelper.addDefaultValue(cv, type);
        cv.visitJumpInsn(167, l1End);
        cv.visitLabel(l0If);
        switch (type.getSort()) {
            case 4: {
                cv.visitTypeInsn(192, "java/lang/Short");
                cv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                break;
            }
            case 5: {
                cv.visitTypeInsn(192, "java/lang/Integer");
                cv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                break;
            }
            case 7: {
                cv.visitTypeInsn(192, "java/lang/Long");
                cv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                break;
            }
            case 6: {
                cv.visitTypeInsn(192, "java/lang/Float");
                cv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                break;
            }
            case 8: {
                cv.visitTypeInsn(192, "java/lang/Double");
                cv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                break;
            }
            case 3: {
                cv.visitTypeInsn(192, "java/lang/Byte");
                cv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                break;
            }
            case 1: {
                cv.visitTypeInsn(192, "java/lang/Boolean");
                cv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 2: {
                cv.visitTypeInsn(192, "java/lang/Character");
                cv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
            }
        }
        cv.visitLabel(l1End);
    }

    public static void addDefaultValue(CodeVisitor cv, Type type) {
        switch (type.getSort()) {
            case 10: {
                cv.visitInsn(1);
                break;
            }
            case 9: {
                cv.visitInsn(1);
                break;
            }
            case 5: {
                cv.visitInsn(3);
                break;
            }
            case 7: {
                cv.visitInsn(9);
                break;
            }
            case 4: {
                cv.visitInsn(3);
                break;
            }
            case 6: {
                cv.visitInsn(11);
                break;
            }
            case 8: {
                cv.visitInsn(14);
                break;
            }
            case 3: {
                cv.visitInsn(3);
                break;
            }
            case 1: {
                cv.visitInsn(3);
                break;
            }
            case 2: {
                cv.visitInsn(3);
            }
        }
    }

    public static void addNullableString(CodeVisitor cv, String value) {
        if (value == null) {
            cv.visitInsn(1);
        } else {
            cv.visitLdcInsn(value);
        }
    }

    public static int getRegisterDepth(Type[] typesOnStack) {
        int depth = 0;
        block4: for (int i = 0; i < typesOnStack.length; ++i) {
            Type type = typesOnStack[i];
            ++depth;
            switch (type.getSort()) {
                case 7: {
                    ++depth;
                    continue block4;
                }
                case 8: {
                    ++depth;
                }
            }
        }
        return depth;
    }

    public static int getRegisterIndexOf(Type[] typesOnStack, int typeIndex) {
        int depth = 0;
        block4: for (int i = 0; i < typeIndex; ++i) {
            Type type = typesOnStack[i];
            ++depth;
            switch (type.getSort()) {
                case 7: {
                    ++depth;
                    continue block4;
                }
                case 8: {
                    ++depth;
                }
            }
        }
        return depth;
    }

    public static int getTypeIndexOf(Type[] typesOnStack, int registerIndex) {
        for (int i = 0; i < typesOnStack.length; ++i) {
            int presumedRegisterIndex = AsmHelper.getRegisterIndexOf(typesOnStack, i);
            if (registerIndex != presumedRegisterIndex) continue;
            return i;
        }
        return -1;
    }

    public static boolean isPrimitive(Type returnType) {
        return returnType.getSort() == 5 || returnType.getSort() == 4 || returnType.getSort() == 7 || returnType.getSort() == 6 || returnType.getSort() == 8 || returnType.getSort() == 3 || returnType.getSort() == 2 || returnType.getSort() == 1 || returnType.getSort() == 0;
    }

    public static int incrementIndex(int index, Type type) {
        index = type.getSort() == 7 || type.getSort() == 8 ? (index += 2) : ++index;
        return index;
    }

    public static String getMethodDescriptor(MethodInfo method) {
        ClassInfo[] parameters = method.getParameterTypes();
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        for (int i = 0; i < parameters.length; ++i) {
            AsmHelper.getClassDescriptor(buf, parameters[i]);
        }
        buf.append(')');
        AsmHelper.getClassDescriptor(buf, method.getReturnType());
        return buf.toString();
    }

    public static String getConstructorDescriptor(ConstructorInfo constructor) {
        ClassInfo[] parameters = constructor.getParameterTypes();
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        for (int i = 0; i < parameters.length; ++i) {
            AsmHelper.getClassDescriptor(buf, parameters[i]);
        }
        buf.append(')');
        AsmHelper.getClassDescriptor(buf, VOID);
        return buf.toString();
    }

    public static String getFieldDescriptor(FieldInfo field) {
        return AsmHelper.getClassDescriptor(field.getType());
    }

    public static String getClassDescriptor(ClassInfo c) {
        StringBuffer buf = new StringBuffer();
        AsmHelper.getClassDescriptor(buf, c);
        return buf.toString();
    }

    private static void getClassDescriptor(StringBuffer buf, ClassInfo klass) {
        ClassInfo d = klass;
        while (true) {
            if (d.isPrimitive()) {
                int car;
                if (d.equals(INTEGER)) {
                    car = 73;
                } else if (d.equals(VOID)) {
                    car = 86;
                } else if (d.equals(BOOLEAN)) {
                    car = 90;
                } else if (d.equals(BYTE)) {
                    car = 66;
                } else if (d.equals(CHARACTER)) {
                    car = 67;
                } else if (d.equals(SHORT)) {
                    car = 83;
                } else if (d.equals(DOUBLE)) {
                    car = 68;
                } else if (d.equals(FLOAT)) {
                    car = 70;
                } else if (d.equals(LONG)) {
                    car = 74;
                } else {
                    throw new Error("should not happen");
                }
                buf.append((char)car);
                return;
            }
            if (!d.isArray()) break;
            buf.append('[');
            d = d.getComponentType();
        }
        buf.append('L');
        String name = d.getName();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char car = name.charAt(i);
            buf.append(car == '.' ? (char)'/' : (char)car);
        }
        buf.append(';');
    }

    public static Type[] getArgumentTypes(MethodInfo method) {
        ClassInfo[] classes = method.getParameterTypes();
        Type[] types = new Type[classes.length];
        for (int i = classes.length - 1; i >= 0; --i) {
            types[i] = AsmHelper.getType(classes[i]);
        }
        return types;
    }

    public static Type getType(ClassInfo c) {
        if (c.isPrimitive()) {
            if (c.equals(INTEGER)) {
                return Type.INT_TYPE;
            }
            if (c.equals(VOID)) {
                return Type.VOID_TYPE;
            }
            if (c.equals(BOOLEAN)) {
                return Type.BOOLEAN_TYPE;
            }
            if (c.equals(BYTE)) {
                return Type.BYTE_TYPE;
            }
            if (c.equals(CHARACTER)) {
                return Type.CHAR_TYPE;
            }
            if (c.equals(SHORT)) {
                return Type.SHORT_TYPE;
            }
            if (c.equals(DOUBLE)) {
                return Type.DOUBLE_TYPE;
            }
            if (c.equals(FLOAT)) {
                return Type.FLOAT_TYPE;
            }
            if (c.equals(LONG)) {
                return Type.LONG_TYPE;
            }
            throw new Error("should not happen");
        }
        return Type.getType(AsmHelper.getClassDescriptor(c));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return (class$org$codehaus$aspectwerkz$transform$inlining$AsmHelper == null ? (class$org$codehaus$aspectwerkz$transform$inlining$AsmHelper = AsmHelper.class$("org.codehaus.aspectwerkz.transform.inlining.AsmHelper")) : class$org$codehaus$aspectwerkz$transform$inlining$AsmHelper).getProtectionDomain();
            }
        });
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    CLASS_LOADER = Class.forName("java.lang.ClassLoader");
                    CLASS_LOADER_DEFINE = CLASS_LOADER.getDeclaredMethod("defineClass", class$java$lang$String == null ? (class$java$lang$String = AsmHelper.class$("java.lang.String")) : class$java$lang$String, array$B == null ? (array$B = AsmHelper.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE, class$java$security$ProtectionDomain == null ? (class$java$security$ProtectionDomain = AsmHelper.class$("java.security.ProtectionDomain")) : class$java$security$ProtectionDomain);
                    CLASS_LOADER_DEFINE.setAccessible(true);
                }
                catch (Throwable t) {
                    throw new Error(t.toString());
                }
                return null;
            }
        });
        JAVA_VERSION = 47;
        Class<?> annotation = null;
        try {
            annotation = Class.forName("java.lang.annotation.Annotation");
            ClassReader cr = new ClassReader("java.lang.annotation.Annotation");
            JAVA_VERSION = 49;
        }
        catch (Throwable e) {
            annotation = null;
        }
        IS_JAVA_5 = annotation != null;
    }
}

