/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.expression;

import gnu.trove.TObjectIntHashMap;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.expression.ExpressionVisitor;
import org.codehaus.aspectwerkz.expression.ast.ASTArgParameter;
import org.codehaus.aspectwerkz.expression.ast.ASTArgs;
import org.codehaus.aspectwerkz.expression.ast.ASTCflow;
import org.codehaus.aspectwerkz.expression.ast.ASTPointcutReference;
import org.codehaus.aspectwerkz.expression.ast.ASTTarget;
import org.codehaus.aspectwerkz.expression.ast.ASTThis;
import org.codehaus.aspectwerkz.expression.ast.Node;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;

public class ArgsIndexVisitor
extends ExpressionVisitor {
    private ClassLoader m_classLoader;

    public static void updateContextForRuntimeInformation(ExpressionInfo expressionInfo, ExpressionContext context, ClassLoader loader) {
        ArgsIndexVisitor visitor = new ArgsIndexVisitor(expressionInfo, expressionInfo.toString(), expressionInfo.getNamespace(), expressionInfo.getExpression().getASTRoot(), loader);
        visitor.match(context);
    }

    private ArgsIndexVisitor(ExpressionInfo expressionInfo, String expression, String namespace, Node root, ClassLoader loader) {
        super(expressionInfo, expression, namespace, root);
        this.m_classLoader = loader;
    }

    public Object visit(ASTPointcutReference node, Object data) {
        String referenceCallArg;
        ExpressionContext context = (ExpressionContext)data;
        ExpressionNamespace namespace = ExpressionNamespace.getNamespace(this.m_namespace);
        ExpressionInfo expressionInfo = namespace.getExpressionInfo(node.getName());
        ArgsIndexVisitor referenced = new ArgsIndexVisitor(expressionInfo, expressionInfo.toString(), expressionInfo.getNamespace(), expressionInfo.getExpression().getASTRoot(), this.m_classLoader);
        String targetSoFar = context.m_targetBoundedName;
        String thisSoFar = context.m_thisBoundedName;
        boolean targetWithRuntimeCheckSoFar = context.m_targetWithRuntimeCheck;
        TObjectIntHashMap exprIndexToTargetIndexSoFar = (TObjectIntHashMap)context.m_exprIndexToTargetIndex.clone();
        context.resetRuntimeState();
        Boolean match = referenced.matchUndeterministic(context);
        if (context.m_targetBoundedName == null) {
            context.m_targetBoundedName = targetSoFar;
        } else if (targetSoFar != null && node.jjtGetNumChildren() == 1 && !targetSoFar.equals(referenceCallArg = ((ASTArgParameter)node.jjtGetChild(0)).getTypePattern().getPattern())) {
            throw new UnsupportedOperationException("should not occur");
        }
        if (context.m_thisBoundedName == null) {
            context.m_thisBoundedName = thisSoFar;
        } else if (thisSoFar != null && node.jjtGetNumChildren() == 1 && !thisSoFar.equals(referenceCallArg = ((ASTArgParameter)node.jjtGetChild(0)).getTypePattern().getPattern())) {
            throw new UnsupportedOperationException("should not occur");
        }
        if (!context.m_targetWithRuntimeCheck) {
            context.m_targetWithRuntimeCheck = targetWithRuntimeCheckSoFar;
        }
        if (context.m_exprIndexToTargetIndex.isEmpty()) {
            context.m_exprIndexToTargetIndex = exprIndexToTargetIndexSoFar;
        } else if (!exprIndexToTargetIndexSoFar.isEmpty()) {
            throw new UnsupportedOperationException("should not occur");
        }
        TObjectIntHashMap exprToTargetArgIndexes = new TObjectIntHashMap();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            String referenceCallArg2 = ((ASTArgParameter)node.jjtGetChild(i)).getTypePattern().getPattern();
            String referentArg = expressionInfo.getArgumentNameAtIndex(i);
            if (referentArg.equals(context.m_targetBoundedName)) {
                context.m_targetBoundedName = referenceCallArg2;
                this.assertIsInstanceOf(expressionInfo.getArgumentType(referentArg), this.m_expressionInfo.getArgumentType(referenceCallArg2));
                continue;
            }
            if (referentArg.equals(context.m_thisBoundedName)) {
                context.m_thisBoundedName = referenceCallArg2;
                this.assertIsInstanceOf(expressionInfo.getArgumentType(referentArg), this.m_expressionInfo.getArgumentType(referenceCallArg2));
                continue;
            }
            int adviceArgIndex = i;
            if (!context.m_exprIndexToTargetIndex.containsKey((Object)referentArg)) continue;
            int targetArgIndex = context.m_exprIndexToTargetIndex.get((Object)referentArg);
            exprToTargetArgIndexes.put((Object)referenceCallArg2, targetArgIndex);
        }
        Object[] soFar = exprIndexToTargetIndexSoFar.keys();
        for (int i = 0; i < soFar.length; ++i) {
            String name = (String)soFar[i];
            if (exprToTargetArgIndexes.containsKey((Object)name)) continue;
            exprToTargetArgIndexes.put((Object)name, exprIndexToTargetIndexSoFar.get((Object)name));
        }
        context.m_exprIndexToTargetIndex = exprToTargetArgIndexes;
        return match;
    }

    public Object visit(ASTCflow node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        ExpressionInfo expressionInfo = new ExpressionInfo(node.jjtGetChild(0), this.m_namespace);
        expressionInfo.inheritPossibleArgumentFrom(this.m_expressionInfo);
        ArgsIndexVisitor referenced = new ArgsIndexVisitor(expressionInfo, "N/A", this.m_namespace, node.jjtGetChild(0), this.m_classLoader);
        String targetSoFar = context.m_targetBoundedName;
        String thisSoFar = context.m_thisBoundedName;
        boolean targetWithRuntimeCheckSoFar = context.m_targetWithRuntimeCheck;
        TObjectIntHashMap exprIndexToTargetIndexSoFar = (TObjectIntHashMap)context.m_exprIndexToTargetIndex.clone();
        context.resetRuntimeState();
        Boolean match = referenced.matchUndeterministic(context);
        if (context.m_targetBoundedName == null) {
            context.m_targetBoundedName = targetSoFar;
        } else if (targetSoFar != null) {
            // empty if block
        }
        if (context.m_thisBoundedName == null) {
            context.m_thisBoundedName = thisSoFar;
        } else if (thisSoFar != null) {
            // empty if block
        }
        if (!context.m_targetWithRuntimeCheck) {
            context.m_targetWithRuntimeCheck = targetWithRuntimeCheckSoFar;
        }
        if (context.m_exprIndexToTargetIndex.isEmpty()) {
            context.m_exprIndexToTargetIndex = exprIndexToTargetIndexSoFar;
        } else if (!exprIndexToTargetIndexSoFar.isEmpty()) {
            for (int i = 0; i < exprIndexToTargetIndexSoFar.keys().length; ++i) {
                Object o = exprIndexToTargetIndexSoFar.keys()[i];
                context.m_exprIndexToTargetIndex.put(o, exprIndexToTargetIndexSoFar.get(o));
            }
        }
        return match;
    }

    public Object visit(ASTArgs node, Object data) {
        return super.visit(node, data);
    }

    public Object visit(ASTArgParameter node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        int pointcutArgIndex = -1;
        if (node.getTypePattern().getPattern().indexOf(".") < 0) {
            pointcutArgIndex = this.m_expressionInfo.getArgumentIndex(node.getTypePattern().getPattern());
        }
        if (pointcutArgIndex >= 0 && Boolean.TRUE.equals(match)) {
            ExpressionContext ctx = (ExpressionContext)data;
            ctx.m_exprIndexToTargetIndex.put((Object)this.m_expressionInfo.getArgumentNameAtIndex(pointcutArgIndex), ctx.getCurrentTargetArgsIndex());
        }
        return match;
    }

    public Object visit(ASTThis node, Object data) {
        if (this.m_expressionInfo.getArgumentType(node.getIdentifier()) != null) {
            ExpressionContext ctx = (ExpressionContext)data;
            if (ctx.m_thisBoundedName == null) {
                ctx.m_thisBoundedName = node.getIdentifier();
            } else if (ctx.m_thisBoundedName != node.getIdentifier()) {
                throw new DefinitionException("this(..) seems to be bounded to different bounded entities in \"" + this.m_expressionInfo.toString() + "\" in " + this.m_expressionInfo.getNamespace() + " : found " + ctx.m_targetBoundedName + " and " + node.getIdentifier());
            }
        }
        return super.visit(node, data);
    }

    public Object visit(ASTTarget node, Object data) {
        Object match;
        if (this.m_expressionInfo.getArgumentType(node.getIdentifier()) != null) {
            ExpressionContext ctx = (ExpressionContext)data;
            if (ctx.m_targetBoundedName == null) {
                ctx.m_targetBoundedName = node.getIdentifier();
            } else if (ctx.m_targetBoundedName != node.getIdentifier()) {
                throw new DefinitionException("target(..) seems to be bounded to different bounded entities in \"" + this.m_expressionInfo.toString() + "\" in " + this.m_expressionInfo.getNamespace() + " : found " + ctx.m_targetBoundedName + " and " + node.getIdentifier());
            }
        }
        if ((match = super.visit(node, data)) == null) {
            ((ExpressionContext)data).m_targetWithRuntimeCheck = true;
        }
        return match;
    }

    private void assertIsInstanceOf(String className, String superClassName) {
        ClassInfo classInfo;
        boolean instanceOf;
        if (!className.equals(superClassName) && !(instanceOf = ClassInfoHelper.instanceOf(classInfo = AsmClassInfo.getClassInfo(className, this.m_classLoader), superClassName))) {
            throw new DefinitionException("Attempt to reference a pointcut with incompatible object type: for \"" + this.m_expression + "\" , " + className + " is not an instance of " + superClassName + "." + " Error occured in " + this.m_namespace);
        }
    }
}

