/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;

public class InterfaceIntroductionDefinition {
    protected final String m_name;
    protected ExpressionInfo[] m_expressionInfos = new ExpressionInfo[0];
    protected String m_attribute = "";
    protected List m_interfaceClassNames = new ArrayList();

    public InterfaceIntroductionDefinition(String name, String interfaceClassName) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (interfaceClassName == null) {
            throw new IllegalArgumentException("interface class name can not be null");
        }
        this.m_name = name;
        this.m_interfaceClassNames.add(interfaceClassName);
    }

    public String getName() {
        return this.m_name;
    }

    public ExpressionInfo[] getExpressionInfos() {
        return this.m_expressionInfos;
    }

    public String getInterfaceClassName() {
        return (String)this.m_interfaceClassNames.get(0);
    }

    public List getInterfaceClassNames() {
        return this.m_interfaceClassNames;
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public void setAttribute(String attribute) {
        this.m_attribute = attribute;
    }

    public void addExpressionInfo(ExpressionInfo expression) {
        ExpressionInfo[] tmpExpressions = new ExpressionInfo[this.m_expressionInfos.length + 1];
        System.arraycopy(this.m_expressionInfos, 0, tmpExpressions, 0, this.m_expressionInfos.length);
        tmpExpressions[this.m_expressionInfos.length] = expression;
        this.m_expressionInfos = new ExpressionInfo[this.m_expressionInfos.length + 1];
        System.arraycopy(tmpExpressions, 0, this.m_expressionInfos, 0, tmpExpressions.length);
    }

    public void addExpressionInfos(ExpressionInfo[] expressions) {
        ExpressionInfo[] tmpExpressions = new ExpressionInfo[this.m_expressionInfos.length + expressions.length];
        System.arraycopy(this.m_expressionInfos, 0, tmpExpressions, 0, this.m_expressionInfos.length);
        System.arraycopy(expressions, 0, tmpExpressions, this.m_expressionInfos.length, expressions.length);
        this.m_expressionInfos = new ExpressionInfo[this.m_expressionInfos.length + expressions.length];
        System.arraycopy(tmpExpressions, 0, this.m_expressionInfos, 0, tmpExpressions.length);
    }
}

