/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.InterfaceIntroductionDefinition;
import org.codehaus.aspectwerkz.definition.PointcutDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.reflect.ClassInfo;

public class AspectDefinition {
    private static final String DEFAULT_ASPECTCONTAINER_CLASSNAME = (class$org$codehaus$aspectwerkz$aspect$DefaultAspectContainerStrategy == null ? (class$org$codehaus$aspectwerkz$aspect$DefaultAspectContainerStrategy = AspectDefinition.class$("org.codehaus.aspectwerkz.aspect.DefaultAspectContainerStrategy")) : class$org$codehaus$aspectwerkz$aspect$DefaultAspectContainerStrategy).getName();
    public static final String ASPECTWERKZ_ASPECT_MODEL_TYPE = "aspectwerkz";
    private String m_name;
    private String m_qualifiedName;
    private final ClassInfo m_classInfo;
    private DeploymentModel m_deploymentModel = DeploymentModel.PER_JVM;
    private final List m_aroundAdviceDefinitions = new ArrayList();
    private final List m_beforeAdviceDefinitions = new ArrayList();
    private final List m_afterAdviceDefinitions = new ArrayList();
    private final List m_interfaceIntroductionDefinitions = new ArrayList();
    private final List m_pointcutDefinitions = new ArrayList();
    private Map m_parameters = new HashMap();
    private String m_containerClassName;
    private SystemDefinition m_systemDefinition;
    private String m_aspectModelType = "aspectwerkz";
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$aspect$DefaultAspectContainerStrategy;

    public AspectDefinition(String name, ClassInfo classInfo, SystemDefinition systemDefinition) {
        if (name == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        if (classInfo == null) {
            throw new IllegalArgumentException("aspect class info can not be null");
        }
        this.m_name = name;
        this.m_classInfo = classInfo;
        this.m_systemDefinition = systemDefinition;
        this.m_qualifiedName = systemDefinition.getUuid() + '/' + name;
        this.setContainerClassName(DEFAULT_ASPECTCONTAINER_CLASSNAME);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name.trim();
    }

    public String getQualifiedName() {
        return this.m_qualifiedName;
    }

    public SystemDefinition getSystemDefinition() {
        return this.m_systemDefinition;
    }

    public String getClassName() {
        return this.m_classInfo.getName();
    }

    public ClassInfo getClassInfo() {
        return this.m_classInfo;
    }

    public String getAspectModel() {
        return this.m_aspectModelType;
    }

    public boolean isAspectWerkzAspect() {
        return this.m_aspectModelType.equals(ASPECTWERKZ_ASPECT_MODEL_TYPE);
    }

    public void setAspectModel(String aspectModelType) {
        this.m_aspectModelType = aspectModelType;
    }

    public void setDeploymentModel(DeploymentModel deploymentModel) {
        this.m_deploymentModel = deploymentModel;
    }

    public DeploymentModel getDeploymentModel() {
        return this.m_deploymentModel;
    }

    public void addAroundAdviceDefinition(AdviceDefinition adviceDef) {
        if (!this.m_aroundAdviceDefinitions.contains(adviceDef)) {
            this.m_aroundAdviceDefinitions.add(adviceDef);
        }
    }

    public List getAroundAdviceDefinitions() {
        return this.m_aroundAdviceDefinitions;
    }

    public void addBeforeAdviceDefinition(AdviceDefinition adviceDef) {
        if (!this.m_beforeAdviceDefinitions.contains(adviceDef)) {
            this.m_beforeAdviceDefinitions.add(adviceDef);
        }
    }

    public List getBeforeAdviceDefinitions() {
        return this.m_beforeAdviceDefinitions;
    }

    public void addAfterAdviceDefinition(AdviceDefinition adviceDef) {
        if (!this.m_afterAdviceDefinitions.contains(adviceDef)) {
            this.m_afterAdviceDefinitions.add(adviceDef);
        }
    }

    public List getAfterAdviceDefinitions() {
        return this.m_afterAdviceDefinitions;
    }

    public void addInterfaceIntroductionDefinition(InterfaceIntroductionDefinition interfaceIntroDef) {
        this.m_interfaceIntroductionDefinitions.add(interfaceIntroDef);
    }

    public List getInterfaceIntroductionDefinitions() {
        return this.m_interfaceIntroductionDefinitions;
    }

    public void addPointcutDefinition(PointcutDefinition pointcutDef) {
        this.m_pointcutDefinitions.add(pointcutDef);
    }

    public Collection getPointcutDefinitions() {
        return this.m_pointcutDefinitions;
    }

    public void addParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public Map getParameters() {
        return this.m_parameters;
    }

    public void setContainerClassName(String containerClassName) {
        if (containerClassName != null) {
            this.m_containerClassName = containerClassName.replace('/', '.');
        }
    }

    public String getContainerClassName() {
        return this.m_containerClassName;
    }

    public List getAdviceDefinitions() {
        ArrayList allAdvices = new ArrayList();
        allAdvices.addAll(this.m_aroundAdviceDefinitions);
        allAdvices.addAll(this.m_beforeAdviceDefinitions);
        allAdvices.addAll(this.m_afterAdviceDefinitions);
        return allAdvices;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

