/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.cflow;

import java.util.Stack;

public abstract class AbstractCflowSystemAspect {
    public ThreadLocal m_cflowStackLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new Stack();
        }
    };

    public void enter() {
        ((Stack)this.m_cflowStackLocal.get()).push(Boolean.TRUE);
    }

    public void exit() {
        ((Stack)this.m_cflowStackLocal.get()).pop();
    }

    public boolean inCflow() {
        return ((Stack)this.m_cflowStackLocal.get()).size() > 0;
    }

    private static class Cflow_sample
    extends AbstractCflowSystemAspect {
        private static Cflow_sample INSTANCE = null;

        private Cflow_sample() {
        }

        public static boolean isInCflow() {
            if (INSTANCE == null) {
                return false;
            }
            return INSTANCE.inCflow();
        }

        public static Cflow_sample aspectOf() {
            if (INSTANCE == null) {
                INSTANCE = new Cflow_sample();
            }
            return INSTANCE;
        }
    }
}

