/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.aspect.management;

import gnu.trove.TIntObjectHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.AspectContext;
import org.codehaus.aspectwerkz.aspect.AspectContainer;
import org.codehaus.aspectwerkz.aspect.management.NoAspectBoundException;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;
import org.codehaus.aspectwerkz.util.ContextClassLoader;

public class Aspects {
    public static final String DEFAULT_ASPECT_CONTAINER = (class$org$codehaus$aspectwerkz$aspect$DefaultAspectContainerStrategy == null ? (class$org$codehaus$aspectwerkz$aspect$DefaultAspectContainerStrategy = Aspects.class$("org.codehaus.aspectwerkz.aspect.DefaultAspectContainerStrategy")) : class$org$codehaus$aspectwerkz$aspect$DefaultAspectContainerStrategy).getName();
    private static Map ASPECT_CONTAINER_LISTS = new WeakHashMap();
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$aspect$DefaultAspectContainerStrategy;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$AspectContext;

    public static String[] getAspectQNameContainerClassName(ClassLoader visibleFrom, String qName) {
        AspectDefinition aspectDefinition = Aspects.lookupAspectDefinition(visibleFrom, qName);
        return new String[]{aspectDefinition.getQualifiedName(), aspectDefinition.getContainerClassName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AspectContainer getContainerQNamed(ClassLoader visibleFrom, Class containerClass, String qName) {
        Map map = ASPECT_CONTAINER_LISTS;
        synchronized (map) {
            AspectContainer container;
            TIntObjectHashMap containers = (TIntObjectHashMap)ASPECT_CONTAINER_LISTS.get(containerClass);
            if (containers == null) {
                containers = new TIntObjectHashMap();
                ASPECT_CONTAINER_LISTS.put(containerClass, containers);
            }
            if ((container = (AspectContainer)containers.get(CompositeVisibleFromQNameKey.hash(visibleFrom, qName))) == null) {
                container = Aspects.createAspectContainer(visibleFrom, containerClass, qName);
                containers.put(CompositeVisibleFromQNameKey.hash(visibleFrom, qName), (Object)container);
            }
            return container;
        }
    }

    public static Object aspectOf(String qName) {
        return Aspects.aspectOf(Thread.currentThread().getContextClassLoader(), qName);
    }

    public static Object aspectOf(Class aspectClass) {
        String aspectClassName = aspectClass.getName().replace('/', '.');
        return Aspects.aspectOf(aspectClass.getClassLoader(), aspectClassName);
    }

    public static Object aspectOf(ClassLoader visibleFrom, String qName) {
        String[] qNameContainerClassName = Aspects.getAspectQNameContainerClassName(visibleFrom, qName);
        return Aspects.aspect$Of(visibleFrom, qNameContainerClassName[0], qNameContainerClassName[1]);
    }

    public static Object aspectOf(Class aspectClass, Class targetClass) {
        String aspectClassName = aspectClass.getName().replace('/', '.');
        return Aspects.aspectOf(aspectClassName, targetClass);
    }

    public static Object aspectOf(String qName, Class targetClass) {
        String[] qNameContainerClassName = Aspects.getAspectQNameContainerClassName(targetClass.getClassLoader(), qName);
        return Aspects.aspect$Of(qNameContainerClassName[0], qNameContainerClassName[1], targetClass);
    }

    public static Object aspectOf(Class aspectClass, Object targetInstance) {
        String aspectClassName = aspectClass.getName().replace('/', '.');
        return Aspects.aspectOf(aspectClassName, targetInstance);
    }

    public static Object aspectOf(String qName, Object targetInstance) {
        String[] qNameContainerClassName = Aspects.getAspectQNameContainerClassName(targetInstance.getClass().getClassLoader(), qName);
        return Aspects.aspect$Of(qNameContainerClassName[0], qNameContainerClassName[1], targetInstance);
    }

    public static Object aspect$Of(ClassLoader loader, String qName, String containerClassName) {
        try {
            Class containerClass = ContextClassLoader.forName(loader, containerClassName);
            return Aspects.getContainerQNamed(loader, containerClass, qName).aspectOf();
        }
        catch (Throwable t) {
            throw new NoAspectBoundException(t, qName);
        }
    }

    public static Object aspect$Of(String qName, String containerClassName, Class perClass) {
        try {
            ClassLoader loader = perClass.getClassLoader();
            Class containerClass = ContextClassLoader.forName(loader, containerClassName);
            return Aspects.getContainerQNamed(loader, containerClass, qName).aspectOf(perClass);
        }
        catch (Throwable t) {
            throw new NoAspectBoundException(t, qName);
        }
    }

    public static Object aspect$Of(String qName, String containerClassName, Object perInstance) {
        try {
            ClassLoader loader = perInstance.getClass().getClassLoader();
            Class containerClass = ContextClassLoader.forName(loader, containerClassName);
            return Aspects.getContainerQNamed(loader, containerClass, qName).aspectOf(perInstance);
        }
        catch (Throwable t) {
            throw new NoAspectBoundException(t, qName);
        }
    }

    private static AspectContainer createAspectContainer(ClassLoader visibleFrom, Class containerClass, String qName) {
        AspectDefinition aspectDefinition = Aspects.lookupAspectDefinition(visibleFrom, qName);
        Class aspectClass = null;
        try {
            aspectClass = ContextClassLoader.forName(visibleFrom, aspectDefinition.getClassName());
        }
        catch (Throwable t) {
            throw new NoAspectBoundException(t, qName);
        }
        try {
            Constructor constructor = containerClass.getConstructor(class$org$codehaus$aspectwerkz$AspectContext == null ? (class$org$codehaus$aspectwerkz$AspectContext = Aspects.class$("org.codehaus.aspectwerkz.AspectContext")) : class$org$codehaus$aspectwerkz$AspectContext);
            AspectContext aspectContext = new AspectContext(aspectDefinition.getSystemDefinition().getUuid(), aspectClass, aspectDefinition.getName(), aspectDefinition.getDeploymentModel(), aspectDefinition, aspectDefinition.getParameters());
            AspectContainer container = (AspectContainer)constructor.newInstance(aspectContext);
            aspectContext.setContainer(container);
            return container;
        }
        catch (InvocationTargetException e) {
            throw new NoAspectBoundException(e, qName);
        }
        catch (NoSuchMethodException e) {
            throw new NoAspectBoundException("AspectContainer does not have a valid constructor [" + containerClass.getName() + "] need to take an AspectContext instance as its only parameter: " + e.toString(), qName);
        }
        catch (Throwable e) {
            StringBuffer cause = new StringBuffer();
            cause.append("Could not create AspectContainer using the implementation specified [");
            cause.append(containerClass.getName());
            cause.append("] for ").append(qName);
            throw new NoAspectBoundException(e, cause.toString());
        }
    }

    private static AspectDefinition lookupAspectDefinition(ClassLoader visibleFrom, String qName) {
        AspectDefinition aspectDefinition = null;
        Set definitions = SystemDefinitionContainer.getDefinitionsFor(visibleFrom);
        if (qName.indexOf(47) > 0) {
            Iterator iterator = definitions.iterator();
            block0: while (iterator.hasNext()) {
                SystemDefinition systemDefinition = (SystemDefinition)iterator.next();
                Iterator iterator1 = systemDefinition.getAspectDefinitions().iterator();
                while (iterator1.hasNext()) {
                    AspectDefinition aspectDef = (AspectDefinition)iterator1.next();
                    if (!qName.equals(aspectDef.getQualifiedName())) continue;
                    aspectDefinition = aspectDef;
                    continue block0;
                }
            }
        } else {
            int found = 0;
            Iterator iterator = definitions.iterator();
            while (iterator.hasNext()) {
                SystemDefinition systemDefinition = (SystemDefinition)iterator.next();
                Iterator iterator1 = systemDefinition.getAspectDefinitions().iterator();
                while (iterator1.hasNext()) {
                    AspectDefinition aspectDef = (AspectDefinition)iterator1.next();
                    if (!qName.equals(aspectDef.getClassName())) continue;
                    aspectDefinition = aspectDef;
                    ++found;
                }
            }
            if (found > 1) {
                throw new NoAspectBoundException("More than one AspectDefinition found, consider using other API methods", qName);
            }
        }
        if (aspectDefinition == null) {
            throw new NoAspectBoundException("Could not find AspectDefinition", qName);
        }
        return aspectDefinition;
    }

    private Aspects() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CompositeVisibleFromQNameKey {
        private CompositeVisibleFromQNameKey() {
        }

        public static int hash(ClassLoader loader, String qName) {
            int result = loader != null ? loader.hashCode() : 0;
            result = 29 * result + qName.hashCode();
            return result;
        }
    }
}

