/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.aspectwerkz.annotation.Annotation;
import org.codehaus.aspectwerkz.annotation.instrumentation.asm.AsmAnnotations;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ConstructorInfo;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.ReflectHelper;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;

public final class Annotations {
    private static final List EMPTY_LIST = new ArrayList();

    public static Annotation getAnnotation(String annotationName, Class klass) {
        ClassInfo classInfo = AsmClassInfo.getClassInfo(klass.getName(), klass.getClassLoader());
        return AsmAnnotations.getAnnotation(annotationName, classInfo);
    }

    public static Annotation getAnnotation(Class annotation, Class klass) {
        return Annotations.getAnnotation(Annotations.getAnnnotationName(annotation), klass);
    }

    public static Annotation getAnnotation(String annotationName, Method method) {
        ClassLoader loader = method.getDeclaringClass().getClassLoader();
        ClassInfo classInfo = AsmClassInfo.getClassInfo(method.getDeclaringClass().getName(), loader);
        MethodInfo methodInfo = classInfo.getMethod(ReflectHelper.calculateHash(method));
        return AsmAnnotations.getAnnotation(annotationName, methodInfo);
    }

    public static Annotation getAnnotation(Class annotation, Method method) {
        return Annotations.getAnnotation(Annotations.getAnnnotationName(annotation), method);
    }

    public static Annotation getAnnotation(String annotationName, Constructor constructor) {
        ClassLoader loader = constructor.getDeclaringClass().getClassLoader();
        ClassInfo classInfo = AsmClassInfo.getClassInfo(constructor.getDeclaringClass().getName(), loader);
        ConstructorInfo constructorInfo = classInfo.getConstructor(ReflectHelper.calculateHash(constructor));
        return AsmAnnotations.getAnnotation(annotationName, constructorInfo);
    }

    public static Annotation getAnnotation(Class annotation, Constructor constructor) {
        return Annotations.getAnnotation(Annotations.getAnnnotationName(annotation), constructor);
    }

    public static Annotation getAnnotation(String annotationName, Field field) {
        ClassLoader loader = field.getDeclaringClass().getClassLoader();
        ClassInfo classInfo = AsmClassInfo.getClassInfo(field.getDeclaringClass().getName(), loader);
        FieldInfo fieldInfo = classInfo.getField(ReflectHelper.calculateHash(field));
        return AsmAnnotations.getAnnotation(annotationName, fieldInfo);
    }

    public static Annotation getAnnotation(Class annotation, Field field) {
        return Annotations.getAnnotation(Annotations.getAnnnotationName(annotation), field);
    }

    public static List getAnnotations(String annotationName, Class klass) {
        ClassInfo classInfo = AsmClassInfo.getClassInfo(klass.getName(), klass.getClassLoader());
        return AsmAnnotations.getAnnotations(annotationName, classInfo);
    }

    public static List getAnnotations(Class annotation, Class klass) {
        return Annotations.getAnnotations(Annotations.getAnnnotationName(annotation), klass);
    }

    public static List getAnnotations(String annotationName, Method method) {
        ClassLoader loader = method.getDeclaringClass().getClassLoader();
        ClassInfo classInfo = AsmClassInfo.getClassInfo(method.getDeclaringClass().getName(), loader);
        MethodInfo methodInfo = classInfo.getMethod(ReflectHelper.calculateHash(method));
        return AsmAnnotations.getAnnotations(annotationName, methodInfo);
    }

    public static List getAnnotations(Class annotation, Method method) {
        return Annotations.getAnnotations(Annotations.getAnnnotationName(annotation), method);
    }

    public static List getAnnotations(String annotationName, Constructor constructor) {
        ClassLoader loader = constructor.getDeclaringClass().getClassLoader();
        ClassInfo classInfo = AsmClassInfo.getClassInfo(constructor.getDeclaringClass().getName(), loader);
        ConstructorInfo constructorInfo = classInfo.getConstructor(ReflectHelper.calculateHash(constructor));
        return AsmAnnotations.getAnnotations(annotationName, constructorInfo);
    }

    public static List getAnnotations(Class annotation, Constructor constructor) {
        return Annotations.getAnnotations(Annotations.getAnnnotationName(annotation), constructor);
    }

    public static List getAnnotations(String annotationName, Field field) {
        ClassLoader loader = field.getDeclaringClass().getClassLoader();
        ClassInfo classInfo = AsmClassInfo.getClassInfo(field.getDeclaringClass().getName(), loader);
        FieldInfo fieldInfo = classInfo.getField(ReflectHelper.calculateHash(field));
        return AsmAnnotations.getAnnotations(annotationName, fieldInfo);
    }

    public static List getAnnotations(Class annotation, Field field) {
        return Annotations.getAnnotations(Annotations.getAnnnotationName(annotation), field);
    }

    public static List getAnnotationInfos(Class klass) {
        return AsmClassInfo.getClassInfo(klass.getName(), klass.getClassLoader()).getAnnotations();
    }

    public static List getAnnotationInfos(Method method) {
        ClassLoader loader = method.getDeclaringClass().getClassLoader();
        ClassInfo classInfo = AsmClassInfo.getClassInfo(method.getDeclaringClass().getName(), loader);
        MethodInfo methodInfo = classInfo.getMethod(ReflectHelper.calculateHash(method));
        if (methodInfo != null) {
            return methodInfo.getAnnotations();
        }
        return EMPTY_LIST;
    }

    public static List getAnnotationInfos(Constructor constructor) {
        ClassLoader loader = constructor.getDeclaringClass().getClassLoader();
        ClassInfo classInfo = AsmClassInfo.getClassInfo(constructor.getDeclaringClass().getName(), loader);
        return classInfo.getConstructor(ReflectHelper.calculateHash(constructor)).getAnnotations();
    }

    public static List getAnnotationInfos(Field field) {
        ClassLoader loader = field.getDeclaringClass().getClassLoader();
        ClassInfo classInfo = AsmClassInfo.getClassInfo(field.getDeclaringClass().getName(), loader);
        FieldInfo fieldInfo = classInfo.getField(ReflectHelper.calculateHash(field));
        if (fieldInfo != null) {
            return fieldInfo.getAnnotations();
        }
        return EMPTY_LIST;
    }

    private static String getAnnnotationName(Class annotation) {
        return annotation.getName().replace('/', '.');
    }
}

