/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.annotation;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.aspectwerkz.annotation.Annotation;
import org.codehaus.aspectwerkz.annotation.Java14AnnotationInvocationHander;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.util.Strings;

public class AnnotationManager {
    private static final String JAVA_LANG_OBJECT_CLASS_NAME = "java.lang.Object";
    private final JavaDocBuilder m_parser = new JavaDocBuilder();
    private final Map m_registeredAnnotations = new HashMap();
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$Annotation;

    public AnnotationManager(ClassLoader loader) {
        this.m_parser.getClassLibrary().addClassLoader(loader);
    }

    public void addSourceTrees(String[] srcDirs) {
        for (int i = 0; i < srcDirs.length; ++i) {
            this.m_parser.addSourceTree(new File(srcDirs[i]));
        }
    }

    public void addSource(String srcFile) {
        try {
            this.m_parser.addSource(new File(srcFile));
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public void registerAnnotationProxy(Class proxyClass, String docletName) {
        this.m_registeredAnnotations.put(docletName, proxyClass);
    }

    public JavaClass[] getAllClasses() {
        Collection classes = this.m_parser.getClassLibrary().all();
        ArrayList<JavaClass> javaClasses = new ArrayList<JavaClass>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            if (JAVA_LANG_OBJECT_CLASS_NAME.equals(className)) continue;
            JavaClass clazz = this.m_parser.getClassByName(className);
            javaClasses.add(clazz);
        }
        return javaClasses.toArray(new JavaClass[0]);
    }

    public Annotation[] getAnnotations(String name, JavaClass clazz) {
        DocletTag[] tags = clazz.getTags();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < tags.length; ++i) {
            DocletTag tag = tags[i];
            RawAnnotation rawAnnotation = this.getRawAnnotation(name, tag);
            if (rawAnnotation == null) continue;
            annotations.add(this.instantiateAnnotation(rawAnnotation));
        }
        return annotations.toArray(new Annotation[0]);
    }

    public Annotation[] getAnnotations(String name, JavaMethod method) {
        DocletTag[] tags = method.getTags();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < tags.length; ++i) {
            DocletTag tag = tags[i];
            RawAnnotation rawAnnotation = this.getRawAnnotation(name, tag);
            if (rawAnnotation == null) continue;
            annotations.add(this.instantiateAnnotation(rawAnnotation));
        }
        return annotations.toArray(new Annotation[0]);
    }

    public Annotation[] getAnnotations(String name, JavaField field) {
        DocletTag[] tags = field.getTags();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < tags.length; ++i) {
            DocletTag tag = tags[i];
            RawAnnotation rawAnnotation = this.getRawAnnotation(name, tag);
            if (rawAnnotation == null) continue;
            annotations.add(this.instantiateAnnotation(rawAnnotation));
        }
        return annotations.toArray(new Annotation[0]);
    }

    private Annotation instantiateAnnotation(RawAnnotation rawAnnotation) {
        Class proxyClass = (Class)this.m_registeredAnnotations.get(rawAnnotation.name);
        if (!proxyClass.isInterface()) {
            throw new RuntimeException("Annotation class is not defined as an interface for " + rawAnnotation.name + ". Use of AspectWerkz 1.x Annotation proxies is not anymore supported.");
        }
        try {
            Java14AnnotationInvocationHander handler = new Java14AnnotationInvocationHander(proxyClass, rawAnnotation.name, rawAnnotation.value);
            Object annotationProxy = Proxy.newProxyInstance(proxyClass.getClassLoader(), new Class[]{class$org$codehaus$aspectwerkz$annotation$Annotation == null ? (class$org$codehaus$aspectwerkz$annotation$Annotation = AnnotationManager.class$("org.codehaus.aspectwerkz.annotation.Annotation")) : class$org$codehaus$aspectwerkz$annotation$Annotation, proxyClass}, (InvocationHandler)handler);
            return (Annotation)annotationProxy;
        }
        catch (Throwable e) {
            throw new DefinitionException("Unable to parse annotation @" + rawAnnotation.name + '(' + " " + rawAnnotation.value + ')', e);
        }
    }

    public static Annotation instantiateNestedAnnotation(Class annotationClass, Map elements) {
        if (!annotationClass.isInterface()) {
            throw new RuntimeException("Annotation class is not defined as an interface for " + annotationClass.getName() + ". Use of AspectWerkz 1.x Annotation proxies is not anymore supported.");
        }
        try {
            Java14AnnotationInvocationHander handler = new Java14AnnotationInvocationHander(annotationClass, elements);
            Object annotationProxy = Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{class$org$codehaus$aspectwerkz$annotation$Annotation == null ? (class$org$codehaus$aspectwerkz$annotation$Annotation = AnnotationManager.class$("org.codehaus.aspectwerkz.annotation.Annotation")) : class$org$codehaus$aspectwerkz$annotation$Annotation, annotationClass}, (InvocationHandler)handler);
            return (Annotation)annotationProxy;
        }
        catch (Throwable e) {
            throw new DefinitionException("Unable to parse nested annotation @" + annotationClass.getName(), e);
        }
    }

    private RawAnnotation getRawAnnotation(String annotationName, DocletTag tag) {
        String asIs = tag.getName() + " " + tag.getValue();
        asIs = asIs.trim();
        Strings.removeFormattingCharacters(asIs);
        if (!asIs.startsWith(annotationName)) {
            return null;
        }
        String name = null;
        String value = null;
        if (asIs.indexOf(32) > 0) {
            name = asIs.substring(0, asIs.indexOf(32));
        }
        if (annotationName.equals(name)) {
            value = asIs.substring(asIs.indexOf(32) + 1, asIs.length());
            if (value.startsWith("(") && value.endsWith(")")) {
                value = value.length() > 2 ? value.substring(1, value.length() - 1) : "";
            }
        } else {
            if (asIs.indexOf(40) > 0) {
                name = asIs.substring(0, asIs.indexOf(40));
            }
            if (annotationName.equals(name)) {
                value = asIs.substring(asIs.indexOf(40) + 1, asIs.length());
                if (value.endsWith(")")) {
                    value = value.length() > 1 ? value.substring(0, value.length() - 1) : "";
                }
            } else if (annotationName.equals(asIs)) {
                value = "";
            }
        }
        if (value != null) {
            RawAnnotation annotation = new RawAnnotation();
            annotation.name = annotationName;
            annotation.value = value;
            return annotation;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RawAnnotation
    implements Serializable {
        String name;
        String value;

        private RawAnnotation() {
        }
    }
}

