/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.grammar.util;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.BinaryExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceContainer;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.ValueExp;
import java.util.Iterator;

public class ExpressionPrinter
implements ExpressionVisitor {
    public static final int FRAGMENT = 1;
    public static final int CONTENTMODEL = 2;
    public static ExpressionPrinter fragmentInstance = new ExpressionPrinter(1);
    public static ExpressionPrinter contentModelInstance = new ExpressionPrinter(2);
    public static ExpressionPrinter smallestInstance = new ExpressionPrinter(3);
    protected final int mode;

    public static String printFragment(Expression expression) {
        return (String)expression.visit(fragmentInstance);
    }

    public static String printContentModel(Expression expression) {
        return (String)expression.visit(contentModelInstance);
    }

    public static String printSmallest(Expression expression) {
        return (String)expression.visit(smallestInstance);
    }

    protected ExpressionPrinter(int n) {
        this.mode = n;
    }

    public String printRefContainer(ReferenceContainer referenceContainer) {
        String string = "";
        Iterator iterator = referenceContainer.iterator();
        while (iterator.hasNext()) {
            ReferenceExp referenceExp = (ReferenceExp)iterator.next();
            string = string + referenceExp.name + "  : " + referenceExp.exp.visit(this) + "\n";
        }
        return string;
    }

    protected static boolean isComplex(Expression expression) {
        return expression instanceof BinaryExp;
    }

    protected String printBinary(BinaryExp binaryExp, String string) {
        String string2 = binaryExp.exp1.getClass() == binaryExp.getClass() || !ExpressionPrinter.isComplex(binaryExp.exp1) ? (String)binaryExp.exp1.visit(this) : "(" + binaryExp.exp1.visit(this) + ")";
        string2 = string2 + string;
        string2 = !ExpressionPrinter.isComplex(binaryExp.exp2) ? string2 + binaryExp.exp2.visit(this) : string2 + "(" + binaryExp.exp2.visit(this) + ")";
        return string2;
    }

    public Object onAttribute(AttributeExp attributeExp) {
        return "@" + attributeExp.nameClass.toString() + "<" + attributeExp.exp.visit(this) + ">";
    }

    private Object optional(Expression expression) {
        if (expression instanceof OneOrMoreExp) {
            OneOrMoreExp oneOrMoreExp = (OneOrMoreExp)expression;
            if (ExpressionPrinter.isComplex(oneOrMoreExp.exp)) {
                return "(" + oneOrMoreExp.exp.visit(this) + ")*";
            }
            return oneOrMoreExp.exp.visit(this) + "*";
        }
        if (ExpressionPrinter.isComplex(expression)) {
            return "(" + expression.visit(this) + ")?";
        }
        return expression.visit(this) + "?";
    }

    public Object onChoice(ChoiceExp choiceExp) {
        if (choiceExp.exp1 == Expression.epsilon) {
            return this.optional(choiceExp.exp2);
        }
        if (choiceExp.exp2 == Expression.epsilon) {
            return this.optional(choiceExp.exp1);
        }
        return this.printBinary(choiceExp, "|");
    }

    public Object onConcur(ConcurExp concurExp) {
        return this.printBinary(concurExp, "&");
    }

    public Object onInterleave(InterleaveExp interleaveExp) {
        return this.printBinary(interleaveExp, "^");
    }

    public Object onElement(ElementExp elementExp) {
        if ((this.mode & 2) != 0) {
            return elementExp.getNameClass().toString();
        }
        return elementExp.getNameClass().toString() + "<" + elementExp.contentModel.visit(this) + ">";
    }

    public Object onOneOrMore(OneOrMoreExp oneOrMoreExp) {
        if (ExpressionPrinter.isComplex(oneOrMoreExp.exp)) {
            return "(" + oneOrMoreExp.exp.visit(this) + ")+";
        }
        return oneOrMoreExp.exp.visit(this) + "+";
    }

    public Object onMixed(MixedExp mixedExp) {
        return "mixed[" + mixedExp.exp.visit(this) + "]";
    }

    public Object onList(ListExp listExp) {
        return "list[" + listExp.exp.visit(this) + "]";
    }

    public Object onEpsilon() {
        return "#epsilon";
    }

    public Object onNullSet() {
        return "#nullSet";
    }

    public Object onAnyString() {
        return "<anyString>";
    }

    public Object onSequence(SequenceExp sequenceExp) {
        return this.printBinary(sequenceExp, ",");
    }

    public Object onData(DataExp dataExp) {
        return "$" + dataExp.name.localName;
    }

    public Object onValue(ValueExp valueExp) {
        return "$$" + valueExp.value;
    }

    public Object onOther(OtherExp otherExp) {
        return otherExp.printName() + "[" + otherExp.exp.visit(this) + "]";
    }

    public Object onRef(ReferenceExp referenceExp) {
        if ((this.mode & 1) != 0) {
            return "{%" + referenceExp.name + "}";
        }
        return "(" + referenceExp.exp.visit(this) + ")";
    }
}

