/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.helpers;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.VradiComparators;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ToolTipHelper {
    private static final Log log = LogFactory.getLog(ToolTipHelper.class);
    public static final int TOOLTIP_ELEMENT_MAX_CHAR_NB = 500;

    public static String getToolTip(List<Form> forms) {
        if (forms == null || forms.isEmpty()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        result.append("<html>");
        int size = forms.size();
        for (int i = 0; i < size && i < 15; ++i) {
            Form form = forms.get(i);
            result.append("- ").append(form.getObjet()).append("<br/>");
        }
        result.append("</html>");
        return result.toString();
    }

    public static String getToolTip(Form form) {
        String[] infogeneFields;
        String[] formFields;
        if (form == null) {
            return null;
        }
        LinkedHashMap<String, Object> fieldValues = new LinkedHashMap<String, Object>();
        for (String fieldName : formFields = new String[]{"datePub", "datePeremption"}) {
            fieldValues.put(fieldName, form.getField("Form", fieldName));
        }
        for (String fieldName : infogeneFields = new String[]{"id", "objet", "entity", "sourceText", "description"}) {
            fieldValues.put(fieldName, form.getField("Infogene", fieldName));
        }
        Collection extensionNames = form.getExtensionNames();
        for (String extensionName : extensionNames) {
            if ("Form".equals(extensionName) || "Infogene".equals(extensionName)) continue;
            Collection fieldNames = form.getExtensionFields(extensionName);
            for (String fieldName : fieldNames) {
                fieldValues.put(fieldName, form.getField(extensionName, fieldName));
            }
        }
        StringBuffer result = new StringBuffer();
        result.append("<html>");
        for (Map.Entry entry : fieldValues.entrySet()) {
            Object value = entry.getValue();
            String key = (String)entry.getKey();
            if (value == null) continue;
            String stringValue = null;
            if (value instanceof Date) {
                stringValue = DateFormat.getDateTimeInstance(3, 2, Locale.FRANCE).format((Date)value);
            } else {
                stringValue = String.valueOf(value);
                stringValue = StringUtils.replace((String)stringValue, (String)"\r", (String)"");
                stringValue = StringUtils.replace((String)stringValue, (String)"\n\n", (String)"\n");
                stringValue = StringUtils.abbreviate((String)stringValue, (int)500);
                stringValue = StringUtils.replace((String)stringValue, (String)"\n", (String)"<br/>");
            }
            result.append("<strong>").append(key).append("</strong>").append(" : ").append(stringValue).append("<br/>");
        }
        result.append("</html>");
        return result.toString();
    }

    public static String getThesaurusToolTip(Form form) {
        if (form == null) {
            return null;
        }
        Set<String> thesaurusIds = form.getThesaurus();
        if (thesaurusIds == null) {
            return null;
        }
        VradiThesaurusDTO rootThesaurus = VradiContext.getThesaurusInEntryDef();
        ArrayList<VradiThesaurusDTO> thesauruss = new ArrayList<VradiThesaurusDTO>();
        for (String id : thesaurusIds) {
            VradiThesaurusDTO thesaurusFind = rootThesaurus.findThesaurus(id);
            if (thesaurusFind != null) {
                thesauruss.add(thesaurusFind);
                continue;
            }
            log.warn((Object)("Thesaurus not found : " + id));
        }
        StringBuffer result = new StringBuffer();
        result.append("<html><h3>");
        result.append(I18n._((String)"vradi.email.thesaurusToolTipTitle"));
        result.append("</h3><br/>");
        Collections.sort(thesauruss, VradiComparators.THESAURUS_NAME_PATH_COMPARATOR);
        for (VradiThesaurusDTO thesaurus : thesauruss) {
            result.append("<strong>").append(thesaurus.getNamePath("/")).append("\n</strong>").append("<br/>");
        }
        result.append("</html>");
        return result.toString();
    }
}

