/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.VradiService;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.RequestFormViewHandler;
import com.jurismarches.vradi.ui.RequestFormViewUI;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.ThesaurusUI;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.VradiTask;
import com.jurismarches.vradi.ui.editors.CurrencyEditor;
import com.jurismarches.vradi.ui.editors.DateEditor;
import com.jurismarches.vradi.ui.editors.DateTimeEditor;
import com.jurismarches.vradi.ui.editors.EmailEditor;
import com.jurismarches.vradi.ui.editors.NumEditor;
import com.jurismarches.vradi.ui.editors.StringEditor;
import com.jurismarches.vradi.ui.editors.TextEditor;
import com.jurismarches.vradi.ui.editors.UrlEditor;
import com.jurismarches.vradi.ui.editors.VradiEditor;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;

public class OfferEditHandler {
    private static final Log log = LogFactory.getLog(OfferEditHandler.class);
    private static final String DEFAULT_EDITOR_NAME = "$default";
    public static final String REQUIRED_FIELD_CONTEXT = "required";
    private VradiStorageService vradiStorageService = null;
    protected static Map<String, Class<? extends VradiEditor<?, ?>>> editorMapping;

    protected VradiStorageService getVradiStorageService() {
        if (this.vradiStorageService == null) {
            this.vradiStorageService = VradiService.getVradiStorageService();
        }
        return this.vradiStorageService;
    }

    public OfferEditUI initUI(JAXXContext rootContext, Form data) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
        context.add((Object)data);
        UIHelper.getHandler((JAXXContext)context, ThesaurusHandler.class);
        OfferEditUI ui = new OfferEditUI((JAXXContext)context);
        this.fillfields(ui, data);
        ArrayList editUIs = (ArrayList)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        if (editUIs == null) {
            editUIs = new ArrayList();
            VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), editUIs);
        }
        ((List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).add(ui);
        DefaultListModel fileModel = ui.getFileListModel();
        if (data != null && data.getFiles() != null) {
            for (String fileName : data.getFiles()) {
                fileModel.addElement(fileName);
            }
        }
        DefaultListModel attachmentModel = ui.getAttachmentListModel();
        if (data != null && data.getAttachments() != null) {
            for (String attachmentName : data.getAttachments()) {
                attachmentModel.addElement(attachmentName);
            }
        }
        try {
            List thesaurusToPropose = this.getVradiStorageService().proposeThesaurus(data, VradiContext.getTreeNodeInEntryDef());
            this.addPropositions((JAXXContext)ui, thesaurusToPropose.toArray(new TreeNodeImpl[thesaurusToPropose.size()]));
        }
        catch (VradiException eee) {
            log.error((Object)"Cant get propositions of thesaurus ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        ThesaurusHandler thesaurusHandler = UIHelper.getHandler((JAXXContext)context, ThesaurusHandler.class);
        thesaurusHandler.initThesaurus((JAXXContext)context, ui);
        if (log.isDebugEnabled()) {
            log.debug((Object)("There is " + ((List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).size() + " OfferEditUI in referenciel"));
        }
        return ui;
    }

    public void fillfields(OfferEditUI ui, Form form) {
        Collection extensions = form.getExtensionNames();
        for (String extensionName : extensions) {
            if (extensionName.equals("ModificationTag") || extensionName.equals("Infogene") || extensionName.equals("Form")) continue;
            BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty)form;
            WikittyExtension extension = entityWikitty.getWikitty().getExtension(extensionName);
            Collection fieldNames = extension.getFieldNames();
            for (String fieldName : fieldNames) {
                this.createField(ui, extension, fieldName, form);
            }
        }
    }

    protected void createField(OfferEditUI ui, WikittyExtension extension, String fieldName, BusinessEntity data) {
        VradiEditor editor;
        JPanel content = ui.getContent();
        FieldType fieldType = extension.getFieldType(fieldName);
        if (!fieldType.isCollection() && (editor = this.getEditor(fieldType, (JAXXContext)ui)) != null) {
            String extensionName = extension.getName();
            Object value = data.getField(extensionName, fieldName);
            editor.setFieldName(fieldName);
            String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
            editor.setFieldDescription(fieldDesc);
            editor.setExtensionName(extensionName);
            editor.setExtensionFieldName(fieldName);
            editor.setValue(value);
            if (fieldType.isNotNull()) {
                editor.setValidatorContext(REQUIRED_FIELD_CONTEXT);
            }
            content.add(editor);
        }
    }

    OfferEditUI getUI(JAXXContext context) {
        if (context instanceof OfferEditUI) {
            return (OfferEditUI)context;
        }
        return null;
    }

    protected void addPropositions(JAXXContext context, TreeNodeImpl[] props) {
        OfferEditUI ui = this.getUI(context);
        DefaultListModel propositionListModel = ui.propositionListModel;
        propositionListModel.removeAllElements();
        for (TreeNodeImpl p : props) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add proposition element : " + p));
            }
            VradiThesaurusDTO thesaurus = UIHelper.getHandler(context, ThesaurusHandler.class).findThesaurusInRef(p.getWikittyId());
            propositionListModel.addElement(thesaurus);
        }
    }

    protected void save(JAXXContext context, Form form) {
        log.info((Object)("Saving Form: " + form.getWikittyId()));
        try {
            VradiUser vradiUser;
            Component[] components;
            OfferEditUI offerEditUI = this.getUI(context);
            Set<String> listThesaurus = form.getThesaurus();
            ThesaurusHandler thesaurusHandler = UIHelper.getHandler(context, ThesaurusHandler.class);
            if (listThesaurus != null) {
                for (String id : listThesaurus) {
                    VradiThesaurusDTO thesaurus = thesaurusHandler.findThesaurusInRef(id);
                    if (thesaurus == null) continue;
                    thesaurus.decFormsForThesaurus();
                }
            }
            form.clearThesaurus();
            for (Object s : offerEditUI.getPropositionList().getSelectedValues()) {
                VradiThesaurusDTO selected = (VradiThesaurusDTO)s;
                form.addThesaurus(selected.getWikittyId());
                selected.incFormsForThesaurus();
            }
            for (Component c : offerEditUI.getThesaurus().getComponents()) {
                Object[] selected;
                ThesaurusUI thesaurusUI = (ThesaurusUI)((Object)c);
                DefaultListModel model = thesaurusUI.getThesaurusSelectedModel();
                for (Object s : selected = model.toArray()) {
                    VradiThesaurusDTO thesaurus = (VradiThesaurusDTO)s;
                    form.addThesaurus(thesaurus.getWikittyId());
                    if (thesaurus == null) continue;
                    thesaurus.incFormsForThesaurus();
                }
            }
            JPanel content = offerEditUI.getContent();
            for (Component c : components = content.getComponents()) {
                VradiEditor editor = (VradiEditor)c;
                this.updateFormField(editor, form);
            }
            this.updateFormField(offerEditUI.getObjetEditor(), form);
            this.updateFormField(offerEditUI.getIdEditor(), form);
            this.updateFormField(offerEditUI.getSourceTextEditor(), form);
            this.updateFormField(offerEditUI.getSourceURLEditor(), form);
            this.updateFormField(offerEditUI.getEntityEditor(), form);
            this.updateFormField(offerEditUI.getCountryEditor(), form);
            this.updateFormField(offerEditUI.getDepartmentEditor(), form);
            this.updateFormField(offerEditUI.getDatePubEditor(), form);
            this.updateFormField(offerEditUI.getDatePeremeptionEditor(), form);
            this.updateFormField(offerEditUI.getDescriptionEditor(), form);
            if (!form.getExtensionNames().contains("ModificationTag")) {
                BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty)form;
                entityWikitty.getWikitty().addExtension(ModificationTag.EXTENSION_MODIFICATION_TAG);
            }
            form.setField("ModificationTag", "lastModifier", (vradiUser = (VradiUser)context.getContextValue(VradiUser.class)) != null ? vradiUser.getName() : null);
            form.setField("ModificationTag", "lastModified", new Date());
            this.getVradiStorageService().uploadFiles(form, (List)offerEditUI.getFilesToUpload());
            this.getVradiStorageService().uploadAttachments(form, (List)offerEditUI.getAttachmentsToUpload());
            this.getVradiStorageService().updateForm(form);
        }
        catch (Exception eee) {
            log.error((Object)("Cant save form : " + form.getObjet()), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
    }

    void updateFormField(VradiEditor editor, Form form) {
        String extensionName = editor.getExtensionName();
        String extensionFieldName = editor.getExtensionFieldName();
        Object value = editor.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating: " + extensionName + "." + extensionFieldName + "=" + value));
        }
        form.setField(extensionName, extensionFieldName, value);
    }

    protected void update(JAXXContext context) {
        VradiMainUIHandler rootHandler = (VradiMainUIHandler)VradiContext.get().getContextValue(VradiMainUIHandler.class);
        rootHandler.goToHome(context);
    }

    protected void findQueries(JAXXContext context) {
        OfferEditUI ui = this.getUI(context);
        Form form = ui.getData();
        try {
            Map queries = this.getVradiStorageService().findQueriesReturningForm(form);
            RequestFormViewHandler handler = UIHelper.getHandler(context, RequestFormViewHandler.class);
            RequestFormViewUI requestFormViewUI = handler.initUI(context, queries);
            requestFormViewUI.setVisible(true);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
    }

    public void viewInPDF(JAXXContext context) {
        final OfferEditUI ui = this.getUI(context);
        final Form form = ui.getData();
        VradiTask<File> generatePDF = new VradiTask<File>(context, false){

            @Override
            public File doAction() throws Exception {
                return VradiHelper.generatePDF(OfferEditHandler.this.getVradiStorageService(), form);
            }

            @Override
            public void doWhenDone() throws Exception {
                File file = (File)this.get();
                if (file == null) {
                    JOptionPane.showMessageDialog(ui, I18n._((String)"vradi.offerEdit.cantGeneratePDF"), I18n._((String)"vradi.offerEdit.cantGeneratePDFTitle"), 0);
                    return;
                }
                Desktop.getDesktop().open(file);
            }
        };
        generatePDF.execute();
    }

    public void addFile(JAXXContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"addFile(context)");
        }
        FileFilter imageFileFilter = new FileFilter(){
            private final String[] okFileExtensions = new String[]{"jpg", "jpeg", "png", "gif"};

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                for (String extension : this.okFileExtensions) {
                    if (!file.getName().toLowerCase().endsWith(extension)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Images(.jpg, .jpeg, .png, .gif)";
            }
        };
        File file = FileUtil.getFile((Component)this.getUI(context), (FileFilter[])new FileFilter[]{imageFileFilter});
        if (file != null) {
            this.getUI(context).getFilesToUpload().add(file);
            DefaultListModel model = this.getUI(context).getFileListModel();
            model.addElement(file.getName());
            this.getUI(context).getData().addFiles(file.getName());
        }
    }

    public void removeFile(JAXXContext context) {
        int fileIndex = this.getUI(context).getFileList().getSelectedIndex();
        if (fileIndex >= 0) {
            DefaultListModel model = this.getUI(context).getFileListModel();
            String fileName = (String)model.remove(fileIndex);
            this.getUI(context).getData().removeFiles(fileName);
        }
    }

    public void addAttachment(JAXXContext context) {
        File attachment;
        if (log.isDebugEnabled()) {
            log.debug((Object)"addAttachment(context)");
        }
        if ((attachment = FileUtil.getFile((Component)this.getUI(context), (FileFilter[])new FileFilter[0])) != null) {
            this.getUI(context).getAttachmentsToUpload().add(attachment);
            DefaultListModel model = this.getUI(context).getAttachmentListModel();
            model.addElement(attachment.getName());
            this.getUI(context).getData().addAttachments(attachment.getName());
        }
    }

    public void removeAttachment(JAXXContext context) {
        int attachmentIndex = this.getUI(context).getAttachmentList().getSelectedIndex();
        if (attachmentIndex >= 0) {
            DefaultListModel model = this.getUI(context).getAttachmentListModel();
            String attachmentName = (String)model.remove(attachmentIndex);
            this.getUI(context).getData().removeAttachments(attachmentName);
        }
    }

    protected synchronized VradiEditor getEditor(FieldType type, JAXXContext context) {
        String editorName;
        if (editorMapping == null) {
            editorMapping = new TreeMap();
            editorMapping.put(FieldTypeEnum.STRING.name(), StringEditor.class);
            editorMapping.put(FieldTypeEnum.DATE_TIME.name(), DateTimeEditor.class);
            editorMapping.put(FieldTypeEnum.DATE.name(), DateEditor.class);
            editorMapping.put(FieldTypeEnum.EMAIL.name(), EmailEditor.class);
            editorMapping.put(FieldTypeEnum.NUMERIC.name(), NumEditor.class);
            editorMapping.put(FieldTypeEnum.TEXT.name(), TextEditor.class);
            editorMapping.put(FieldTypeEnum.URL.name(), UrlEditor.class);
            editorMapping.put(FieldTypeEnum.CURRENCY.name(), CurrencyEditor.class);
            editorMapping.put(DEFAULT_EDITOR_NAME, StringEditor.class);
        }
        FieldTypeEnum typeEnum = FieldTypeEnum.valueOf(type);
        if (log.isDebugEnabled()) {
            log.debug((Object)("typeEnum of type " + type + " = " + (Object)((Object)typeEnum)));
        }
        String string = editorName = typeEnum == null ? DEFAULT_EDITOR_NAME : typeEnum.name();
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor name for type [" + type.getType() + "] : " + editorName));
        }
        Class<VradiEditor<?, ?>> editorClass = editorMapping.get(editorName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor class to use : " + editorClass));
        }
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = editorClass.getConstructors()) {
                if (constructor.getParameterTypes() == null || constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].equals(JAXXContext.class)) continue;
                VradiEditor editor = (VradiEditor)constructor.newInstance(context);
                editor.init();
                return editor;
            }
            return null;
        }
        catch (Exception eee) {
            throw new IllegalStateException(eee);
        }
    }

    public void changeStatusAndSave(JAXXContext context, Form form, Status status) {
        String intialStatus = form.getStatus();
        String updateStatus = status.getWikittyId();
        if (intialStatus == null || !updateStatus.equals(intialStatus)) {
            VradiUser vradiUser;
            if (!form.getExtensionNames().contains("ModificationTag")) {
                BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty)form;
                entityWikitty.getWikitty().addExtension(ModificationTag.EXTENSION_MODIFICATION_TAG);
            }
            String statusModifier = (vradiUser = (VradiUser)context.getContextValue(VradiUser.class)) != null ? vradiUser.getName() : null;
            log.info((Object)String.format("Updating: statusModifier=%s on form: %s", statusModifier, form.getWikittyId()));
            log.info((Object)String.format("New Status: %s, Old Status: %s", intialStatus, updateStatus));
            form.setField("ModificationTag", "lastStatusModifier", statusModifier);
            form.setField("ModificationTag", "lastModifier", statusModifier);
        }
        form.setStatus(updateStatus);
        this.save(context, form);
    }

    public void resizeMe(OfferEditUI ui) {
    }
}

