/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.entities.ClientImpl;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.GroupFormsImpl;
import com.jurismarches.vradi.entities.GroupImpl;
import com.jurismarches.vradi.entities.InfogeneImpl;
import com.jurismarches.vradi.entities.ModificationTagImpl;
import com.jurismarches.vradi.entities.QueryMakerImpl;
import com.jurismarches.vradi.entities.RootThesaurusImpl;
import com.jurismarches.vradi.entities.SendingImpl;
import com.jurismarches.vradi.entities.SessionImpl;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.ThesaurusImpl;
import com.jurismarches.vradi.entities.UserImpl;
import com.jurismarches.vradi.entities.VradiUserImpl;
import com.jurismarches.vradi.entities.WebHarvestStreamImpl;
import com.jurismarches.vradi.entities.XmlFieldBindingImpl;
import com.jurismarches.vradi.entities.XmlStreamImpl;
import com.jurismarches.vradi.services.ServiceMigration;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.VradiStorageServiceImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.LocaleConverter;
import org.nuiton.util.converter.ConverterUtil;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyExtensionStorage;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittySearchEngin;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceCached;
import org.nuiton.wikitty.WikittyServiceImpl;
import org.nuiton.wikitty.WikittyServiceNotifier;
import org.nuiton.wikitty.WikittyStorage;
import org.nuiton.wikitty.WikittyTreeNodeImpl;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.jdbc.WikittyExtensionStorageJDBC;
import org.nuiton.wikitty.jdbc.WikittyStorageJDBC;
import org.nuiton.wikitty.solr.WikittySearchEnginSolr;

public class ServiceFactory {
    private static final Log log = LogFactory.getLog(ServiceFactory.class);
    protected static WikittyService vradiWikittyService;
    protected static VradiStorageService vradiStorageService;
    protected static WikittyProxy wikittyProxy;

    public static synchronized VradiStorageService getVradiStorageService() {
        if (vradiStorageService == null) {
            vradiStorageService = new VradiStorageServiceImpl();
        }
        return vradiStorageService;
    }

    public static synchronized WikittyService getWikittyService() {
        if (vradiWikittyService == null) {
            VradiServiceConfiguration configuration = VradiServiceConfiguration.getInstance(new String[0]);
            Properties flatProperties = configuration.getFlatOptions();
            ServiceFactory.getWikittyService(flatProperties);
        }
        return vradiWikittyService;
    }

    public static synchronized WikittyService getWikittyService(Properties properties) {
        if (vradiWikittyService == null) {
            WikittyExtensionStorageJDBC extensionStorage = new WikittyExtensionStorageJDBC(properties);
            WikittyStorageJDBC wikittyStorage = new WikittyStorageJDBC((WikittyExtensionStorage)extensionStorage, properties);
            WikittySearchEnginSolr searchEngin = new WikittySearchEnginSolr((WikittyExtensionStorage)extensionStorage);
            WikittyServiceImpl service = new WikittyServiceImpl((WikittyExtensionStorage)extensionStorage, (WikittyStorage)wikittyStorage, (WikittySearchEngin)searchEngin);
            WikittyServiceNotifier serviceNotifier = new WikittyServiceNotifier((WikittyService)service, properties);
            vradiWikittyService = new WikittyServiceCached((WikittyService)serviceNotifier, properties);
        }
        return vradiWikittyService;
    }

    public static synchronized WikittyProxy getWikittyProxy() {
        if (wikittyProxy == null) {
            WikittyService serviceCache = ServiceFactory.getWikittyService();
            wikittyProxy = new WikittyProxy(serviceCache);
            ServiceFactory.updateExtensions(wikittyProxy);
            ServiceFactory.reindexData(wikittyProxy);
        }
        return wikittyProxy;
    }

    static void updateExtensions(WikittyProxy localWikittyProxy) {
        List<WikittyExtension> extensions = Arrays.asList(ClientImpl.extensionClient, FormImpl.extensionForm, GroupImpl.extensionGroup, InfogeneImpl.extensionInfogene, ModificationTagImpl.extensionModificationTag, QueryMakerImpl.extensionQueryMaker, RootThesaurusImpl.extensionRootThesaurus, SendingImpl.extensionSending, SessionImpl.extensionSession, StatusImpl.extensionStatus, ThesaurusImpl.extensionThesaurus, WikittyTreeNodeImpl.extensionWikittyTreeNode, UserImpl.extensionUser, VradiUserImpl.extensionVradiUser, WebHarvestStreamImpl.extensionWebHarvestStream, WikittyUserImpl.extensionWikittyUser, XmlFieldBindingImpl.extensionXmlFieldBinding, XmlStreamImpl.extensionXmlStream, GroupFormsImpl.extensionGroupForms);
        localWikittyProxy.storeExtension(extensions);
    }

    protected static void reindexData(WikittyProxy localWikittyProxy) {
        try {
            VradiServiceConfiguration configuration = VradiServiceConfiguration.getInstance(new String[0]);
            String currentVersion = configuration.getApplicationVersion();
            String lastVersion = configuration.getServiceVersion();
            if (!currentVersion.equals(lastVersion)) {
                ServiceMigration.versionChangeMigration(lastVersion, currentVersion, localWikittyProxy);
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n._((String)"Version change detected : %s. Reindexing data...", (Object[])new Object[]{lastVersion}));
                }
                long timeBefore = System.currentTimeMillis();
                localWikittyProxy.syncEngin();
                long timeAfter = System.currentTimeMillis();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Reindexing completed in " + (timeAfter - timeBefore) + " ms"));
                }
                configuration.setServiceVersion(currentVersion);
                configuration.saveForUser(new String[0]);
            } else if (log.isInfoEnabled()) {
                log.info((Object)"No version change, skipping reindexing.");
            }
            ServiceMigration.configureMigration();
        }
        catch (Exception eee) {
            log.error((Object)"Failled to reindex data : ", (Throwable)eee);
        }
    }

    static {
        wikittyProxy = null;
        try {
            ConverterUtil.initConverters();
            ConvertUtils.register((Converter)new LocaleConverter(), Locale.class);
            VradiServiceConfiguration config = VradiServiceConfiguration.getInstance(new String[0]);
            I18n.init((Locale)config.getLocale());
        }
        catch (Exception eee) {
            log.error((Object)"Cant initialize Service factory : ", (Throwable)eee);
        }
    }
}

